/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.LogSiteKey;
import com.google.appengine.repackaged.com.google.common.flogger.LogSiteMap;
import com.google.appengine.repackaged.com.google.common.flogger.RateLimitStatus;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class CountingRateLimiter
extends RateLimitStatus {
    private static final LogSiteMap<CountingRateLimiter> map = new LogSiteMap<CountingRateLimiter>(){

        @Override
        protected CountingRateLimiter initialValue() {
            return new CountingRateLimiter();
        }
    };
    private final AtomicLong invocationCount = new AtomicLong(Integer.MAX_VALUE);

    @NullableDecl
    static RateLimitStatus check(Metadata metadata, LogSiteKey logSiteKey) {
        Integer rateLimitCount = metadata.findValue(LogContext.Key.LOG_EVERY_N);
        if (rateLimitCount == null) {
            return null;
        }
        return map.get(logSiteKey, metadata).incrementAndCheckLogCount(rateLimitCount);
    }

    CountingRateLimiter() {
    }

    RateLimitStatus incrementAndCheckLogCount(int rateLimitCount) {
        return this.invocationCount.incrementAndGet() >= (long)rateLimitCount ? this : DISALLOW;
    }

    @Override
    public void reset() {
        this.invocationCount.set(0L);
    }
}

