/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.init;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public final class AppEngineWebXmlInitialParse {
    private static final Logger logger = Logger.getLogger(AppEngineWebXmlInitialParse.class.getName());
    private String runtimeId = "";
    private boolean settingDoneInAppEngineWebXml = false;
    private final String file;
    private static final String PROPERTIES = "system-properties";
    private static final String PROPERTY = "property";
    private static final String RUNTIME = "runtime";
    public static final String GIT_HASH;
    public static final String BUILD_TIMESTAMP;
    private static final String BUILD_VERSION;
    private static final Properties BUILD_PROPERTIES;

    public void handleRuntimeProperties() {
        if (Objects.equals(System.getenv("EXPERIMENT_ENABLE_HTTP_CONNECTOR_FOR_JAVA"), "true") && !Objects.equals(System.getenv("GAE_RUNTIME"), "java8")) {
            System.setProperty("appengine.ignore.cancelerror", "true");
            System.setProperty("appengine.use.HttpConnector", "true");
        }
        try (FileInputStream stream = new FileInputStream(this.file);){
            XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
            while (reader.hasNext()) {
                XMLEvent runtime;
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(PROPERTIES)) {
                    this.setAppEngineUseProperties(reader);
                    continue;
                }
                if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals(RUNTIME) || !(runtime = reader.nextEvent()).isCharacters()) continue;
                this.runtimeId = runtime.asCharacters().getData();
            }
        }
        catch (IOException | XMLStreamException e) {
            logger.log(Level.WARNING, "Cannot parse correctly {0}", this.file);
        }
        if (!this.settingDoneInAppEngineWebXml && this.runtimeId != null) {
            switch (this.runtimeId) {
                case "java21": {
                    System.clearProperty("appengine.use.EE8");
                    System.setProperty("appengine.use.EE10", "true");
                    break;
                }
                case "java17": {
                    if (!Objects.equals(System.getenv("EXPERIMENT_ENABLE_JETTY12_FOR_JAVA"), "true")) break;
                    System.setProperty("appengine.use.EE8", "true");
                    break;
                }
                case "java11": 
                case "java8": {
                    System.clearProperty("appengine.use.EE8");
                    System.clearProperty("appengine.use.EE10");
                    break;
                }
            }
        }
    }

    private void setAppEngineUseProperties(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            StartElement element;
            String elementName;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(PROPERTIES)) {
                return;
            }
            if (!event.isStartElement() || !(elementName = (element = event.asStartElement()).getName().getLocalPart()).equals(PROPERTY)) continue;
            String prop = element.getAttributeByName(new QName("name")).getValue();
            String value = element.getAttributeByName(new QName("value")).getValue();
            if (prop.equals("appengine.use.EE8") || prop.equals("appengine.use.EE10")) {
                this.settingDoneInAppEngineWebXml = true;
                System.setProperty(prop, value);
                continue;
            }
            if (prop.equalsIgnoreCase("appengine.use.HttpConnector") && !Objects.equals(System.getenv("GAE_RUNTIME"), "java8")) {
                System.setProperty("appengine.use.HttpConnector", value);
                continue;
            }
            if (prop.equalsIgnoreCase("appengine.use.allheaders")) {
                System.setProperty("appengine.use.allheaders", value);
                continue;
            }
            if (!prop.equalsIgnoreCase("appengine.ignore.responseSizeLimit")) continue;
            System.setProperty("appengine.ignore.responseSizeLimit", value);
        }
    }

    public AppEngineWebXmlInitialParse(String file) {
        this.file = file;
        if (!GIT_HASH.equals("unknown")) {
            logger.log(Level.INFO, "appengine runtime jars built on {0} from commit {1}, version {2}", new Object[]{BUILD_TIMESTAMP, GIT_HASH, BUILD_VERSION});
        }
    }

    static {
        BUILD_PROPERTIES = new Properties();
        try (InputStream inputStream = AppEngineWebXmlInitialParse.class.getResourceAsStream("/com/google/appengine/init/build.properties");){
            BUILD_PROPERTIES.load(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GIT_HASH = BUILD_PROPERTIES.getProperty("buildNumber", "unknown");
        System.setProperty("appengine.git.hash", GIT_HASH);
        BUILD_TIMESTAMP = BUILD_PROPERTIES.getProperty("timestamp", "unknown");
        BUILD_VERSION = BUILD_PROPERTIES.getProperty("version", "unknown");
    }
}

