/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.LogSiteKey;
import com.google.appengine.repackaged.com.google.common.flogger.LogSiteMap;
import com.google.appengine.repackaged.com.google.common.flogger.RateLimitStatus;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.Nullable;

final class DurationRateLimiter
extends RateLimitStatus {
    private static final LogSiteMap<DurationRateLimiter> map = new LogSiteMap<DurationRateLimiter>(){

        @Override
        protected DurationRateLimiter initialValue() {
            return new DurationRateLimiter();
        }
    };
    private final AtomicLong lastTimestampNanos = new AtomicLong(-1L);

    static RateLimitPeriod newRateLimitPeriod(int n, TimeUnit unit) {
        return new RateLimitPeriod(n, unit);
    }

    static @Nullable RateLimitStatus check(Metadata metadata, LogSiteKey logSiteKey, long timestampNanos) {
        RateLimitPeriod rateLimitPeriod = metadata.findValue(LogContext.Key.LOG_AT_MOST_EVERY);
        if (rateLimitPeriod == null) {
            return null;
        }
        return map.get(logSiteKey, metadata).checkLastTimestamp(timestampNanos, rateLimitPeriod);
    }

    DurationRateLimiter() {
    }

    RateLimitStatus checkLastTimestamp(long timestampNanos, RateLimitPeriod period) {
        long deadlineNanos;
        Checks.checkArgument(timestampNanos >= 0L, "timestamp cannot be negative");
        long lastNanos = this.lastTimestampNanos.get();
        if (lastNanos >= 0L && ((deadlineNanos = lastNanos + period.toNanos()) < 0L || timestampNanos < deadlineNanos)) {
            return DISALLOW;
        }
        this.lastTimestampNanos.compareAndSet(lastNanos, -timestampNanos);
        return this;
    }

    @Override
    public void reset() {
        this.lastTimestampNanos.set(Math.max(-this.lastTimestampNanos.get(), 0L));
    }

    static final class RateLimitPeriod {
        private final int n;
        private final TimeUnit unit;

        private RateLimitPeriod(int n, TimeUnit unit) {
            if (n <= 0) {
                throw new IllegalArgumentException("time period must be positive: " + n);
            }
            this.n = n;
            this.unit = Checks.checkNotNull(unit, "time unit");
        }

        private long toNanos() {
            return this.unit.toNanos(this.n);
        }

        public String toString() {
            return this.n + " " + (Object)((Object)this.unit);
        }

        public int hashCode() {
            return this.n * 37 ^ this.unit.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof RateLimitPeriod) {
                RateLimitPeriod that = (RateLimitPeriod)obj;
                return this.n == that.n && this.unit == that.unit;
            }
            return false;
        }
    }
}

