/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.flogger.LogSiteKey;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import java.io.File;
import org.jspecify.annotations.Nullable;

public abstract class LogSite
implements LogSiteKey {
    public static final int UNKNOWN_LINE = 0;
    public static final LogSite INVALID = new LogSite(){

        @Override
        public String getClassName() {
            return "<unknown class>";
        }

        @Override
        public String getMethodName() {
            return "<unknown method>";
        }

        @Override
        public int getLineNumber() {
            return 0;
        }

        @Override
        public @Nullable String getFileName() {
            return null;
        }
    };

    public abstract String getClassName();

    public abstract String getMethodName();

    public abstract int getLineNumber();

    public abstract @Nullable String getFileName();

    public final String toString() {
        StringBuilder out = new StringBuilder().append("LogSite{ class=").append(this.getClassName()).append(", method=").append(this.getMethodName()).append(", line=").append(this.getLineNumber());
        if (this.getFileName() != null) {
            out.append(", file=").append(this.getFileName());
        }
        return out.append(" }").toString();
    }

    @Deprecated
    public static LogSite injectedLogSite(String internalClassName, String methodName, int encodedLineNumber, @Nullable String sourceFilePath) {
        return new InjectedLogSite(internalClassName, methodName, encodedLineNumber, sourceFilePath);
    }

    private static final class InjectedLogSite
    extends LogSite {
        private final String internalClassName;
        private final String methodName;
        private final int encodedLineNumber;
        private final @Nullable String sourceFilePath;
        private int hashcode = 0;

        private InjectedLogSite(String internalClassName, String methodName, int encodedLineNumber, @Nullable String sourceFilePath) {
            this.internalClassName = Checks.checkNotNull(internalClassName, "class name");
            this.methodName = Checks.checkNotNull(methodName, "method name");
            this.encodedLineNumber = encodedLineNumber;
            this.sourceFilePath = sourceFilePath;
        }

        @Override
        public String getClassName() {
            return this.internalClassName.replace('/', '.');
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public int getLineNumber() {
            return this.encodedLineNumber & 0xFFFF;
        }

        @Override
        public @Nullable String getFileName() {
            if (this.sourceFilePath == null) {
                return null;
            }
            return this.sourceFilePath.substring(this.sourceFilePath.lastIndexOf(File.separatorChar) + 1);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof InjectedLogSite) {
                InjectedLogSite other = (InjectedLogSite)obj;
                return this.methodName.equals(other.methodName) && this.encodedLineNumber == other.encodedLineNumber && InjectedLogSite.internalNamesCompatible(this.internalClassName, other.internalClassName);
            }
            return false;
        }

        private static boolean internalNamesCompatible(String s1, String s2) {
            if (s1 == s2) {
                return true;
            }
            if (s1.length() != s2.length()) {
                return false;
            }
            for (int i = 0; i < s1.length(); ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 & 0xFFFFFFFE) == 46 && (c1 ^ c2) == 1) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                int temp = 157;
                temp = 31 * temp + this.methodName.hashCode();
                this.hashcode = temp = 31 * temp + this.encodedLineNumber;
            }
            return this.hashcode;
        }
    }
}

