/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.modules.ModulesException;
import com.google.appengine.api.modules.ModulesService;
import com.google.appengine.api.modules.ModulesServiceFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.tools.development.BackendServersBase;
import com.google.appengine.tools.development.DevAppServerModulesFilter;
import com.google.appengine.tools.development.Modules;
import com.google.appengine.tools.development.ModulesFilterHelper;
import com.google.apphosting.api.ApiProxy;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DevAppServerModulesCommon {
    protected static final String BACKEND_REDIRECT_ATTRIBUTE = "com.google.appengine.backend.BackendName";
    protected static final String BACKEND_INSTANCE_REDIRECT_ATTRIBUTE = "com.google.appengine.backend.BackendInstance";
    @VisibleForTesting
    protected static final String MODULE_INSTANCE_REDIRECT_ATTRIBUTE = "com.google.appengine.module.ModuleInstance";
    protected final BackendServersBase backendServersManager;
    protected final ModulesService modulesService;
    protected final Logger logger = Logger.getLogger(DevAppServerModulesFilter.class.getName());

    @VisibleForTesting
    protected DevAppServerModulesCommon(BackendServersBase backendServers, ModulesService modulesService) {
        this.backendServersManager = backendServers;
        this.modulesService = modulesService;
    }

    public DevAppServerModulesCommon() {
        this(BackendServersBase.getInstance(), ModulesServiceFactory.getModulesService());
    }

    protected boolean isLoadBalancingRequest() {
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        String module = this.modulesService.getCurrentModule();
        int instance = this.getCurrentModuleInstance();
        return modulesFilterHelper.isLoadBalancingInstance(module, instance);
    }

    protected boolean expectsGeneratedStartRequests(String backendName, int requestPort) {
        String moduleOrBackendName = backendName;
        if (moduleOrBackendName == null) {
            moduleOrBackendName = this.modulesService.getCurrentModule();
        }
        int instance = backendName == null ? this.getCurrentModuleInstance() : this.backendServersManager.getServerInstanceFromPort(requestPort);
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        return modulesFilterHelper.expectsGeneratedStartRequests(moduleOrBackendName, instance);
    }

    protected int getCurrentModuleInstance() {
        String instance = "-1";
        try {
            instance = this.modulesService.getCurrentInstanceId();
        }
        catch (ModulesException me) {
            this.logger.log(Level.FINEST, "Ignoring Exception getting module instance and continuing", me);
        }
        return Integer.parseInt(instance);
    }

    protected ModulesFilterHelper getModulesFilterHelper() {
        Map attributes = ApiProxy.getCurrentEnvironment().getAttributes();
        return (ModulesFilterHelper)attributes.get("com.google.appengine.tools.development.modules_filter_helper");
    }

    protected void injectApiInfo(String backendName, int instance) {
        Map portMapping = this.backendServersManager.getPortMapping();
        if (portMapping == null) {
            throw new IllegalStateException("backendServersManager.getPortMapping() is null");
        }
        DevAppServerModulesCommon.injectBackendServiceCurrentApiInfo(backendName, instance, portMapping);
        Map threadLocalAttributes = ApiProxy.getCurrentEnvironment().getAttributes();
        if (!portMapping.isEmpty()) {
            threadLocalAttributes.put("com.google.appengine.dev.backend_controller", this.backendServersManager);
        }
        threadLocalAttributes.put("com.google.appengine.dev.modules_controller", Modules.getInstance());
    }

    public static void injectBackendServiceCurrentApiInfo(String backendName, int backendInstance, Map<String, String> portMapping) {
        Map threadLocalAttributes = ApiProxy.getCurrentEnvironment().getAttributes();
        if (backendInstance != -1) {
            threadLocalAttributes.put("com.google.appengine.instance.id", backendInstance + "");
        }
        if (backendName != null) {
            threadLocalAttributes.put("com.google.appengine.backend.id", backendName);
        }
        threadLocalAttributes.put("com.google.appengine.devappserver.portmapping", portMapping);
    }

    @VisibleForTesting
    public static enum RequestType {
        DIRECT_MODULE_REQUEST,
        REDIRECT_REQUESTED,
        DIRECT_BACKEND_REQUEST,
        REDIRECTED_BACKEND_REQUEST,
        REDIRECTED_MODULE_REQUEST,
        STARTUP_REQUEST;

    }
}

