/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.system;

import com.google.appengine.repackaged.com.google.common.flogger.backend.LoggerBackend;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Platform;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.BackendFactory;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.Clock;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.SimpleBackendFactory;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.StackBasedCallerFinder;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.SystemClock;
import com.google.appengine.repackaged.com.google.common.flogger.context.ContextDataProvider;
import com.google.appengine.repackaged.com.google.common.flogger.util.StaticMethodCaller;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class DefaultPlatform
extends Platform {
    private static final String BACKEND_FACTORY = "flogger.backend_factory";
    private static final String CONTEXT_DATA_PROVIDER = "flogger.logging_context";
    private static final String CLOCK = "flogger.clock";
    private final BackendFactory backendFactory;
    private final ContextDataProvider context;
    private final Clock clock;
    private final Platform.LogCallerFinder callerFinder;

    public DefaultPlatform() {
        BackendFactory backendFactory = DefaultPlatform.loadService(BackendFactory.class, BACKEND_FACTORY);
        this.backendFactory = backendFactory != null ? backendFactory : SimpleBackendFactory.getInstance();
        ContextDataProvider contextDataProvider = DefaultPlatform.loadService(ContextDataProvider.class, CONTEXT_DATA_PROVIDER);
        this.context = contextDataProvider != null ? contextDataProvider : ContextDataProvider.getNoOpProvider();
        Clock clock = DefaultPlatform.loadService(Clock.class, CLOCK);
        this.clock = clock != null ? clock : SystemClock.getInstance();
        this.callerFinder = StackBasedCallerFinder.getInstance();
    }

    @NullableDecl
    private static <S> S loadService(Class<S> serviceType, String systemProperty) {
        S service = StaticMethodCaller.getInstanceFromSystemProperty(systemProperty, serviceType);
        if (service != null) {
            return service;
        }
        ArrayList<S> loadedServices = new ArrayList<S>();
        for (S loaded : ServiceLoader.load(serviceType)) {
            loadedServices.add(loaded);
        }
        switch (loadedServices.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (S)loadedServices.get(0);
            }
        }
        System.err.printf("Multiple implementations of service %s found on the classpath: %s%nEnsure only the service implementation you want to use is included on the classpath or else specify the service class at startup with the '%s' system property. The default implementation will be used instead.%n", serviceType.getName(), loadedServices, systemProperty);
        return null;
    }

    DefaultPlatform(BackendFactory factory, ContextDataProvider context, Clock clock, Platform.LogCallerFinder callerFinder) {
        this.backendFactory = factory;
        this.context = context;
        this.clock = clock;
        this.callerFinder = callerFinder;
    }

    @Override
    protected Platform.LogCallerFinder getCallerFinderImpl() {
        return this.callerFinder;
    }

    @Override
    protected LoggerBackend getBackendImpl(String className) {
        return this.backendFactory.create(className);
    }

    @Override
    protected ContextDataProvider getContextDataProviderImpl() {
        return this.context;
    }

    @Override
    protected long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    @Override
    protected String getConfigInfoImpl() {
        return "Platform: " + this.getClass().getName() + "\nBackendFactory: " + this.backendFactory + "\nClock: " + this.clock + "\nContextDataProvider: " + this.context + "\nLogCallerFinder: " + this.callerFinder + "\n";
    }
}

