/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.devappserver2;

import com.google.appengine.tools.development.DevLogService;
import com.google.appengine.tools.development.DevServices;
import com.google.appengine.tools.development.devappserver2.RemoteApiDelegate;
import com.google.appengine.tools.development.devappserver2.RemoteRpc;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.apphosting.api.ApiProxy;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

class DevAppServer2Delegate
implements ApiProxy.Delegate<ApiProxy.Environment>,
DevServices {
    private final ThreadLocal<RemoteApiDelegate> threadLocalRemoteApiDelegate = new ThreadLocal();
    private final RemoteApiOptions remoteApiOptions;

    DevAppServer2Delegate(RemoteApiOptions remoteApiOptions) {
        this.remoteApiOptions = remoteApiOptions;
    }

    private synchronized ApiProxy.Delegate<ApiProxy.Environment> remoteApiDelegate() {
        RemoteApiDelegate delegate = this.threadLocalRemoteApiDelegate.get();
        if (delegate == null) {
            RemoteRpc remoteRpc = new RemoteRpc(this.remoteApiOptions);
            delegate = new RemoteApiDelegate(remoteRpc, this.remoteApiOptions);
            this.threadLocalRemoteApiDelegate.set(delegate);
        }
        return delegate;
    }

    public byte[] makeSyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] request) {
        return this.remoteApiDelegate().makeSyncCall(environment, packageName, methodName, request);
    }

    public Future<byte[]> makeAsyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] request, ApiProxy.ApiConfig apiConfig) {
        return this.remoteApiDelegate().makeAsyncCall(environment, packageName, methodName, request, apiConfig);
    }

    public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
        this.remoteApiDelegate().log(environment, record);
    }

    public void flushLogs(ApiProxy.Environment environment) {
        this.remoteApiDelegate().flushLogs(environment);
    }

    public List<Thread> getRequestThreads(ApiProxy.Environment environment) {
        return this.remoteApiDelegate().getRequestThreads(environment);
    }

    public DevLogService getLogService() {
        return new DevLogServiceImpl();
    }

    private static class DevLogServiceImpl
    implements DevLogService {
        private static StreamHandler streamHandler;

        private DevLogServiceImpl() {
        }

        private static synchronized StreamHandler getStreamHandler() {
            if (streamHandler == null) {
                streamHandler = new ConsoleHandler();
                streamHandler.setFormatter(new Formatter(){

                    @Override
                    public String format(LogRecord record) {
                        return record.getMessage() + "\n";
                    }
                });
            }
            return streamHandler;
        }

        public Handler getLogHandler() {
            return DevLogServiceImpl.getStreamHandler();
        }
    }
}

