/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.protobuf.AbstractParser;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protobuf.TextFormat;
import com.google.io.protocol.CategoryInformation;
import com.google.io.protocol.ProtocolMessage;
import com.google.io.protocol.ProtocolSink;
import com.google.io.protocol.ProtocolSource;
import com.google.io.protocol.ProtocolType;
import java.io.IOException;
import java.util.regex.Pattern;

public class DowngradedMessage
extends ProtocolMessage<DowngradedMessage> {
    private static final Pattern NEWLINE_SPACES_PATTERN = Pattern.compile("\n *");
    private Message message;
    private final ExtensionRegistry extensionRegistry;
    static final CategoryInformation<DowngradedMessage> CATEGORY_INFORMATION = new CategoryInformation<DowngradedMessage>(){

        public String getSimpleClassName(DowngradedMessage message) {
            return message.message.getDescriptorForType().getName();
        }

        public String getFullClassName(DowngradedMessage message) {
            return message.message.getDescriptorForType().getFullName();
        }

        public DowngradedMessage parse(CharSequence text, DowngradedMessage message) {
            try {
                if (message.message instanceof MutableMessage) {
                    TextFormat.merge(text, message.extensionRegistry, (MutableMessage)message.message);
                } else {
                    Message.Builder builder = message.message.newBuilderForType();
                    TextFormat.merge(text, message.extensionRegistry, builder);
                    message.message = builder.build();
                }
                return message;
            }
            catch (TextFormat.ParseException e) {
                throw new RuntimeException("ParseException: " + e.getMessage());
            }
        }
    };

    public DowngradedMessage() {
        throw new UnsupportedOperationException();
    }

    public DowngradedMessage(MessageLite message) {
        this(message, ExtensionRegistry.getEmptyRegistry());
    }

    public DowngradedMessage(MessageLite message, ExtensionRegistry registry) {
        this((Message)message, registry);
    }

    public DowngradedMessage(Message message) {
        this(message, ExtensionRegistry.getEmptyRegistry());
    }

    public DowngradedMessage(Message message, ExtensionRegistry registry) {
        if (message == null) {
            throw new NullPointerException();
        }
        this.message = message;
        this.extensionRegistry = registry;
    }

    public DowngradedMessage getDefaultInstanceForType() {
        return new DowngradedMessage((Message)this.message.getDefaultInstanceForType(), this.extensionRegistry);
    }

    public Parser<DowngradedMessage> getParserForType() {
        return new AbstractParser<DowngradedMessage>(){

            @Override
            public DowngradedMessage parsePartialFrom(CodedInputStream input, ExtensionRegistryLite unusedRegistry) throws InvalidProtocolBufferException {
                try {
                    return new DowngradedMessage(DowngradedMessage.this.message.getParserForType().parsePartialFrom(input, (ExtensionRegistryLite)DowngradedMessage.this.extensionRegistry), DowngradedMessage.this.extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    if (e.getUnfinishedMessage() != null) {
                        e.setUnfinishedMessage((MessageLite)((Object)new DowngradedMessage(e.getUnfinishedMessage(), DowngradedMessage.this.extensionRegistry)));
                    }
                    throw e;
                }
            }
        };
    }

    public Message getProto2Message() {
        return this.message;
    }

    public void setProto2Message(MessageLite message) {
        this.message = (Message)message;
    }

    public int encodingSize() {
        return this.message.getSerializedSize();
    }

    public int maxEncodingSize() {
        return this.message.getSerializedSize();
    }

    protected DowngradedMessage internalClear() {
        this.message = this.message.getDefaultInstanceForType();
        return this;
    }

    public int hashCode() {
        return this.message.toByteString().hashCode();
    }

    public boolean equals(Object that) {
        return that instanceof DowngradedMessage && this.message.equals(((DowngradedMessage)((Object)that)).message);
    }

    public boolean equals(DowngradedMessage that) {
        return this.equals(that, false);
    }

    public boolean equalsIgnoreUninterpreted(DowngradedMessage that) {
        return this.equals(that, true);
    }

    public boolean equals(DowngradedMessage that, boolean ignoreUninterpreted) {
        ByteString string1 = this.message.toByteString();
        ByteString string2 = that.message.toByteString();
        return string1.equals(string2);
    }

    public String findInitializationError() {
        return this.message.isInitialized() ? null : "Required field(s) not set: " + this.message.getInitializationErrorString();
    }

    public boolean isInitialized() {
        return this.message.isInitialized();
    }

    public ProtocolType getProtocolType() {
        throw new UnsupportedOperationException();
    }

    protected boolean merge(ProtocolSource source) {
        CodedInputStream input = CodedInputStream.newInstance(source.array(), source.position(), source.remaining());
        if (this.mergeFrom(input)) {
            source.skip(input.getTotalBytesRead());
            return true;
        }
        return false;
    }

    public boolean mergeFrom(CodedInputStream input) {
        if (this.message == this.message.getDefaultInstanceForType()) {
            try {
                this.message = this.message.getParserForType().parsePartialFrom(input, (ExtensionRegistryLite)this.extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                return false;
            }
        }
        if (this.message instanceof MutableMessage) {
            ((MutableMessage)this.message).mergeFrom(input, (ExtensionRegistryLite)this.extensionRegistry);
        } else {
            Message.Builder builder = this.message.toBuilder();
            try {
                builder.mergeFrom(input, (ExtensionRegistryLite)this.extensionRegistry);
            }
            catch (IOException e) {
                return false;
            }
            this.message = builder.buildPartial();
        }
        return true;
    }

    public DowngradedMessage mergeFrom(DowngradedMessage that) {
        this.message = this.message instanceof MutableMessage ? ((MutableMessage)this.message).mergeFrom((MutableMessage)that.message) : this.message.toBuilder().mergeFrom(that.message).buildPartial();
        return this;
    }

    public DowngradedMessage newInstance() {
        return new DowngradedMessage((Message)this.message.getDefaultInstanceForType(), this.extensionRegistry);
    }

    public void outputTo(ProtocolSink sink) {
        byte[] buffer = sink.array();
        int pos = sink.position();
        int len = buffer.length - pos;
        CodedOutputStream os = CodedOutputStream.newInstance(buffer, pos, len);
        try {
            this.message.writeTo(os);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Cannot reach here");
        }
        sink.skip(len - os.spaceLeft());
    }

    public String toString() {
        return this.message.toString();
    }

    public String toFlatString() {
        return NEWLINE_SPACES_PATTERN.matcher(this.message.toString()).replaceAll(" ");
    }

    public CategoryInformation<DowngradedMessage> messageCategoryInformation() {
        return CATEGORY_INFORMATION;
    }
}

