/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.security.urlfetch;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class URLFetchServiceStreamHandler
extends URLStreamHandler {
    static final String DERIVE_RESPONSE_MESSAGE_PROPERTY = "appengine.urlfetch.deriveResponseMessage";
    static final String RESOLVE_INTERNAL_NATIVELY_PROPERTY = "com.google.appengine.urlfetch.resolve.internal.addresses.natively";
    private static final int DEFAULT_DEADLINE_MS = 5000;
    private static final ImmutableMap<Integer, String> HTTP_ERROR_CODES = new ImmutableMap.Builder<Integer, String>().put(100, "CONTINUE").put(101, "SWITCHING_PROTOCOLS").put(200, "OK").put(201, "CREATED").put(202, "ACCEPTED").put(203, "NON_AUTHORITATIVE_INFORMATION").put(204, "NO_CONTENT").put(205, "RESET_CONTENT").put(206, "PARTIAL_CONTENT").put(300, "MULTIPLE_CHOICES").put(301, "MOVED_PERMANENTLY").put(302, "FOUND").put(303, "SEE_OTHER").put(304, "NOT_MODIFIED").put(305, "USE_PROXY").put(307, "TEMPORARY_REDIRECT").put(400, "BAD_REQUEST").put(401, "UNAUTHORIZED").put(402, "PAYMENT_REQUIRED").put(403, "FORBIDDEN").put(404, "NOT_FOUND").put(405, "METHOD_NOT_ALLOWED").put(406, "NOT_ACCEPTABLE").put(407, "PROXY_AUTHENTICATION_REQUIRED").put(408, "REQUEST_TIMEOUT").put(409, "CONFLICT").put(410, "GONE").put(411, "LENGTH_REQUIRED").put(412, "PRECONDITION_FAILED").put(413, "REQUEST_ENTITY_TOO_LARGE").put(414, "REQUEST_URI_TOO_LONG").put(415, "UNSUPPORTED_MEDIA_TYPE").put(416, "REQUESTED_RANGE_NOT_SATISFIABLE").put(417, "EXPECTATION_FAILED").put(500, "INTERNAL_SERVER_ERROR").put(501, "NOT_IMPLEMENTED").put(502, "BAD_GATEWAY").put(503, "SERVICE_UNAVAILABLE").put(504, "GATEWAY_TIMEOUT").put(505, "HTTP_VERSION_NOT_SUPPORTED").put(426, "UPGRADE_REQUIRED").put(308, "PERMANENT_REDIRECT").put(102, "PROCESSING").put(207, "MULTI_STATUS").put(422, "UNPROCESSABLE_ENTITY").put(423, "LOCKED").put(424, "FAILED_DEPENDENCY").put(507, "INSUFFICIENT_STORAGE").put(509, "BANDWIDTH_LIMIT_EXCEEDED").put(428, "PRECONDITION_REQUIRED").put(429, "TOO_MANY_REQUESTS").put(431, "REQUEST_HEADER_FIELDS_TOO_LARGE").put(511, "NETWORK_AUTHENTICATION_REQUIRED").build();
    private static final Logger logger = Logger.getLogger(URLFetchServiceStreamHandler.class.getName());
    private static Constructor<? extends HttpURLConnection> httpURLConnectionConstructor;
    private static final Pattern INTERNAL;

    private static synchronized Constructor<? extends HttpURLConnection> getHttpURLConnectionConstructor() throws ReflectiveOperationException {
        if (httpURLConnectionConstructor == null) {
            Class<HttpURLConnection> httpURLConnectionClass = Class.forName("sun.net.www.protocol.http.HttpURLConnection").asSubclass(HttpURLConnection.class);
            httpURLConnectionConstructor = httpURLConnectionClass.getConstructor(URL.class, Proxy.class);
        }
        return httpURLConnectionConstructor;
    }

    private static HttpURLConnection openNativeConnection(URL u) throws IOException {
        try {
            return URLFetchServiceStreamHandler.getHttpURLConnectionConstructor().newInstance(u, null);
        }
        catch (ReflectiveOperationException e) {
            throw new IOException("Could not get HttpURLConnection constructor", e);
        }
    }

    @Override
    protected HttpURLConnection openConnection(URL u) throws IOException {
        if (this.shouldOpenNatively(u)) {
            return URLFetchServiceStreamHandler.openNativeConnection(u);
        }
        return new Connection(u);
    }

    @Override
    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
        if (p == null) {
            throw new IllegalArgumentException("p may not be null");
        }
        if (p.equals(Proxy.NO_PROXY)) {
            return this.openConnection(u);
        }
        throw new UnsupportedOperationException("Google App Engine does not support the use of proxies.");
    }

    private boolean shouldOpenNatively(URL url) {
        return Boolean.getBoolean(RESOLVE_INTERNAL_NATIVELY_PROPERTY) && URLFetchServiceStreamHandler.isInternalUrl(url);
    }

    static boolean isInternalUrl(URL url) {
        String host = url.getHost();
        if (host == null) {
            return false;
        }
        return INTERNAL.matcher(host).matches();
    }

    @Override
    protected synchronized InetAddress getHostAddress(URL u) {
        return null;
    }

    static String trim(String s) {
        if (s == null) {
            return null;
        }
        int notWhitespaceChar = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            notWhitespaceChar = i;
            break;
        }
        if (notWhitespaceChar != 0) {
            s = s.substring(notWhitespaceChar);
        }
        return s.trim();
    }

    static {
        INTERNAL = Pattern.compile("(?x: .+\\.internal | (.*:)? 169\\.254\\.\\d+\\.\\d+ )");
    }

    static class Connection
    extends HttpURLConnection {
        private final URLFetchService service = URLFetchServiceFactory.getURLFetchService();
        private HTTPResponse response;
        private LinkedHashMap<String, List<String>> responseFields;
        private BufferingOutputStream outputStream;
        private InputStream inputStream;
        private final LinkedHashMap<String, List<String>> requestProperties = new LinkedHashMap();

        public Connection(URL url) {
            super(url);
            int deadlineMs = DeadlineParser.INSTANCE.deadlineMs;
            if (deadlineMs == -1) {
                deadlineMs = 5000;
            }
            this.setConnectTimeout(deadlineMs);
            this.setReadTimeout(1);
        }

        @Override
        public void disconnect() {
            this.connected = false;
        }

        private boolean isConnected() {
            return this.connected;
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void setChunkedStreamingMode(int chunklen) {
            super.setChunkedStreamingMode(chunklen);
        }

        @Override
        public void setRequestMethod(String method) throws ProtocolException {
            method = method.toUpperCase();
            try {
                HTTPMethod.valueOf((String)method);
            }
            catch (IllegalArgumentException e) {
                throw new ProtocolException(method + " is not one of the supported http methods: " + Arrays.asList(HTTPMethod.values()));
            }
            super.setRequestMethod(method);
        }

        @Override
        public int getResponseCode() throws IOException {
            this.getInputStream();
            return this.responseCode;
        }

        @Override
        public String getResponseMessage() {
            return DeriveResponseMessageProperty.INSTANCE && HTTP_ERROR_CODES.containsKey(this.responseCode) ? (String)HTTP_ERROR_CODES.get(this.responseCode) : "OK";
        }

        @Override
        public InputStream getErrorStream() {
            if (this.connected && this.responseCode >= 400) {
                return this.inputStream;
            }
            return null;
        }

        @Override
        public void connect() throws IOException {
            if (this.connected) {
                return;
            }
            this.connected = true;
        }

        @Override
        public String getHeaderField(String name) {
            List fieldValues = (List)((LinkedHashMap)this.getHeaderFields()).get(name.toLowerCase());
            if (fieldValues == null) {
                return null;
            }
            return (String)fieldValues.get(fieldValues.size() - 1);
        }

        public LinkedHashMap<String, List<String>> getHeaderFields() {
            try {
                this.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to complete the HTTP request", e);
            }
            return this.responseFields;
        }

        @Override
        public void setRequestProperty(String key, String value) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.requestProperties.put(key, values);
            super.setRequestProperty(key, value);
        }

        @Override
        public void addRequestProperty(String key, String value) {
            List<String> values = this.requestProperties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.requestProperties.put(key, values);
            }
            values.add(value);
            super.addRequestProperty(key, value);
        }

        @Override
        public String getHeaderFieldKey(int n) {
            Map.Entry<String, List<String>> entry = this.getNthEntry(n);
            if (entry != null) {
                return entry.getKey();
            }
            return null;
        }

        @Override
        public String getHeaderField(int n) {
            List<String> values;
            Map.Entry<String, List<String>> entry = this.getNthEntry(n);
            if (entry != null && (values = entry.getValue()) != null) {
                return Joiner.on(",").useForNull("null").join(values);
            }
            return null;
        }

        @Override
        public Permission getPermission() throws IOException {
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            if (!this.getDoInput()) {
                String msg = "Input was not set on this URLConnection. Use \"setDoInput(true)\"";
                throw new IOException(msg);
            }
            this.fetchResponse();
            byte[] content = this.response.getContent();
            if (content == null) {
                content = new byte[]{};
            }
            this.inputStream = new ByteArrayInputStream(content);
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.outputStream != null) {
                return this.outputStream;
            }
            if (!this.getDoOutput()) {
                String msg = "Output was not set on this URLConnection. Use \"setDoOutput(true)\"";
                throw new IOException(msg);
            }
            if (this.method.equalsIgnoreCase(HTTPMethod.GET.name())) {
                this.method = HTTPMethod.POST.name();
            }
            this.connect();
            this.outputStream = new BufferingOutputStream();
            return this.outputStream;
        }

        private Map.Entry<String, List<String>> getNthEntry(int n) {
            Iterator iterator = ((LinkedHashMap)this.getHeaderFields()).entrySet().iterator();
            Map.Entry last = null;
            for (int i = 0; i <= n; ++i) {
                if (!iterator.hasNext()) {
                    return null;
                }
                last = iterator.next();
            }
            return last;
        }

        private HTTPResponse fetchResponse() throws IOException {
            List<Object> values;
            if (this.response != null) {
                return this.response;
            }
            this.connect();
            String method = this.getRequestMethod();
            HTTPMethod httpMethod = HTTPMethod.valueOf((String)method);
            HTTPRequest request = new HTTPRequest(this.url, httpMethod);
            if (this.getInstanceFollowRedirects()) {
                request.getFetchOptions().followRedirects();
            } else {
                request.getFetchOptions().doNotFollowRedirects();
            }
            int connectTimeoutMillis = this.getConnectTimeout();
            int readTimeoutMillis = this.getReadTimeout();
            double deadlineSeconds = connectTimeoutMillis == 0 || readTimeoutMillis == 0 ? 2.147483647E9 : (double)(this.getConnectTimeout() + this.getReadTimeout()) / 1000.0;
            if (deadlineSeconds > 0.0) {
                request.getFetchOptions().setDeadline(Double.valueOf(deadlineSeconds));
            }
            for (Map.Entry<String, List<String>> entry : this.requestProperties.entrySet()) {
                String name = entry.getKey();
                values = new ArrayList(entry.getValue());
                for (String string : values) {
                    request.addHeader(new HTTPHeader(name, string));
                }
            }
            if (this.outputStream != null) {
                byte[] output = this.outputStream.toByteArray();
                this.outputStream.close();
                request.setPayload(output);
            }
            this.response = this.service.fetch(request);
            this.responseCode = this.response.getResponseCode();
            if (this.response.getFinalUrl() != null) {
                this.url = this.response.getFinalUrl();
            }
            List headers = this.response.getHeadersUncombined();
            this.responseFields = Maps.newLinkedHashMapWithExpectedSize(headers.size());
            for (HTTPHeader header : headers) {
                values = this.responseFields.get(header.getName().toLowerCase());
                if (values == null) {
                    values = new ArrayList();
                    this.responseFields.put(header.getName().toLowerCase(), values);
                }
                values.add(header.getValue().trim());
            }
            return this.response;
        }

        private class BufferingOutputStream
        extends OutputStream {
            private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            private boolean closed;

            @Override
            public void write(int b) throws IOException {
                this.checkOpen();
                this.buffer.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.checkOpen();
                this.buffer.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.checkOpen();
                this.buffer.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.checkOpen();
                this.buffer.flush();
            }

            @Override
            public void close() throws IOException {
                this.buffer.close();
                this.closed = true;
                if (!Connection.this.isConnected() && !Connection.this.getDoInput()) {
                    Connection.this.fetchResponse();
                }
            }

            public byte[] toByteArray() {
                return this.buffer.toByteArray();
            }

            private void checkOpen() throws IOException {
                if (this.closed) {
                    String msg = "The OutputStream has been committed and can no longer be written to.";
                    throw new IOException(msg);
                }
            }
        }

        static class DeadlineParser {
            static final DeadlineParser INSTANCE = new DeadlineParser();
            volatile int deadlineMs = -1;

            private DeadlineParser() {
                this.refresh();
            }

            void refresh() {
                String globalDefault = System.getProperty("appengine.api.urlfetch.defaultDeadline");
                if (globalDefault != null) {
                    try {
                        this.deadlineMs = (int)(Double.parseDouble(globalDefault) * 1000.0);
                    }
                    catch (NumberFormatException e) {
                        this.deadlineMs = -1;
                        logger.warning("Cannot parse deadline: " + globalDefault);
                    }
                } else {
                    this.deadlineMs = -1;
                }
            }
        }
    }

    private static class DeriveResponseMessageProperty {
        static final boolean INSTANCE = Boolean.getBoolean("appengine.urlfetch.deriveResponseMessage");

        private DeriveResponseMessageProperty() {
        }
    }
}

