/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.devappserver2;

import com.google.appengine.tools.development.devappserver2.RemoteRpc;
import com.google.appengine.tools.development.devappserver2.RequestIdFilter;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.apphosting.api.ApiProxy;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

class RemoteApiDelegate
implements ApiProxy.Delegate<ApiProxy.Environment> {
    private static final Logger logger = Logger.getLogger(RemoteApiDelegate.class.getName());
    private final ExecutorService executor;
    private final RemoteRpc remoteRpc;

    RemoteApiDelegate(RemoteRpc rpc, RemoteApiOptions options) {
        this.executor = Executors.newFixedThreadPool(options.getMaxConcurrentRequests());
        this.remoteRpc = new RemoteRpc(options);
    }

    public byte[] makeSyncCall(ApiProxy.Environment env, String serviceName, String methodName, byte[] request) {
        String requestId = RequestIdFilter.threadRequestId();
        if (requestId == null) {
            requestId = "no-request-id";
        }
        return this.remoteRpc.call(serviceName, methodName, requestId, request);
    }

    public Future<byte[]> makeAsyncCall(final ApiProxy.Environment env, final String serviceName, final String methodName, final byte[] request, ApiProxy.ApiConfig apiConfig) {
        return this.executor.submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return RemoteApiDelegate.this.makeSyncCall(env, serviceName, methodName, request);
            }
        });
    }

    public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
        logger.log(RemoteApiDelegate.toJavaLevel(record.getLevel()), "[" + record.getTimestamp() + "] " + record.getMessage());
    }

    public List<Thread> getRequestThreads(ApiProxy.Environment environment) {
        return Collections.emptyList();
    }

    public void flushLogs(ApiProxy.Environment environment) {
    }

    private static Level toJavaLevel(ApiProxy.LogRecord.Level apiProxyLevel) {
        switch (apiProxyLevel) {
            case debug: {
                return Level.FINE;
            }
            case info: {
                return Level.INFO;
            }
            case warn: {
                return Level.WARNING;
            }
            case error: {
                return Level.SEVERE;
            }
            case fatal: {
                return Level.SEVERE;
            }
        }
        return Level.WARNING;
    }
}

