/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend;

import com.google.appengine.repackaged.com.google.common.flogger.MetadataKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public final class KeyValueFormatter
implements MetadataKey.KeyValueHandler {
    private static final int NEWLINE_LIMIT = 1000;
    private static final Set<Class<?>> FUNDAMENTAL_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class));
    private final String prefix;
    private final String suffix;
    private final StringBuilder out;
    private boolean haveSeenValues = false;

    public static void appendJsonFormattedKeyAndValue(String label, @Nullable Object value, StringBuilder out) {
        out.append(label).append('=');
        if (value == null) {
            out.append(true);
        } else if (FUNDAMENTAL_TYPES.contains(value.getClass())) {
            out.append(value);
        } else {
            out.append('\"');
            KeyValueFormatter.appendEscaped(out, value.toString());
            out.append('\"');
        }
    }

    public KeyValueFormatter(String prefix, String suffix, StringBuilder out) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.out = out;
    }

    @Override
    public void handle(String label, @Nullable Object value) {
        if (this.haveSeenValues) {
            this.out.append(' ');
        } else {
            if (this.out.length() > 0) {
                this.out.append((char)(this.out.length() > 1000 || this.out.indexOf("\n") != -1 ? 10 : 32));
            }
            this.out.append(this.prefix);
            this.haveSeenValues = true;
        }
        KeyValueFormatter.appendJsonFormattedKeyAndValue(label, value, this.out);
    }

    public void done() {
        if (this.haveSeenValues) {
            this.out.append(this.suffix);
        }
    }

    private static void appendEscaped(StringBuilder out, String s) {
        int start = 0;
        int idx = KeyValueFormatter.nextEscapableChar(s, start);
        while (idx != -1) {
            block7: {
                out.append(s, start, idx);
                start = idx + 1;
                char c = s.charAt(idx);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    case '\n': {
                        c = 'n';
                        break;
                    }
                    case '\r': {
                        c = 'r';
                        break;
                    }
                    case '\t': {
                        c = 't';
                        break;
                    }
                    default: {
                        out.append('\ufffd');
                        break block7;
                    }
                }
                out.append("\\").append(c);
            }
            idx = KeyValueFormatter.nextEscapableChar(s, start);
        }
        out.append(s, start, s.length());
    }

    private static int nextEscapableChar(String s, int n) {
        while (n < s.length()) {
            char c = s.charAt(n);
            if (c < ' ' || c == '\"' || c == '\\') {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

