/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.tools.info.Jetty121EE8Sdk;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class Jetty121EE11Sdk
extends Jetty121EE8Sdk {
    private static final String WEB_DEFAULT_LOCATION_DEVAPPSERVERJETTY12EE11 = "com/google/appengine/tools/development/jetty/ee11/webdefault.xml";

    Jetty121EE11Sdk() {
    }

    @Override
    public List<File> getUserJspLibFiles() {
        return Collections.unmodifiableList(this.getJetty121JspJars());
    }

    @Override
    public String getWebDefaultLocation() {
        return WEB_DEFAULT_LOCATION_DEVAPPSERVERJETTY12EE11;
    }

    @Override
    public String getJettyContainerService() {
        return "com.google.appengine.tools.development.jetty.ee11.JettyContainerService";
    }

    @Override
    public String getBackendServersClassName() {
        return "com.google.appengine.tools.development.jakarta.BackendServers";
    }

    @Override
    public String getModulesClassName() {
        return "com.google.appengine.tools.development.jakarta.Modules";
    }

    @Override
    public String getDelegatingModulesFilterHelperClassName() {
        return "com.google.appengine.tools.development.jakarta.DelegatingModulesFilterHelper";
    }

    @Override
    public String getWebDefaultXml() {
        return String.valueOf(Jetty121EE11Sdk.getSdkRoot()) + "/docs/jetty121ee11/webdefault.xml";
    }

    @Override
    public List<File> getSharedJspLibFiles() {
        return Collections.unmodifiableList(this.getJetty121JspJars());
    }

    @Override
    public List<URL> getImplLibs() {
        return Collections.unmodifiableList(Jetty121EE11Sdk.toURLs(this.getImplLibFiles()));
    }

    @Override
    public String getQuickStartClasspath() {
        ArrayList<Object> list = new ArrayList<Object>();
        File quickstart = new File(Jetty121EE11Sdk.getSdkRoot(), "lib/tools/quickstart/quickstartgenerator-jetty121-ee11.jar");
        File jettyDir = new File(Jetty121EE11Sdk.getSdkRoot(), "jetty121/jetty-home/lib");
        for (File file : jettyDir.listFiles()) {
            if (file.isDirectory() || file.getName().contains("cdi-") || file.getName().contains("-alpn-") || file.getName().contains("-demo-") || file.getName().contains("-websocket-") || file.getName().contains("-gcloud-") || file.getName().contains("-infinispan-") || file.getName().contains("-hazelcast-") || file.getName().contains("-ethereum-") || file.getName().contains("jakarta.enterprise") || file.getName().contains("jakarta.inject") || file.getName().contains("jakarta.interceptor") || file.getName().contains("jakarta.servlet-api-6.") || file.getName().contains("jakarta.transaction") || file.getName().contains("ee8") || file.getName().contains("ee9") || file.getName().contains("ee10")) continue;
            list.add(file.getAbsolutePath());
        }
        list.add(String.valueOf(Jetty121EE11Sdk.getSdkRoot()) + "/lib/impl/appengine-api.jar");
        list.add(new File(jettyDir, "jakarta.servlet-api-6.1.0.jar").getAbsolutePath());
        for (String string : new String[]{"ee11-annotations"}) {
            for (File f : new File(jettyDir, string).listFiles()) {
                list.add(f.getAbsolutePath());
            }
        }
        for (String string : new String[]{"annotations"}) {
            for (File f : new File(jettyDir, string).listFiles()) {
                list.add(f.getAbsolutePath());
            }
        }
        for (String string : new String[]{"ee11-jaspi"}) {
            for (File f : new File(jettyDir, string).listFiles()) {
                list.add(f.getAbsolutePath());
            }
        }
        list.add(quickstart.getAbsolutePath());
        for (File file : new File(jettyDir, "logging").listFiles()) {
            list.add(file.getAbsolutePath());
        }
        return Joiner.on(System.getProperty("path.separator")).join(list);
    }

    @Override
    public File getResourcesDirectory() {
        return new File(Jetty121EE11Sdk.getSdkRoot(), "docs");
    }

    private List<File> getImplLibFiles() {
        List<File> lf = this.getJetty121Jars("");
        lf.addAll(this.getJetty121JspJars());
        lf.addAll(this.getJetty121Jars("logging"));
        lf.addAll(this.getJetty121Jars("annotations"));
        lf.addAll(this.getJetty121Jars("ee11-annotations"));
        lf.addAll(this.getJetty121Jars("ee11-apache-jsp"));
        lf.addAll(this.getJetty121Jars("ee11-glassfish-jstl"));
        lf.addAll(this.getLibs(sdkRoot, "impl"));
        lf.add(new File(sdkRoot, "lib/impl/jetty121/appengine-local-runtime-jetty121-ee11.jar"));
        File jettyHomeLib = new File(sdkRoot, "jetty121/jetty-home/lib");
        lf.add(new File(jettyHomeLib, "ee10-glassfish-jstl/org.glassfish.web.jakarta.servlet.jsp.jstl-3.0.1.jar"));
        return Collections.unmodifiableList(lf);
    }

    @Override
    public List<URL> getSharedJspLibs() {
        return Collections.unmodifiableList(Jetty121EE11Sdk.toURLs((List<File>)this.getSharedJspLibFiles()));
    }

    @Override
    protected File getJetty121Jar(String fileNamePattern) {
        File path = new File(sdkRoot, "jetty121/jetty-home/lib" + File.separator);
        if (!path.exists()) {
            throw new IllegalArgumentException("Unable to find " + path.getAbsolutePath());
        }
        for (File f : Jetty121EE11Sdk.listFiles(path)) {
            if (!f.getName().endsWith(".jar") || !f.getName().contains(fileNamePattern)) continue;
            return f;
        }
        throw new IllegalArgumentException("Unable to find " + fileNamePattern + " at " + path.getAbsolutePath());
    }

    @Override
    protected List<File> getJetty121Jars(String subDir) {
        File path = new File(sdkRoot, "jetty121/jetty-home/lib" + File.separator + subDir);
        if (!path.exists()) {
            throw new IllegalArgumentException("Unable to find " + path.getAbsolutePath());
        }
        ArrayList<File> jars = new ArrayList<File>();
        for (File f : Jetty121EE11Sdk.listFiles(path)) {
            if (!f.getName().endsWith(".jar") || f.getName().contains("-cdi-") || f.getName().contains("-alpn-") || f.getName().contains("-demo-") || f.getName().contains("-websocket-") || f.getName().contains("-gcloud-") || f.getName().contains("-infinispan-") || f.getName().contains("-hazelcast-") || f.getName().contains("-ethereum-") || f.getName().contains("jakarta.enterprise") || f.getName().contains("jakarta.inject") || f.getName().contains("jakarta.interceptor") || f.getName().contains("jakarta.servlet-api-6.0.0") || f.getName().contains("jakarta.transaction") || f.getName().contains("ee8") || f.getName().contains("ee9") || f.getName().contains("ee10") || f.getName().contains("jetty-jakarta-servlet-api")) continue;
            jars.add(f);
        }
        return jars;
    }

    @Override
    List<File> getJetty121JspJars() {
        List<File> lf = this.getJetty121Jars("ee11-apache-jsp");
        lf.addAll(this.getJetty121Jars("ee11-glassfish-jstl"));
        lf.add(this.getJetty121Jar("ee11-servlet-"));
        return lf;
    }

    @Override
    List<File> getJetty121SharedLibFiles() {
        ArrayList<File> sharedLibs = new ArrayList<File>();
        sharedLibs.add(new File(sdkRoot, "lib/shared/jetty12/appengine-local-runtime-shared.jar"));
        File jettyHomeLib = new File(sdkRoot, "jetty121/jetty-home/lib");
        sharedLibs.add(new File(jettyHomeLib, "jakarta.servlet-api-6.1.0.jar"));
        class JettyVersionFilter
        implements FileFilter {
            JettyVersionFilter() {
            }

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("jetty-util-");
            }
        }
        File[] files = jettyHomeLib.listFiles(new JettyVersionFilter());
        sharedLibs.addAll(Arrays.asList(files));
        sharedLibs.addAll(this.getJetty121JspJars());
        return sharedLibs;
    }

    @Override
    public List<URL> getSharedLibs() {
        return Collections.unmodifiableList(Jetty121EE11Sdk.toURLs((List<File>)this.getSharedLibFiles()));
    }

    @Override
    public List<URL> getUserJspLibs() {
        return Collections.unmodifiableList(Jetty121EE11Sdk.toURLs(this.getJetty121JspJars()));
    }

    @Override
    public List<File> getSharedLibFiles() {
        List<File> sharedLibs = this.getJetty121SharedLibFiles();
        if (isDevAppServerTest) {
            sharedLibs.addAll(Jetty121EE11Sdk.getLibsRecursive(sdkRoot, "testing"));
        }
        return Collections.unmodifiableList(sharedLibs);
    }

    @Override
    public String getJSPCompilerClassName() {
        return "com.google.appengine.tools.development.jetty.ee11.LocalJspC";
    }
}

