/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSortedMap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.common.xml.XmlEscapers;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.PluginLoader;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AppYaml {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private String application;
    private String version;
    private String service;
    private String instanceClass;
    private AutomaticScaling automaticScaling;
    private ManualScaling manualScaling;
    private BasicScaling basicScaling;
    private String runtime;
    private boolean appEngineApis;
    private ImmutableList<Handler> handlers;
    private String publicRoot;
    private ImmutableList<StaticFile> staticFiles;
    private ImmutableList<ResourceFile> resourceFiles;
    private boolean sslEnabled = true;
    private boolean precompilationEnabled = true;
    private boolean sessionsEnabled = false;
    private AsyncSessionPersistence asyncSessionPersistence;
    private boolean threadsafe = false;
    private String autoIdPolicy;
    private String apiVersion;
    private boolean threadsafeWasSet = false;
    private boolean codeLock = false;
    private ImmutableSortedMap<String, String> systemProperties;
    private ImmutableSortedMap<String, String> envVariables;
    private ImmutableSortedMap<String, String> buildEnvVariables;
    private ImmutableSortedMap<String, String> contextParams;
    private ImmutableSortedMap<String, String> betaSettings;
    private ImmutableList<String> welcomeFiles;
    private ImmutableList<String> listeners;
    private ImmutableList<String> inboundServices;
    private ImmutableList<String> derivedFileType;
    private AdminConsole adminConsole;
    private ImmutableList<ErrorHandler> errorHandlers;
    private ApiConfig apiConfig;
    private String webXml;
    private String runtimeChannel;
    private String env;
    private ImmutableSortedMap<String, String> vpcAccessConnector;
    private String skipFiles;
    private String defaultExpiration;
    private String entrypoint;
    private static final String VALIDATION_VPC = "vpc_access_connect has to be like: projects/[PROJECT_ID]/locations/[REGION]/connectors/[CONNECTOR_NAME] but was '%s'.";

    public String getApplication() {
        if (this.application == null) {
            throw new AppEngineConfigException(String.format("Missing required element '%s'.", "application"));
        }
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public Map<String, String> getVpc_access_connector() {
        return this.vpcAccessConnector;
    }

    public void setVpc_access_connector(Map<String, String> vpcAccessConnectorMap) {
        String vpcAccessConnector = vpcAccessConnectorMap.get("name");
        List<String> parts = Splitter.on('/').splitToList(vpcAccessConnector);
        if (parts.size() != 6) {
            throw new AppEngineConfigException(String.format(VALIDATION_VPC, vpcAccessConnector));
        }
        if (!(parts.get(0).equals("projects") && parts.get(2).equals("locations") && parts.get(4).equals("connectors"))) {
            throw new AppEngineConfigException(String.format(VALIDATION_VPC, vpcAccessConnector));
        }
        this.vpcAccessConnector = ImmutableSortedMap.copyOf(vpcAccessConnectorMap);
    }

    public String getDefault_expiration() {
        return this.defaultExpiration;
    }

    public void setDefault_expiration(String defaultExpiration) {
        this.defaultExpiration = defaultExpiration;
    }

    public String getRuntime_channel() {
        return this.runtimeChannel;
    }

    public void setRuntime_channel(String runtimeChannel) {
        this.runtimeChannel = runtimeChannel;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getSkip_files() {
        return this.skipFiles;
    }

    public void setSkip_files(String skipFiles) {
        this.skipFiles = skipFiles;
    }

    public String getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(String application) {
        this.entrypoint = application;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getModule() {
        return this.service;
    }

    public void setModule(String module) {
        this.service = module;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getInstance_class() {
        return this.instanceClass;
    }

    public void setInstance_class(String instanceClass) {
        this.instanceClass = instanceClass;
    }

    public AutomaticScaling getAutomatic_scaling() {
        return this.automaticScaling;
    }

    public void setAutomatic_scaling(AutomaticScaling automaticScaling) {
        this.automaticScaling = automaticScaling;
    }

    public ManualScaling getManual_scaling() {
        return this.manualScaling;
    }

    public void setManual_scaling(ManualScaling manualScaling) {
        this.manualScaling = manualScaling;
    }

    public BasicScaling getBasic_scaling() {
        return this.basicScaling;
    }

    public void setBasic_scaling(BasicScaling basicScaling) {
        this.basicScaling = basicScaling;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public String getApp_engine_apis() {
        return Boolean.toString(this.appEngineApis);
    }

    public void setApp_engine_apis(String appEngineApis) {
        this.appEngineApis = YamlUtils.parseBoolean(appEngineApis);
    }

    public boolean isAppEngineApis() {
        return this.appEngineApis;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = ImmutableList.copyOf(handlers);
        if (this.apiConfig != null) {
            this.apiConfig.setHandlers(this.handlers);
        }
    }

    public String getPublic_root() {
        return this.publicRoot;
    }

    public void setPublic_root(String publicRoot) {
        this.publicRoot = publicRoot;
    }

    public List<StaticFile> getStatic_files() {
        return this.staticFiles;
    }

    public void setStatic_files(List<StaticFile> staticFiles) {
        this.staticFiles = ImmutableList.copyOf(staticFiles);
    }

    public List<ResourceFile> getResource_files() {
        return this.resourceFiles;
    }

    public void setResource_files(List<ResourceFile> resourceFiles) {
        this.resourceFiles = ImmutableList.copyOf(resourceFiles);
    }

    public String getSsl_enabled() {
        return Boolean.toString(this.sslEnabled);
    }

    public void setSsl_enabled(String sslEnabled) {
        this.sslEnabled = YamlUtils.parseBoolean(sslEnabled);
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getPrecompilation_enabled() {
        return Boolean.toString(this.precompilationEnabled);
    }

    public boolean isPrecompilationEnabled() {
        return this.precompilationEnabled;
    }

    public void setPrecompilation_enabled(String precompilationEnabled) {
        this.precompilationEnabled = YamlUtils.parseBoolean(precompilationEnabled);
    }

    public String getSessions_enabled() {
        return Boolean.toString(this.sessionsEnabled);
    }

    public boolean isSessionsEnabled() {
        return this.sessionsEnabled;
    }

    public void setSessions_enabled(String sessionsEnabled) {
        this.sessionsEnabled = YamlUtils.parseBoolean(sessionsEnabled);
    }

    public AsyncSessionPersistence getAsync_session_persistence() {
        return this.asyncSessionPersistence;
    }

    public void setAsync_session_persistence(AsyncSessionPersistence asyncSessionPersistence) {
        this.asyncSessionPersistence = asyncSessionPersistence;
    }

    public String getThreadsafe() {
        return Boolean.toString(this.threadsafe);
    }

    public boolean isThreadsafeSet() {
        return this.threadsafeWasSet;
    }

    public void setThreadsafe(String threadsafe) {
        this.threadsafe = YamlUtils.parseBoolean(threadsafe);
        this.threadsafeWasSet = true;
    }

    public String getAuto_id_policy() {
        return this.autoIdPolicy;
    }

    public void setAuto_id_policy(String policy) {
        this.autoIdPolicy = policy;
    }

    public String getApi_version() {
        return this.apiVersion;
    }

    public void setApi_version(String version) {
        this.apiVersion = version;
    }

    public String getCode_lock() {
        return Boolean.toString(this.codeLock);
    }

    public void setCode_lock(String codeLock) {
        this.codeLock = YamlUtils.parseBoolean(codeLock);
    }

    public Map<String, String> getSystem_properties() {
        return this.systemProperties;
    }

    public void setSystem_properties(Map<String, String> systemProperties) {
        this.systemProperties = ImmutableSortedMap.copyOf(systemProperties);
    }

    public Map<String, String> getEnv_variables() {
        return this.envVariables;
    }

    public void setEnv_variables(Map<String, String> envVariables) {
        this.envVariables = ImmutableSortedMap.copyOf(envVariables);
    }

    public Map<String, String> getBuild_env_variables() {
        return this.buildEnvVariables;
    }

    public void setBuild_env_variables(Map<String, String> buildEnvVariables) {
        this.buildEnvVariables = ImmutableSortedMap.copyOf(buildEnvVariables);
    }

    public Map<String, String> getBeta_settings() {
        return this.betaSettings;
    }

    public void setBeta_settings(Map<String, String> betaSettings) {
        this.betaSettings = ImmutableSortedMap.copyOf(betaSettings);
    }

    public List<String> getWelcome_files() {
        return this.welcomeFiles;
    }

    public void setWelcome_files(List<String> welcomeFiles) {
        this.welcomeFiles = ImmutableList.copyOf(welcomeFiles);
    }

    public Map<String, String> getContext_params() {
        return this.contextParams;
    }

    public void setContext_params(Map<String, String> contextParams) {
        this.contextParams = ImmutableSortedMap.copyOf(contextParams);
    }

    public List<String> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<String> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
    }

    public String getWeb_xml() {
        return this.webXml;
    }

    public void setWeb_xml(String webXml) {
        this.webXml = webXml;
    }

    public List<String> getInbound_services() {
        return this.inboundServices;
    }

    public void setInbound_services(List<String> inboundServices) {
        this.inboundServices = ImmutableList.copyOf(inboundServices);
    }

    public List<String> getDerived_file_type() {
        return this.derivedFileType;
    }

    public void setDerived_file_type(List<String> derivedFileType) {
        this.derivedFileType = ImmutableList.copyOf(derivedFileType);
    }

    public AdminConsole getAdmin_console() {
        return this.adminConsole;
    }

    public void setAdmin_console(AdminConsole adminConsole) {
        this.adminConsole = adminConsole;
    }

    public List<ErrorHandler> getError_handlers() {
        return this.errorHandlers;
    }

    public void setError_handlers(List<ErrorHandler> errorHandlers) {
        this.errorHandlers = ImmutableList.copyOf(errorHandlers);
    }

    public ApiConfig getApi_config() {
        return this.apiConfig;
    }

    public void setApi_config(ApiConfig apiConfig) {
        this.apiConfig = apiConfig;
        if (this.handlers != null) {
            this.apiConfig.setHandlers(this.handlers);
        }
    }

    public AppYaml applyPlugins() {
        AppYaml yaml = this;
        for (Plugin plugin : PluginLoader.loadPlugins(Plugin.class)) {
            AppYaml modified = plugin.process(yaml);
            if (modified == null) continue;
            yaml = modified;
        }
        return yaml;
    }

    private void addOptionalElement(XmlWriter xml, String name, String value) {
        if (value != null) {
            xml.simpleElement(name, value, new String[0]);
        }
    }

    public void generateAppEngineWebXml(Writer writer) {
        XmlWriter xml = new XmlWriter(writer);
        xml.startElement("appengine-web-app", "xmlns", "http://appengine.google.com/ns/1.0");
        xml.simpleElement("application", this.getApplication(), new String[0]);
        this.addOptionalElement(xml, "version", this.getVersion());
        this.addOptionalElement(xml, "runtime", this.getRuntime());
        this.addOptionalElement(xml, "module", this.getModule());
        this.addOptionalElement(xml, "instance-class", this.getInstance_class());
        this.addOptionalElement(xml, "public-root", this.publicRoot);
        this.addOptionalElement(xml, "auto-id-policy", this.getAuto_id_policy());
        if (this.automaticScaling != null) {
            xml.startElement("automatic-scaling", new String[0]);
            this.addOptionalElement(xml, "min-pending-latency", this.automaticScaling.getMin_pending_latency());
            this.addOptionalElement(xml, "max-pending-latency", this.automaticScaling.getMax_pending_latency());
            this.addOptionalElement(xml, "min-idle-instances", this.automaticScaling.getMin_idle_instances());
            this.addOptionalElement(xml, "max-idle-instances", this.automaticScaling.getMax_idle_instances());
            this.addOptionalElement(xml, "min-instances", this.automaticScaling.getMin_instances());
            this.addOptionalElement(xml, "max-instances", this.automaticScaling.getMax_instances());
            this.addOptionalElement(xml, "target-cpu-utilization", this.automaticScaling.getTarget_cpu_utilization());
            this.addOptionalElement(xml, "target-throughput-utilization", this.automaticScaling.getTarget_throughput_utilization());
            this.addOptionalElement(xml, "max-concurrent-requests", this.automaticScaling.getMax_concurrent_requests());
            xml.endElement("automatic-scaling");
        }
        if (this.manualScaling != null) {
            xml.startElement("manual-scaling", new String[0]);
            xml.simpleElement("instances", this.manualScaling.getInstances(), new String[0]);
            xml.endElement("manual-scaling");
        }
        if (this.basicScaling != null) {
            xml.startElement("basic-scaling", new String[0]);
            xml.simpleElement("max-instances", this.basicScaling.getMax_instances(), new String[0]);
            this.addOptionalElement(xml, "idle-timeout", this.basicScaling.getIdle_timeout());
            xml.endElement("basic-scaling");
        }
        xml.startElement("static-files", new String[0]);
        if (this.staticFiles != null) {
            for (StaticFile staticFile : this.staticFiles) {
                if (staticFile.getInclude() != null) {
                    this.generateInclude(staticFile, xml);
                    continue;
                }
                xml.emptyElement("exclude", "path", staticFile.getExclude());
            }
        }
        xml.endElement("static-files");
        xml.startElement("resource-files", new String[0]);
        if (this.resourceFiles != null) {
            for (ResourceFile resourceFile : this.resourceFiles) {
                String name2;
                String path;
                if (resourceFile.getInclude() != null) {
                    String name22 = "include";
                    path = resourceFile.getInclude();
                } else {
                    name2 = "exclude";
                    path = resourceFile.getExclude();
                }
                xml.emptyElement(name2, "path", path);
            }
        }
        xml.endElement("resource-files");
        xml.simpleElement("ssl-enabled", this.getSsl_enabled(), new String[0]);
        xml.simpleElement("precompilation-enabled", this.getPrecompilation_enabled(), new String[0]);
        if (this.isThreadsafeSet()) {
            xml.simpleElement("threadsafe", this.getThreadsafe(), new String[0]);
        }
        xml.simpleElement("code-lock", this.getCode_lock(), new String[0]);
        xml.simpleElement("sessions-enabled", this.getSessions_enabled(), new String[0]);
        if (this.asyncSessionPersistence != null) {
            xml.simpleElement("async-session-persistence", null, "enabled", this.getAsync_session_persistence().getEnabled(), "queue-name", this.getAsync_session_persistence().getQueue_name());
        }
        if (this.systemProperties != null) {
            xml.startElement("system-properties", new String[0]);
            this.systemProperties.forEach((name, value) -> xml.emptyElement("property", "name", (String)name, "value", (String)value));
            xml.endElement("system-properties");
        }
        if (this.envVariables != null) {
            xml.startElement("env-variables", new String[0]);
            this.envVariables.forEach((name, value) -> xml.emptyElement("env-var", "name", (String)name, "value", (String)value));
            xml.endElement("env-variables");
        }
        if (this.buildEnvVariables != null) {
            xml.startElement("build-env-variables", new String[0]);
            this.buildEnvVariables.forEach((name, value) -> xml.emptyElement("build-env-var", "name", (String)name, "value", (String)value));
            xml.endElement("build-env-variables");
        }
        if (this.betaSettings != null) {
            xml.startElement("beta-settings", new String[0]);
            this.betaSettings.forEach((name, value) -> xml.emptyElement("beta-setting", "name", (String)name, "value", (String)value));
            xml.endElement("beta-settings");
        }
        boolean warmupService = false;
        if (this.inboundServices != null) {
            xml.startElement("inbound-services", new String[0]);
            for (String service : this.inboundServices) {
                if ("warmup".equals(service)) {
                    warmupService = true;
                    continue;
                }
                xml.simpleElement("service", service, new String[0]);
            }
            xml.endElement("inbound-services");
        }
        xml.simpleElement("warmup-requests-enabled", Boolean.toString(warmupService), new String[0]);
        if (this.adminConsole != null && this.adminConsole.getPages() != null) {
            xml.startElement("admin-console", new String[0]);
            for (AdminPage page : this.adminConsole.getPages()) {
                xml.emptyElement("page", "name", page.getName(), "url", page.getUrl());
            }
            xml.endElement("admin-console");
        }
        if (this.errorHandlers != null) {
            xml.startElement("static-error-handlers", new String[0]);
            for (ErrorHandler handler : this.errorHandlers) {
                xml.emptyElement("handler", "file", handler.getFile(), "error-code", handler.getError_code());
            }
            xml.endElement("static-error-handlers");
        }
        if (this.apiConfig != null) {
            this.apiConfig.generateXml(xml);
        }
        xml.endElement("appengine-web-app");
    }

    private void generateHandlerXml(XmlWriter xmlWriter) {
        if (this.handlers == null) {
            return;
        }
        LinkedHashMap<String, Handler> servletsByName = Maps.newLinkedHashMapWithExpectedSize(this.handlers.size());
        LinkedHashMap<String, Handler> filtersByName = Maps.newLinkedHashMapWithExpectedSize(this.handlers.size());
        for (Handler handler : this.handlers) {
            Handler existing;
            String name = handler.getName();
            if (name == null) continue;
            Handler.Type type = handler.getType();
            boolean isServlet = type == Handler.Type.SERVLET || type == Handler.Type.JSP;
            boolean isFilter = type == Handler.Type.FILTER;
            Handler handler2 = existing = isServlet ? (Handler)servletsByName.get(name) : (Handler)filtersByName.get(name);
            if (existing != null) {
                existing.mergeDefinitions(handler);
                continue;
            }
            if (isServlet) {
                servletsByName.put(name, handler);
            }
            if (!isFilter) continue;
            filtersByName.put(name, handler);
        }
        for (Handler handler : servletsByName.values()) {
            handler.generateDefinitionXml(xmlWriter);
        }
        for (Handler handler : filtersByName.values()) {
            handler.generateDefinitionXml(xmlWriter);
        }
        for (Handler handler : this.handlers) {
            handler.generateMappingXml(xmlWriter);
        }
    }

    public void generateWebXml(Writer writer) {
        XmlWriter xml = new XmlWriter(writer);
        xml.startElement("web-app", "version", "2.5", "xmlns", "http://java.sun.com/xml/ns/javaee", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd");
        this.generateHandlerXml(xml);
        if (this.contextParams != null) {
            this.contextParams.forEach((name, value) -> {
                xml.startElement("context-param", new String[0]);
                xml.simpleElement("param-name", (String)name, new String[0]);
                xml.simpleElement("param-value", (String)value, new String[0]);
                xml.endElement("context-param");
            });
        }
        if (this.welcomeFiles != null) {
            xml.startElement("welcome-file-list", new String[0]);
            for (String file : this.welcomeFiles) {
                xml.simpleElement("welcome-file", file, new String[0]);
            }
            xml.endElement("welcome-file-list");
        }
        if (this.listeners != null) {
            for (String listener : this.listeners) {
                xml.startElement("listener", new String[0]);
                xml.simpleElement("listener-class", listener, new String[0]);
                xml.endElement("listener");
            }
        }
        if (this.webXml != null) {
            xml.writeUnescaped(this.webXml);
        }
        xml.endElement("web-app");
    }

    public static AppYaml parse(Reader reader) {
        try {
            AppYaml appYaml = YamlUtils.parse(reader, AppYaml.class);
            if (appYaml == null) {
                throw new YamlException("Unable to parse yaml file");
            }
            return appYaml.applyPlugins();
        }
        catch (YamlException e) {
            for (Throwable innerException = e.getCause(); innerException != null; innerException = innerException.getCause()) {
                if (!(innerException instanceof AppEngineConfigException)) continue;
                throw (AppEngineConfigException)innerException;
            }
            throw new AppEngineConfigException(e.getMessage(), e);
        }
    }

    public static AppYaml parse(String yaml) {
        return AppYaml.parse(new StringReader(yaml));
    }

    private void generateInclude(StaticFile include, XmlWriter xml) {
        Map<String, String> httpHeaders = include.getHttp_headers();
        if (httpHeaders == null || httpHeaders.isEmpty()) {
            xml.emptyElement("include", "path", include.getInclude(), "expiration", include.getExpiration());
        } else {
            xml.startElement("include", false, "path", include.getInclude(), "expiration", include.getExpiration());
            httpHeaders.forEach((name, value) -> xml.emptyElement("http-header", "name", (String)name, "value", (String)value));
            xml.endElement("include");
        }
    }

    public static class AutomaticScaling {
        private String minPendingLatency;
        private String maxPendingLatency;
        private String minIdleInstances;
        private String maxIdleInstances;
        private String maxConcurrentRequests;
        private String minInstances;
        private String maxInstances;
        private String targetCpuUtilization;
        private String targetThroughputUtilization;

        public String getMin_pending_latency() {
            return this.minPendingLatency;
        }

        public void setMin_pending_latency(String minPendingLatency) {
            this.minPendingLatency = minPendingLatency;
        }

        public String getMax_pending_latency() {
            return this.maxPendingLatency;
        }

        public void setMax_pending_latency(String maxPendingLatency) {
            this.maxPendingLatency = maxPendingLatency;
        }

        public String getMin_idle_instances() {
            return this.minIdleInstances;
        }

        public void setMin_idle_instances(String minIdleInstances) {
            this.minIdleInstances = minIdleInstances;
        }

        public String getMax_idle_instances() {
            return this.maxIdleInstances;
        }

        public void setMax_idle_instances(String maxIdleInstances) {
            this.maxIdleInstances = maxIdleInstances;
        }

        public String getMin_instances() {
            return this.minInstances;
        }

        public void setTarget_cpu_utilization(String targetCpuUtilization) {
            this.targetCpuUtilization = targetCpuUtilization;
        }

        public String getTarget_cpu_utilization() {
            return this.targetCpuUtilization;
        }

        public void setTarget_throughput_utilization(String targetThroughputUtilization) {
            this.targetThroughputUtilization = targetThroughputUtilization;
        }

        public String getTarget_throughput_utilization() {
            return this.targetThroughputUtilization;
        }

        public void setMin_instances(String minInstances) {
            this.minInstances = minInstances;
        }

        public String getMax_instances() {
            return this.maxInstances;
        }

        public void setMax_instances(String maxInstances) {
            this.maxInstances = maxInstances;
        }

        public String getMax_concurrent_requests() {
            return this.maxConcurrentRequests;
        }

        public void setMax_concurrent_requests(String maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
        }
    }

    public static class ManualScaling {
        private String instances;

        public String getInstances() {
            return this.instances;
        }

        public void setInstances(String instances) {
            this.instances = instances;
        }
    }

    public static class BasicScaling {
        private String maxInstances;
        private String idleTimeout;

        public String getMax_instances() {
            return this.maxInstances;
        }

        public void setMax_instances(String maxInstances) {
            this.maxInstances = maxInstances;
        }

        public String getIdle_timeout() {
            return this.idleTimeout;
        }

        public void setIdle_timeout(String idleTimeout) {
            this.idleTimeout = idleTimeout;
        }
    }

    public static class ApiConfig {
        private String url;
        private String servlet;
        private ImmutableList<Handler> handlers;

        public void setHandlers(List<Handler> handlers) {
            this.handlers = ImmutableList.copyOf(handlers);
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            YamlUtils.validateUrl(url);
            this.url = url;
        }

        public String getServlet() {
            return this.servlet;
        }

        public void setServlet(String servlet) {
            this.servlet = servlet;
        }

        private void generateXml(XmlWriter xml) {
            xml.startElement("api-config", "servlet-class", this.getServlet(), "url-pattern", this.getUrl());
            if (this.handlers != null) {
                for (Handler handler : this.handlers) {
                    handler.generateEndpointServletMappingId(xml);
                }
            }
            xml.endElement("api-config");
        }
    }

    public static class AsyncSessionPersistence {
        private boolean enabled = false;
        private String queueName;

        public String getEnabled() {
            return Boolean.toString(this.enabled);
        }

        public void setEnabled(String enabled) {
            this.enabled = YamlUtils.parseBoolean(enabled);
        }

        public String getQueue_name() {
            return this.queueName;
        }

        public void setQueue_name(String queueName) {
            this.queueName = queueName;
        }
    }

    public static class AdminConsole {
        private ImmutableList<AdminPage> pages;

        public List<AdminPage> getPages() {
            return this.pages;
        }

        public void setPages(List<AdminPage> pages) {
            this.pages = ImmutableList.copyOf(pages);
        }
    }

    public static interface Plugin {
        public AppYaml process(AppYaml var1);
    }

    private static class XmlWriter {
        private static final String XML_HEADER = "<!-- Generated from app.yaml. Do not edit. -->";
        private final PrintWriter writer;
        private int indent = 0;
        private int apiEndpointId = 0;

        public XmlWriter(Writer w) {
            this.writer = new PrintWriter(w);
            this.writer.println(XML_HEADER);
        }

        public void startElement(String name, String ... attributes) {
            this.startElement(name, false, attributes);
            this.writer.println();
        }

        public void startElement(String name, boolean empty, String ... attributes) {
            this.indent();
            this.writer.print("<");
            this.writer.print(name);
            for (int i = 0; i < attributes.length; i += 2) {
                String attributeName = attributes[i];
                String value = attributes[i + 1];
                if (value == null) continue;
                this.writer.printf(" %s='%s'", attributeName, this.escapeAttribute(value));
            }
            if (empty) {
                this.writer.println("/>");
            } else {
                this.writer.print(">");
                this.indent += 2;
            }
        }

        public void endElement(String name) {
            this.endElement(name, true);
        }

        public void endElement(String name, boolean needIndent) {
            this.indent -= 2;
            if (needIndent) {
                this.indent();
            }
            this.writer.print("</");
            this.writer.print(name);
            this.writer.println(">");
        }

        public void emptyElement(String name, String ... attributes) {
            this.startElement(name, true, attributes);
        }

        public void simpleElement(String name, String value, String ... attributes) {
            this.startElement(name, false, attributes);
            this.writer.print(this.escapeContent(value));
            this.endElement(name, false);
        }

        public void writeUnescaped(String xmlContent) {
            this.writer.println(xmlContent);
        }

        private void indent() {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.print(" ");
            }
        }

        private String escapeContent(String value) {
            if (value == null) {
                return null;
            }
            return XmlEscapers.xmlContentEscaper().escape(value);
        }

        private String escapeAttribute(String value) {
            if (value == null) {
                return null;
            }
            return XmlEscapers.xmlAttributeEscaper().escape(value);
        }

        private String nextApiEndpointId() {
            return String.format("endpoint-%1$d", ++this.apiEndpointId);
        }
    }

    public static class StaticFile
    extends ResourceFile {
        private static final String NO_INCLUDE = "Missing include.";
        private static final String INCLUDE_ONLY = "Expiration can only be specified with include.";
        private String expiration;

        public String getExpiration() {
            if (this.expiration != null && this.include == null) {
                throw new AppEngineConfigException(NO_INCLUDE);
            }
            return this.expiration;
        }

        public void setExpiration(String expiration) {
            if (this.exclude != null) {
                throw new AppEngineConfigException(INCLUDE_ONLY);
            }
            this.expiration = expiration;
        }

        @Override
        public void setExclude(String exclude) {
            if (this.expiration != null) {
                throw new AppEngineConfigException(INCLUDE_ONLY);
            }
            super.setExclude(exclude);
        }
    }

    public static class ResourceFile {
        private static final String EMPTY_MESSAGE = "Missing include or exclude.";
        private static final String BOTH_MESSAGE = "Cannot specify both include and exclude.";
        String include;
        String exclude;
        ImmutableSortedMap<String, String> httpHeaders;

        public String getInclude() {
            if (this.exclude == null && this.include == null) {
                throw new AppEngineConfigException(EMPTY_MESSAGE);
            }
            return this.include;
        }

        public void setInclude(String include) {
            if (this.exclude != null) {
                throw new AppEngineConfigException(BOTH_MESSAGE);
            }
            this.include = include;
        }

        public String getExclude() {
            if (this.exclude == null && this.include == null) {
                throw new AppEngineConfigException(EMPTY_MESSAGE);
            }
            return this.exclude;
        }

        public void setExclude(String exclude) {
            if (this.include != null) {
                throw new AppEngineConfigException(BOTH_MESSAGE);
            }
            this.exclude = exclude;
        }

        public Map<String, String> getHttp_headers() {
            if (this.include == null) {
                throw new AppEngineConfigException("Missing include.");
            }
            return this.httpHeaders;
        }

        public void setHttp_headers(Map<String, String> httpHeaders) {
            if (this.include == null) {
                throw new AppEngineConfigException("Missing include.");
            }
            this.httpHeaders = ImmutableSortedMap.copyOf(httpHeaders);
        }
    }

    public static class AdminPage {
        private String name;
        private String url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class ErrorHandler {
        private String file;
        private String errorCode;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getError_code() {
            return this.errorCode;
        }

        public void setError_code(String errorCode) {
            this.errorCode = errorCode;
        }
    }

    public static class Handler {
        private String url;
        private String jsp;
        private String servlet;
        private String filter;
        private LoginType login;
        private Security secure;
        private ImmutableSortedMap<String, String> initParams;
        private String name;
        private boolean loadOnStartup;
        private boolean apiEndpoint = false;
        private boolean requireMatchingFile = false;
        private int redirectHttpResponseCode;
        private String mimeType;
        private String upload;
        private String staticFiles;
        private String staticDir;
        private String expiration;
        private Pattern urlPattern;
        private ImmutableSortedMap<String, String> httpHeaders;
        private String script;
        private static final String MULTIPLE_HANDLERS = "Cannot set both %s and %s for the same url.";

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            YamlUtils.validateUrl(url);
            try {
                this.urlPattern = Pattern.compile(url);
            }
            catch (PatternSyntaxException e) {
                ((GoogleLogger.Api)logger.atWarning()).log("Url is not a valid regex pattern: %s, exception: %s", (Object)url, (Object)e.getMessage());
            }
            this.url = url;
        }

        public Pattern getRegularExpression() {
            return this.urlPattern;
        }

        public String getJsp() {
            return this.jsp;
        }

        public void setJsp(String jsp) {
            this.jsp = jsp;
            this.checkHandlers();
        }

        public String getServlet() {
            return this.servlet;
        }

        public void setServlet(String servlet) {
            this.servlet = servlet;
            this.checkHandlers();
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
            this.checkHandlers();
        }

        public Type getType() {
            if (this.servlet != null) {
                return Type.SERVLET;
            }
            if (this.filter != null) {
                return Type.FILTER;
            }
            if (this.jsp != null) {
                return Type.JSP;
            }
            return Type.NONE;
        }

        public String getTarget() {
            if (this.servlet != null) {
                return this.servlet;
            }
            if (this.filter != null) {
                return this.filter;
            }
            if (this.jsp != null) {
                return this.jsp;
            }
            return null;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public String getScript() {
            return this.script;
        }

        public LoginType getLogin() {
            return this.login;
        }

        public void setLogin(LoginType login) {
            this.login = login;
        }

        public Security getSecure() {
            return this.secure;
        }

        public void setSecure(Security secure) {
            if (secure == Security.never) {
                throw new AppEngineConfigException("Java does not support secure: never");
            }
            this.secure = secure;
        }

        public Map<String, String> getInit_params() {
            return this.initParams;
        }

        public void setInit_params(Map<String, String> initParams) {
            this.initParams = initParams == null ? null : ImmutableSortedMap.copyOf(initParams);
        }

        public String getName() {
            return this.name == null ? this.getTarget() : this.name;
        }

        public void setLoad_on_startup(boolean loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
        }

        public boolean getLoad_on_startup() {
            return this.loadOnStartup;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getApi_endpoint() {
            return Boolean.toString(this.apiEndpoint);
        }

        public void setApi_endpoint(String apiEndpoint) {
            this.apiEndpoint = YamlUtils.parseBoolean(apiEndpoint);
        }

        public boolean isApiEndpoint() {
            return this.apiEndpoint;
        }

        public boolean isRequire_matching_file() {
            return this.requireMatchingFile;
        }

        public void setRequire_matching_file(boolean requireMatchingFile) {
            this.requireMatchingFile = requireMatchingFile;
        }

        public int getRedirect_http_response_code() {
            return this.redirectHttpResponseCode;
        }

        public void setRedirect_http_response_code(int redirectHttpResponseCode) {
            this.redirectHttpResponseCode = redirectHttpResponseCode;
        }

        public String getMime_type() {
            return this.mimeType;
        }

        public void setMime_type(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getUpload() {
            return this.upload;
        }

        public void setUpload(String upload) {
            this.upload = upload;
        }

        public String getStatic_files() {
            return this.staticFiles;
        }

        public void setStatic_files(String staticFiles) {
            this.staticFiles = staticFiles;
        }

        public String getStatic_dir() {
            return this.staticDir;
        }

        public void setStatic_dir(String staticDir) {
            this.staticDir = staticDir;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        public Map<String, String> getHttp_headers() {
            return this.httpHeaders;
        }

        public void setHttp_headers(Map<String, String> httpHeaders) {
            this.httpHeaders = ImmutableSortedMap.copyOf(httpHeaders);
        }

        private void checkHandlers() {
            if (this.jsp != null && this.servlet != null) {
                throw new AppEngineConfigException(String.format(MULTIPLE_HANDLERS, "jsp", "servlet"));
            }
            if (this.jsp != null && this.filter != null) {
                throw new AppEngineConfigException(String.format(MULTIPLE_HANDLERS, "jsp", "filter"));
            }
            if (this.filter != null && this.servlet != null) {
                throw new AppEngineConfigException(String.format(MULTIPLE_HANDLERS, "filter", "servlet"));
            }
        }

        private void generateDefinitionXml(XmlWriter xml) {
            if (this.getServlet() != null || this.getJsp() != null) {
                this.generateServletDefinition(xml);
            } else if (this.getFilter() != null) {
                this.generateFilterDefinition(xml);
            }
        }

        private void generateMappingXml(XmlWriter xml) {
            if (this.getServlet() != null || this.getJsp() != null) {
                this.generateServletMapping(xml);
            } else if (this.getFilter() != null) {
                this.generateFilterMapping(xml);
            }
            this.generateSecurityConstraints(xml);
        }

        private void generateSecurityConstraints(XmlWriter xml) {
            if (this.secure == Security.always || this.login == LoginType.required || this.login == LoginType.admin) {
                xml.startElement("security-constraint", new String[0]);
                xml.startElement("web-resource-collection", new String[0]);
                xml.simpleElement("web-resource-name", "aname", new String[0]);
                xml.simpleElement("url-pattern", this.getUrl(), new String[0]);
                xml.endElement("web-resource-collection");
                if (this.login == LoginType.required) {
                    this.securityConstraint(xml, "auth", "role-name", "*");
                } else if (this.login == LoginType.admin) {
                    this.securityConstraint(xml, "auth", "role-name", "admin");
                }
                if (this.secure == Security.always) {
                    this.securityConstraint(xml, "user-data", "transport-guarantee", "CONFIDENTIAL");
                }
                xml.endElement("security-constraint");
            }
        }

        private void securityConstraint(XmlWriter xml, String type, String name, String value) {
            type = (String)type + "-constraint";
            xml.startElement((String)type, new String[0]);
            xml.simpleElement(name, value, new String[0]);
            xml.endElement((String)type);
        }

        private void generateFilterDefinition(XmlWriter xml) {
            xml.startElement("filter", new String[0]);
            xml.simpleElement("filter-name", this.getName(), new String[0]);
            xml.simpleElement("filter-class", this.getFilter(), new String[0]);
            this.generateInitParams(xml);
            xml.endElement("filter");
        }

        private void generateFilterMapping(XmlWriter xml) {
            xml.startElement("filter-mapping", new String[0]);
            xml.simpleElement("filter-name", this.getName(), new String[0]);
            xml.simpleElement("url-pattern", this.getUrl(), new String[0]);
            xml.endElement("filter-mapping");
        }

        private void generateServletDefinition(XmlWriter xml) {
            xml.startElement("servlet", new String[0]);
            xml.simpleElement("servlet-name", this.getName(), new String[0]);
            if (this.getJsp() == null) {
                xml.simpleElement("servlet-class", this.getServlet(), new String[0]);
            } else {
                xml.simpleElement("jsp-file", this.getJsp(), new String[0]);
            }
            this.generateInitParams(xml);
            if (this.loadOnStartup) {
                xml.simpleElement("load-on-startup", "1", new String[0]);
            }
            xml.endElement("servlet");
        }

        public void mergeDefinitions(Handler otherHandler) {
            Preconditions.checkArgument(this.getName().equals(otherHandler.getName()), "Cannot merge handler named %s with handler named %s", (Object)this.getName(), (Object)otherHandler.getName());
            Preconditions.checkArgument(this.getType() == otherHandler.getType(), "Cannot merge handler of type %s with handler of type %s", (Object)this.getType(), (Object)otherHandler.getType());
            Preconditions.checkArgument(this.getTarget().equals(otherHandler.getTarget()), "Cannot merge handler with target %s with handler with target %s", (Object)this.getTarget(), (Object)otherHandler.getTarget());
            this.loadOnStartup = this.loadOnStartup || otherHandler.loadOnStartup;
            LinkedHashMap<String, String> mergedInitParams = new LinkedHashMap<String, String>();
            if (this.initParams != null) {
                mergedInitParams.putAll(this.initParams);
            }
            if (otherHandler.initParams != null) {
                for (String key : otherHandler.initParams.keySet()) {
                    String thisValue = (String)mergedInitParams.get(key);
                    String otherValue = otherHandler.initParams.get(key);
                    if (thisValue == null) {
                        mergedInitParams.put(key, otherValue);
                        continue;
                    }
                    if (thisValue.equals(otherValue)) continue;
                    throw new IllegalArgumentException("Cannot merge handlers with conflicting values for the init_param: " + key + " : " + thisValue + " vs " + otherValue);
                }
            }
            if (!mergedInitParams.isEmpty()) {
                this.initParams = ImmutableSortedMap.copyOf(mergedInitParams);
            }
        }

        private void generateServletMapping(XmlWriter xml) {
            if (this.isApiEndpoint()) {
                xml.startElement("servlet-mapping", "id", xml.nextApiEndpointId());
            } else {
                xml.startElement("servlet-mapping", new String[0]);
            }
            xml.simpleElement("servlet-name", this.getName(), new String[0]);
            xml.simpleElement("url-pattern", this.getUrl(), new String[0]);
            xml.endElement("servlet-mapping");
        }

        private void generateInitParams(XmlWriter xml) {
            if (this.initParams != null) {
                this.initParams.forEach((name, value) -> {
                    xml.startElement("init-param", new String[0]);
                    xml.simpleElement("param-name", (String)name, new String[0]);
                    xml.simpleElement("param-value", (String)value, new String[0]);
                    xml.endElement("init-param");
                });
            }
        }

        private void generateEndpointServletMappingId(XmlWriter xml) {
            if (this.isApiEndpoint()) {
                xml.simpleElement("endpoint-servlet-mapping-id", xml.nextApiEndpointId(), new String[0]);
            }
        }

        public static enum Type {
            SERVLET,
            JSP,
            FILTER,
            NONE;

        }

        public static enum LoginType {
            admin,
            required,
            optional;

        }

        public static enum Security {
            always,
            optional,
            never;

        }
    }
}

