/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.CronXml;
import com.google.apphosting.utils.config.RetryParametersXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import java.time.Duration;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class CronXmlReader
extends AbstractConfigXmlReader<CronXml> {
    private static final String FILENAME = "WEB-INF/cron.xml";
    private static final String CRONENTRIES_TAG = "cronentries";
    private static final String CRON_TAG = "cron";
    private static final String DESCRIPTION_TAG = "description";
    private static final String SCHEDULE_TAG = "schedule";
    private static final String TARGET_TAG = "target";
    private static final String TIMEZONE_TAG = "timezone";
    private static final String URL_TAG = "url";
    private static final String RETRY_PARAMETERS_TAG = "retry-parameters";
    private static final String JOB_RETRY_LIMIT_TAG = "job-retry-limit";
    private static final String JOB_AGE_LIMIT_TAG = "job-age-limit";
    private static final String MIN_BACKOFF_SECONDS_TAG = "min-backoff-seconds";
    private static final String MAX_BACKOFF_SECONDS_TAG = "max-backoff-seconds";
    private static final String MAX_DOUBLINGS_TAG = "max-doublings";
    private static final String ATTEMPT_DEADLINE_TAG = "attempt-deadline";
    private static final Duration MAX_ATTEMPT_DEADLINE = Duration.ofHours(24L);
    private static final Duration MIN_ATTEMPT_DEADLINE = Duration.ofSeconds(15L);

    public CronXmlReader(String appDir) {
        super(appDir, false);
    }

    public CronXml readCronXml() {
        return (CronXml)this.readConfigXml();
    }

    @Override
    protected CronXml processXml(InputStream is) {
        CronXml cronXml = new CronXml();
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        if (!root.getTagName().equals(CRONENTRIES_TAG)) {
            throw new AppEngineConfigException(this.getFilename() + " does not contain <cronentries>");
        }
        for (Element child : XmlUtils.getChildren(root)) {
            if (child.getTagName().equals(CRON_TAG)) {
                this.parseCron(child, cronXml.addNewEntry());
                continue;
            }
            throw new AppEngineConfigException(this.getFilename() + " contains <" + child.getTagName() + "> instead of <cron/>");
        }
        cronXml.validateLastEntry();
        return cronXml;
    }

    private void parseCron(Element cronElement, CronXml.Entry entry) {
        block18: for (Element child : XmlUtils.getChildren(cronElement)) {
            switch (child.getTagName()) {
                case "description": {
                    entry.setDescription(this.stringContents(child));
                    continue block18;
                }
                case "url": {
                    entry.setUrl(this.stringContents(child));
                    continue block18;
                }
                case "schedule": {
                    entry.setSchedule(this.stringContents(child));
                    continue block18;
                }
                case "timezone": {
                    entry.setTimezone(this.stringContents(child));
                    continue block18;
                }
                case "target": {
                    entry.setTarget(this.stringContents(child));
                    continue block18;
                }
                case "retry-parameters": {
                    entry.setRetryParameters(this.parseRetryParameters(child));
                    continue block18;
                }
                case "attempt-deadline": {
                    String contents = this.stringContents(child);
                    this.validateAttemptDeadline(contents);
                    entry.setAttemptDeadline(contents);
                    continue block18;
                }
            }
            throw new AppEngineConfigException(this.getFilename() + " contains unknown <" + child.getTagName() + "> inside <cron/>");
        }
    }

    private void validateAttemptDeadline(String attemptDeadline) {
        if (!Pattern.matches("\\d*[.]?\\d+s", attemptDeadline)) {
            throw new AppEngineConfigException("Deadline has invalid format. Expected a string formatted as number ending with 's'.");
        }
        String deadlineStr = attemptDeadline.substring(0, attemptDeadline.length() - 1);
        Duration deadline = Duration.ofMillis(Math.round(Double.parseDouble(deadlineStr) * 1000.0));
        if (deadline.compareTo(MAX_ATTEMPT_DEADLINE) > 0) {
            throw new AppEngineConfigException(String.format("Deadline %s is larger than %s.", attemptDeadline, MAX_ATTEMPT_DEADLINE));
        }
        if (deadline.compareTo(MIN_ATTEMPT_DEADLINE) < 0) {
            throw new AppEngineConfigException(String.format("Deadline %s is smaller than %s.", attemptDeadline, MIN_ATTEMPT_DEADLINE));
        }
    }

    private RetryParametersXml parseRetryParameters(Element retryElement) {
        RetryParametersXml retryParameters = new RetryParametersXml();
        block14: for (Element child : XmlUtils.getChildren(retryElement)) {
            switch (child.getTagName()) {
                case "job-retry-limit": {
                    retryParameters.setRetryLimit(this.stringContents(child));
                    continue block14;
                }
                case "job-age-limit": {
                    retryParameters.setAgeLimitSec(this.stringContents(child));
                    continue block14;
                }
                case "min-backoff-seconds": {
                    retryParameters.setMinBackoffSec(this.stringContents(child));
                    continue block14;
                }
                case "max-backoff-seconds": {
                    retryParameters.setMaxBackoffSec(this.stringContents(child));
                    continue block14;
                }
                case "max-doublings": {
                    retryParameters.setMaxDoublings(this.stringContents(child));
                    continue block14;
                }
            }
            throw new AppEngineConfigException(this.getFilename() + " contains unknown <" + child.getTagName() + "> inside <retry-parameters/>");
        }
        return retryParameters;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }
}

