/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.CronXml;
import com.google.apphosting.utils.config.RetryParametersXml;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class CronYamlReader {
    private static final String FILENAME = "cron.yaml";
    private String appDir;

    public CronYamlReader(String appDir) {
        if (((String)appDir).length() > 0 && ((String)appDir).charAt(((String)appDir).length() - 1) != File.separatorChar) {
            appDir = (String)appDir + File.separatorChar;
        }
        this.appDir = appDir;
    }

    public String getFilename() {
        return this.appDir + FILENAME;
    }

    public CronXml parse() {
        if (new File(this.getFilename()).exists()) {
            try {
                return CronYamlReader.parse(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                throw new AppEngineConfigException("Cannot find file " + this.getFilename(), ex);
            }
        }
        return null;
    }

    private static CronYaml parseYaml(Reader yaml) {
        try {
            CronYaml cronYaml = YamlUtils.parse(yaml, CronYaml.class);
            if (cronYaml == null) {
                throw new AppEngineConfigException("Empty cron configuration.");
            }
            return cronYaml;
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    public static CronXml parse(Reader yaml) {
        CronYaml cronYaml = CronYamlReader.parseYaml(yaml);
        return cronYaml.toXml();
    }

    public static CronYaml parseFromYaml(String yaml) {
        return CronYamlReader.parseYaml(new StringReader(yaml));
    }

    public static CronXml parse(String yaml) {
        return CronYamlReader.parse(new StringReader(yaml));
    }

    public static class CronYaml {
        private List<Cron> entries;

        public List<Cron> getCron() {
            return this.entries;
        }

        public void setCron(List<Cron> entries) {
            this.entries = entries;
        }

        public CronXml toXml() {
            CronXml xml = new CronXml();
            if (this.entries != null) {
                for (Cron entry : this.entries) {
                    xml.addEntry(entry.toXml());
                }
            }
            return xml;
        }

        public static class Cron {
            private final CronXml.Entry entry = new CronXml.Entry();
            private RetryParameters retryParameters;

            public void setUrl(String name) {
                this.entry.setUrl(name);
            }

            public String getUrl() {
                return this.entry.getUrl();
            }

            public void setTimezone(String name) {
                this.entry.setTimezone(name);
            }

            public String getTimezone() {
                return this.entry.getTimezone();
            }

            public void setDescription(String rate) {
                this.entry.setDescription(rate);
            }

            public String getDescription() {
                return this.entry.getDescription();
            }

            public void setAttempt_deadline(String attemptDeadline) {
                this.entry.setAttemptDeadline(attemptDeadline);
            }

            public String getAttempt_deadline() {
                return this.entry.getAttemptDeadline();
            }

            public void setRetry_parameters(RetryParameters retryParameters) {
                this.retryParameters = retryParameters;
                if (retryParameters != null) {
                    this.entry.setRetryParameters(retryParameters.toXml());
                } else {
                    this.entry.setRetryParameters(new RetryParametersXml());
                }
            }

            public RetryParameters getRetry_parameters() {
                return this.retryParameters;
            }

            public void setSchedule(String target) {
                this.entry.setSchedule(target);
            }

            public String getSchedule() {
                return this.entry.getSchedule();
            }

            public void setTarget(String mode) {
                this.entry.setTarget(mode);
            }

            public String getTarget() {
                return this.entry.getTarget();
            }

            public CronXml.Entry toXml() {
                return this.entry;
            }
        }

        public static class RetryParameters {
            private RetryParametersXml retryParameters = new RetryParametersXml();

            public void setJob_retry_limit(int limit) {
                this.retryParameters.setRetryLimit(limit);
            }

            public int getJob_retry_limit() {
                return this.retryParameters.getRetryLimit();
            }

            public void setJob_age_limit(String ageLimit) {
                this.retryParameters.setAgeLimitSec(ageLimit);
            }

            public String getJob_age_limit() {
                return this.retryParameters.getAgeLimitSec().toString() + "s";
            }

            public long getJob_age_limit_sec() {
                return this.retryParameters.getAgeLimitSec().intValue();
            }

            public void setMin_backoff_seconds(double backoff) {
                this.retryParameters.setMinBackoffSec(backoff);
            }

            public double getMin_backoff_seconds() {
                return this.retryParameters.getMinBackoffSec();
            }

            public void setMax_backoff_seconds(double backoff) {
                this.retryParameters.setMaxBackoffSec(backoff);
            }

            public double getMax_backoff_seconds() {
                return this.retryParameters.getMaxBackoffSec();
            }

            public void setMax_doublings(int doublings) {
                this.retryParameters.setMaxDoublings(doublings);
            }

            public int getMax_doublings() {
                return this.retryParameters.getMaxDoublings();
            }

            public RetryParametersXml toXml() {
                return this.retryParameters;
            }
        }
    }
}

