/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.init;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public final class AppEngineWebXmlInitialParse {
    private static final Logger logger = Logger.getLogger(AppEngineWebXmlInitialParse.class.getName());
    private String runtimeId = "";
    private final String appEngineWebXmlFile;
    private static final String PROPERTIES = "system-properties";
    private static final String PROPERTY = "property";
    private static final String RUNTIME = "runtime";
    public static final String GIT_HASH;
    public static final String BUILD_TIMESTAMP;
    private static final String BUILD_VERSION;
    private static final Properties BUILD_PROPERTIES;

    public void handleRuntimeProperties() {
        if (Objects.equals(System.getenv("EXPERIMENT_ENABLE_HTTP_CONNECTOR_FOR_JAVA"), "true")) {
            System.setProperty("appengine.ignore.cancelerror", "true");
            System.setProperty("appengine.use.HttpConnector", "true");
        }
        Properties appEngineWebXmlProperties = new Properties();
        try (FileInputStream stream = new FileInputStream(this.appEngineWebXmlFile);){
            Iterator<Object> reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
            while (reader.hasNext()) {
                XMLEvent runtime;
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(PROPERTIES)) {
                    this.setAppEngineUseProperties(appEngineWebXmlProperties, (XMLEventReader)reader);
                    continue;
                }
                if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals(RUNTIME) || !(runtime = reader.nextEvent()).isCharacters()) continue;
                this.runtimeId = runtime.asCharacters().getData();
                appEngineWebXmlProperties.setProperty("GAE_RUNTIME", this.runtimeId);
            }
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "Cannot parse correctly {0}", this.appEngineWebXmlFile);
        }
        Properties systemProps = System.getProperties();
        for (String propName : systemProps.stringPropertyNames()) {
            if (!propName.startsWith("appengine.") && !propName.startsWith("GAE_RUNTIME")) continue;
            appEngineWebXmlProperties.setProperty(propName, systemProps.getProperty(propName));
        }
        for (String propName : appEngineWebXmlProperties.stringPropertyNames()) {
            if (!propName.startsWith("appengine.") && !propName.startsWith("GAE_RUNTIME")) continue;
            System.setProperty(propName, appEngineWebXmlProperties.getProperty(propName));
        }
        this.runtimeId = systemProps.getProperty("GAE_RUNTIME");
        if ((Objects.equals(this.runtimeId, "java17") || Objects.equals(this.runtimeId, "java21")) && Boolean.parseBoolean(System.getProperty("appengine.use.EE10", "false")) && Boolean.parseBoolean(System.getProperty("appengine.use.jetty121", "false"))) {
            System.setProperty("appengine.use.EE11", "true");
            System.setProperty("appengine.use.EE10", "false");
            logger.warning("appengine.use.EE10 is not supported with Jetty 12.1 for runtime " + this.runtimeId + ", upgrading to appengine.use.EE11.");
        }
        boolean useEE8 = Boolean.parseBoolean(System.getProperty("appengine.use.EE8", "false"));
        boolean useEE10 = Boolean.parseBoolean(System.getProperty("appengine.use.EE10", "false"));
        boolean useEE11 = Boolean.parseBoolean(System.getProperty("appengine.use.EE11", "false"));
        int trueCount = 0;
        if (useEE8) {
            ++trueCount;
        }
        if (useEE10) {
            ++trueCount;
        }
        if (useEE11) {
            ++trueCount;
        }
        if (trueCount > 1) {
            throw new IllegalArgumentException("Only one of appengine.use.EE8, appengine.use.EE10, or appengine.use.EE11 can be true.");
        }
        if (trueCount == 0) {
            if (Objects.equals(this.runtimeId, "java17")) {
                System.setProperty("appengine.use.EE8", "false");
            } else if (Objects.equals(this.runtimeId, "java21")) {
                if (Boolean.parseBoolean(System.getProperty("appengine.use.jetty121", "false"))) {
                    System.setProperty("appengine.use.EE11", "true");
                    System.setProperty("appengine.use.EE10", "false");
                } else {
                    System.setProperty("appengine.use.EE10", "true");
                }
            } else if (Objects.equals(this.runtimeId, "java25")) {
                System.setProperty("appengine.use.EE11", "true");
                System.setProperty("appengine.use.jetty121", "true");
            }
        } else if (Objects.equals(this.runtimeId, "java25")) {
            System.setProperty("appengine.use.jetty121", "true");
        }
        if (appEngineWebXmlProperties.getProperty("appengine.use.jetty121") == null && Boolean.getBoolean("appengine.use.EE11")) {
            System.setProperty("appengine.use.jetty121", "true");
        }
        if (Objects.equals(this.runtimeId, "java25") && Boolean.getBoolean("appengine.use.EE10")) {
            throw new IllegalArgumentException("appengine.use.EE10 is not supported in Jetty121");
        }
    }

    private void setAppEngineUseProperties(Properties config, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            StartElement element;
            String elementName;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(PROPERTIES)) {
                return;
            }
            if (!event.isStartElement() || !(elementName = (element = event.asStartElement()).getName().getLocalPart()).equals(PROPERTY)) continue;
            String prop = element.getAttributeByName(new QName("name")).getValue();
            String value = element.getAttributeByName(new QName("value")).getValue();
            config.put(prop, value);
            if (prop.equalsIgnoreCase("com.google.apphosting.runtime.jetty94.LEGACY_MODE")) {
                System.setProperty("com.google.apphosting.runtime.jetty94.LEGACY_MODE", value);
                continue;
            }
            if (prop.equalsIgnoreCase("appengine.use.HttpConnector")) {
                System.setProperty("appengine.use.HttpConnector", value);
                continue;
            }
            if (prop.equalsIgnoreCase("appengine.use.allheaders")) {
                System.setProperty("appengine.use.allheaders", value);
                continue;
            }
            if (!prop.equalsIgnoreCase("appengine.ignore.responseSizeLimit")) continue;
            System.setProperty("appengine.ignore.responseSizeLimit", value);
        }
    }

    public AppEngineWebXmlInitialParse(String file) {
        this.appEngineWebXmlFile = file;
        if (!GIT_HASH.equals("unknown")) {
            logger.log(Level.INFO, "appengine runtime jars built on {0} from commit {1}, version {2}", new Object[]{BUILD_TIMESTAMP, GIT_HASH, BUILD_VERSION});
        }
    }

    static {
        BUILD_PROPERTIES = new Properties();
        try (InputStream inputStream = AppEngineWebXmlInitialParse.class.getResourceAsStream("/com/google/appengine/init/build.properties");){
            BUILD_PROPERTIES.load(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GIT_HASH = BUILD_PROPERTIES.getProperty("buildNumber", "unknown");
        System.setProperty("appengine.git.hash", GIT_HASH);
        BUILD_TIMESTAMP = BUILD_PROPERTIES.getProperty("timestamp", "unknown");
        BUILD_VERSION = BUILD_PROPERTIES.getProperty("version", "unknown");
    }
}

