/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend;

import com.google.appengine.repackaged.com.google.common.flogger.LogSite;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogSiteFormatter;

public enum LogSiteFormatters implements LogSiteFormatter
{
    DEFAULT{

        @Override
        public boolean appendLogSite(LogSite logSite, StringBuilder out) {
            if (logSite == LogSite.INVALID) {
                return false;
            }
            out.append(logSite.getClassName()).append('.').append(logSite.getMethodName()).append(':').append(logSite.getLineNumber());
            return true;
        }
    }
    ,
    NO_OP{

        @Override
        public boolean appendLogSite(LogSite logSite, StringBuilder out) {
            return false;
        }
    }
    ,
    SIMPLE_CLASSNAME{

        @Override
        public boolean appendLogSite(LogSite logSite, StringBuilder out) {
            if (logSite == LogSite.INVALID) {
                return false;
            }
            String qualifiedClassName = logSite.getClassName();
            int lastDotIndex = qualifiedClassName.lastIndexOf(46);
            if (lastDotIndex == -1 || lastDotIndex + 1 >= qualifiedClassName.length()) {
                out.append(qualifiedClassName);
            } else {
                out.append(qualifiedClassName, lastDotIndex + 1, qualifiedClassName.length());
            }
            out.append('.').append(logSite.getMethodName()).append(':').append(logSite.getLineNumber());
            return true;
        }
    };

}

