/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.context;

import com.google.appengine.repackaged.com.google.common.flogger.LoggingScope;
import com.google.appengine.repackaged.com.google.common.flogger.MetadataKey;
import com.google.appengine.repackaged.com.google.common.flogger.context.ContextDataProvider;
import com.google.appengine.repackaged.com.google.common.flogger.context.ContextMetadata;
import com.google.appengine.repackaged.com.google.common.flogger.context.LogLevelMap;
import com.google.appengine.repackaged.com.google.common.flogger.context.ScopeType;
import com.google.appengine.repackaged.com.google.common.flogger.context.Tags;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.MustBeClosed;
import java.io.Closeable;
import java.util.concurrent.Callable;
import org.jspecify.annotations.Nullable;

public abstract class ScopedLoggingContext {
    public static ScopedLoggingContext getInstance() {
        return ContextDataProvider.getInstance().getContextApiSingleton();
    }

    protected ScopedLoggingContext() {
    }

    public abstract Builder newContext();

    public abstract Builder newContext(ScopeType var1);

    @Deprecated
    public Builder newScope() {
        return this.newContext();
    }

    @CanIgnoreReturnValue
    public boolean addTags(Tags tags) {
        Checks.checkNotNull(tags, "tags");
        return false;
    }

    @CanIgnoreReturnValue
    public <T> boolean addMetadata(MetadataKey<T> key, T value) {
        Checks.checkNotNull(key, "key");
        Checks.checkNotNull(value, "value");
        return false;
    }

    @CanIgnoreReturnValue
    public boolean applyLogLevelMap(LogLevelMap logLevelMap) {
        Checks.checkNotNull(logLevelMap, "log level map");
        return false;
    }

    private static void closeAndMaybePropagateError(LoggingContextCloseable context, boolean callerHasError) {
        block2: {
            try {
                context.close();
            }
            catch (RuntimeException e) {
                if (callerHasError) break block2;
                throw e instanceof InvalidLoggingContextStateException ? (InvalidLoggingContextStateException)e : new InvalidLoggingContextStateException("invalid logging context state", e);
            }
        }
    }

    boolean isNoOp() {
        return false;
    }

    public static interface LoggingContextCloseable
    extends Closeable {
        @Override
        public void close();
    }

    public static abstract class Builder {
        private @Nullable Tags tags = null;
        private @Nullable ContextMetadata.Builder metadata = null;
        private @Nullable LogLevelMap logLevelMap = null;
        private boolean hasLogLevelMap = false;

        protected Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder withTags(Tags tags) {
            Checks.checkState(this.tags == null, "tags already set");
            Checks.checkNotNull(tags, "tags");
            this.tags = tags;
            return this;
        }

        @CanIgnoreReturnValue
        public final <T> Builder withMetadata(MetadataKey<T> key, @Nullable T value) {
            if (value == null) {
                return this;
            }
            if (this.metadata == null) {
                this.metadata = ContextMetadata.builder();
            }
            this.metadata.add(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withLogLevelMap(@Nullable LogLevelMap logLevelMap) {
            Checks.checkState(!this.hasLogLevelMap, "log level map already set");
            this.hasLogLevelMap = true;
            this.logLevelMap = logLevelMap;
            return this;
        }

        public final Runnable wrap(final Runnable r) {
            return new Runnable(){

                @Override
                public void run() {
                    LoggingContextCloseable context = this.install();
                    boolean hasError = true;
                    try {
                        r.run();
                        hasError = false;
                    }
                    finally {
                        ScopedLoggingContext.closeAndMaybePropagateError(context, hasError);
                    }
                }
            };
        }

        public final <R> Callable<R> wrap(final Callable<R> c) {
            return new Callable<R>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public R call() throws Exception {
                    LoggingContextCloseable context = this.install();
                    boolean hasError = true;
                    try {
                        Object result = c.call();
                        hasError = false;
                        Object v = result;
                        return v;
                    }
                    finally {
                        ScopedLoggingContext.closeAndMaybePropagateError(context, hasError);
                    }
                }
            };
        }

        public final void run(Runnable r) {
            this.wrap(r).run();
        }

        @CanIgnoreReturnValue
        public final <R> R call(Callable<R> c) throws Exception {
            return this.wrap(c).call();
        }

        @CanIgnoreReturnValue
        public final <R> R callUnchecked(Callable<R> c) {
            try {
                return this.call(c);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("checked exception caught during context call", e);
            }
        }

        @MustBeClosed
        public abstract LoggingContextCloseable install();

        protected final @Nullable Tags getTags() {
            return this.tags;
        }

        protected final @Nullable ContextMetadata getMetadata() {
            return this.metadata != null ? this.metadata.build() : null;
        }

        protected final @Nullable LogLevelMap getLogLevelMap() {
            return this.logLevelMap;
        }
    }

    public static final class InvalidLoggingContextStateException
    extends IllegalStateException {
        public InvalidLoggingContextStateException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidLoggingContextStateException(String message) {
            super(message);
        }
    }

    public static final class ScopeList {
        private final ScopeType key;
        private final LoggingScope scope;
        private final @Nullable ScopeList next;

        public static @Nullable ScopeList addScope(@Nullable ScopeList list, @Nullable ScopeType type) {
            return type != null && ScopeList.lookup(list, type) == null ? new ScopeList(type, type.newScope(), list) : list;
        }

        public static @Nullable LoggingScope lookup(@Nullable ScopeList list, ScopeType type) {
            while (list != null) {
                if (type.equals(list.key)) {
                    return list.scope;
                }
                list = list.next;
            }
            return null;
        }

        public ScopeList(ScopeType key, LoggingScope scope, @Nullable ScopeList next) {
            this.key = Checks.checkNotNull(key, "scope type");
            this.scope = Checks.checkNotNull(scope, "scope");
            this.next = next;
        }
    }
}

