/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.codec.binary;

import com.google.appengine.repackaged.org.apache.commons.codec.binary.AbstractBaseNCodecStreamBuilder;
import com.google.appengine.repackaged.org.apache.commons.codec.binary.BaseNCodec;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class BaseNCodecOutputStream<C extends BaseNCodec, T extends BaseNCodecOutputStream<C, T, B>, B extends AbstractBuilder<T, C, B>>
extends FilterOutputStream {
    private final boolean doEncode;
    private final C baseNCodec;
    private final byte[] singleByte = new byte[1];
    private final BaseNCodec.Context context = new BaseNCodec.Context();

    protected BaseNCodecOutputStream(AbstractBuilder<T, C, B> builder) {
        super(builder.getOutputStream());
        this.baseNCodec = builder.getBaseNCodec();
        this.doEncode = builder.getEncode();
    }

    public BaseNCodecOutputStream(OutputStream outputStream, C basedCodec, boolean doEncode) {
        super(outputStream);
        this.baseNCodec = basedCodec;
        this.doEncode = doEncode;
    }

    @Override
    public void close() throws IOException {
        this.eof();
        this.flush();
        this.out.close();
    }

    public void eof() {
        if (this.doEncode) {
            ((BaseNCodec)this.baseNCodec).encode(this.singleByte, 0, -1, this.context);
        } else {
            ((BaseNCodec)this.baseNCodec).decode(this.singleByte, 0, -1, this.context);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    private void flush(boolean propagate) throws IOException {
        byte[] buf;
        int c;
        int avail = ((BaseNCodec)this.baseNCodec).available(this.context);
        if (avail > 0 && (c = ((BaseNCodec)this.baseNCodec).readResults(buf = new byte[avail], 0, avail, this.context)) > 0) {
            this.out.write(buf, 0, c);
        }
        if (propagate) {
            this.out.flush();
        }
    }

    public boolean isStrictDecoding() {
        return ((BaseNCodec)this.baseNCodec).isStrictDecoding();
    }

    @Override
    public void write(byte[] array, int offset, int len) throws IOException {
        Objects.requireNonNull(array, "array");
        if (offset < 0 || len < 0 || offset > array.length || offset + len > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > 0) {
            if (this.doEncode) {
                ((BaseNCodec)this.baseNCodec).encode(array, offset, len, this.context);
            } else {
                ((BaseNCodec)this.baseNCodec).decode(array, offset, len, this.context);
            }
            this.flush(false);
        }
    }

    @Override
    public void write(int i) throws IOException {
        this.singleByte[0] = (byte)i;
        this.write(this.singleByte, 0, 1);
    }

    public static abstract class AbstractBuilder<T, C extends BaseNCodec, B extends AbstractBuilder<T, C, B>>
    extends AbstractBaseNCodecStreamBuilder<T, C, B> {
        private OutputStream outputStream;

        protected OutputStream getOutputStream() {
            return this.outputStream;
        }

        public B setOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
            return (B)((AbstractBuilder)this.asThis());
        }
    }
}

