/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.appengine.tools.util.Logging;
import com.google.appengine.tools.util.Option;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public abstract class SharedMain {
    private static String originalTimeZone;
    private boolean disableRestrictedCheck = false;
    private String runtime = null;
    private List<String> propertyOptions = null;

    protected List<Option> getSharedOptions() {
        return Arrays.asList(new Option("h", "help", true){

            @Override
            public void apply() {
                SharedMain.this.printHelp(System.err);
                throw new TerminationException();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --help, -h                 Show this help message and exit.");
            }
        }, new Option(null, "sdk_root", false){

            @Override
            public void apply() {
                System.setProperty("appengine.sdk.root", this.getValue());
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --sdk_root=DIR             Overrides where the SDK is located.");
            }
        }, new Option(null, "disable_restricted_check", true){

            @Override
            public void apply() {
                SharedMain.this.disableRestrictedCheck = true;
            }
        }, new Option(null, "property", false){

            @Override
            public void apply() {
                SharedMain.this.propertyOptions = this.getValues();
            }
        }, new Option(null, "allow_remote_shutdown", true){

            @Override
            public void apply() {
                System.setProperty("appengine.allowRemoteShutdown", "true");
            }
        }, new Option(null, "no_java_agent", true){

            @Override
            public void apply() {
            }
        }, new Option(null, "runtime", false){

            @Override
            public void apply() {
                SharedMain.this.runtime = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --runtime=runtime_id       (java8 only).");
            }
        });
    }

    protected static void sharedInit() {
        SharedMain.recordTimeZone();
        Logging.initializeLogging();
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            Toolkit.getDefaultToolkit();
        }
    }

    private static void recordTimeZone() {
        originalTimeZone = System.getProperty("user.timezone");
        if (originalTimeZone == null) {
            originalTimeZone = "";
        }
    }

    protected abstract void printHelp(PrintStream var1);

    protected void postServerActions(Map<String, String> stringProperties) {
        this.setTimeZone(stringProperties);
        if (this.disableRestrictedCheck) {
            stringProperties.put("appengine.disableRestrictedCheck", "");
        }
    }

    protected void addPropertyOptionToProperties(Map<String, String> properties) {
        properties.putAll(SharedMain.parsePropertiesList(this.propertyOptions));
    }

    protected Map<String, String> getSystemProperties() {
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            throw new IllegalArgumentException("Non-string property " + String.valueOf(entry.getKey()));
        }
        Properties stringProperties = properties;
        return Collections.checkedMap(stringProperties, String.class, String.class);
    }

    private void setTimeZone(Map<String, String> serviceProperties) {
        String timeZone = serviceProperties.get("appengine.user.timezone");
        if (timeZone != null) {
            TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
        } else {
            timeZone = originalTimeZone;
        }
        serviceProperties.put("appengine.user.timezone.impl", timeZone);
    }

    public void validateWarPath(File war) {
        if (!war.exists()) {
            System.err.println("Unable to find the webapp directory " + String.valueOf(war));
            this.printHelp(System.err);
            throw new TerminationException();
        }
        if (!war.isDirectory()) {
            System.err.println("dev_appserver only accepts webapp directories, not war files.");
            this.printHelp(System.err);
            throw new TerminationException();
        }
    }

    protected void configureRuntime(File appDirectory) {
        if (this.runtime != null) {
            return;
        }
        AppEngineWebXml appEngineWebXml = new AppEngineWebXmlReader(appDirectory.getAbsolutePath()).readAppEngineWebXml();
        this.runtime = appEngineWebXml.getRuntime();
        if (this.runtime == null) {
            this.runtime = "java8";
        }
        if (this.runtime.equals("java7")) {
            throw new IllegalArgumentException("the Java7 runtime is not supported anymore.");
        }
        Map<String, String> props = appEngineWebXml.getSystemProperties();
        if (this.runtime.equals("java25")) {
            System.setProperty("appengine.use.jetty121", "true");
            if (props.containsKey("appengine.use.EE10")) {
                throw new IllegalArgumentException("appengine.use.EE10 is not supported in Jetty121");
            }
            if (props.containsKey("appengine.use.EE8")) {
                System.setProperty("appengine.use.EE8", props.get("appengine.use.EE8"));
            } else {
                System.setProperty("appengine.use.EE11", "true");
            }
        }
        if (props.containsKey("appengine.use.EE8")) {
            System.setProperty("appengine.use.EE8", props.get("appengine.use.EE8"));
        } else if (props.containsKey("appengine.use.EE11")) {
            System.setProperty("appengine.use.EE11", props.get("appengine.use.EE11"));
            System.setProperty("appengine.use.jetty121", "true");
        } else if (props.containsKey("appengine.use.EE10")) {
            System.setProperty("appengine.use.EE10", props.get("appengine.use.EE10"));
        }
        if (props.containsKey("appengine.use.jetty121")) {
            System.setProperty("appengine.use.jetty121", props.get("appengine.use.jetty121"));
        }
        AppengineSdk.resetSdk();
        SharedMain.sharedInit();
    }

    protected String getRuntime() {
        return this.runtime;
    }

    @VisibleForTesting
    static Map<String, String> parsePropertiesList(List<String> properties) {
        HashMap<String, String> parsedProperties = new HashMap<String, String>();
        if (properties != null) {
            for (String property : properties) {
                String[] propertyKeyValue = property.split("=", 2);
                if (propertyKeyValue.length == 2) {
                    parsedProperties.put(propertyKeyValue[0], propertyKeyValue[1]);
                    continue;
                }
                if (propertyKeyValue[0].startsWith("no")) {
                    parsedProperties.put(propertyKeyValue[0].substring(2), "false");
                    continue;
                }
                parsedProperties.put(propertyKeyValue[0], "true");
            }
        }
        return parsedProperties;
    }

    private static class TerminationException
    extends RuntimeException {
        TerminationException() {
        }
    }
}

