/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.tools.info.AppengineSdk;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class ClassicSdk
extends AppengineSdk {
    static final String JETTY9_HOME_LIB_PATH = "jetty94/jetty-home/lib";
    private static final String WEB_DEFAULT_LOCATION_DEVAPPSERVERJETTY9 = "com/google/appengine/tools/development/jetty9/webdefault.xml";

    ClassicSdk() {
    }

    @Override
    public String getWebDefaultLocation() {
        return WEB_DEFAULT_LOCATION_DEVAPPSERVERJETTY9;
    }

    public List<File> getUserJspLibFiles() {
        return Collections.unmodifiableList(this.getJetty9JspJars());
    }

    public List<File> getSharedJspLibFiles() {
        return Collections.unmodifiableList(this.getJetty9JspJars());
    }

    @Override
    public List<URL> getImplLibs() {
        return Collections.unmodifiableList(ClassicSdk.toURLs(this.getImplLibFiles()));
    }

    @Override
    public String getQuickStartClasspath() {
        ArrayList<Object> list = new ArrayList<Object>();
        File quickstart = new File(ClassicSdk.getSdkRoot(), "lib/tools/quickstart/quickstartgenerator.jar");
        File jettyDir = new File(ClassicSdk.getSdkRoot(), JETTY9_HOME_LIB_PATH);
        for (File f : jettyDir.listFiles()) {
            if (f.isDirectory() || f.getName().startsWith("cdi-") || f.getName().startsWith("jetty-cdi-")) continue;
            list.add(f.getAbsolutePath());
        }
        list.add(String.valueOf(ClassicSdk.getSdkRoot()) + "/lib/impl/appengine-api.jar");
        for (String subdir : new String[]{"annotations", "jaspi"}) {
            for (File f : new File(jettyDir, subdir).listFiles()) {
                list.add(f.getAbsolutePath());
            }
        }
        list.add(quickstart.getAbsolutePath());
        return Joiner.on(System.getProperty("path.separator")).join(list);
    }

    @Override
    public String getWebDefaultXml() {
        return String.valueOf(ClassicSdk.getSdkRoot()) + "/docs/webdefault.xml";
    }

    @Override
    public String getJettyContainerService() {
        return "com.google.appengine.tools.development.jetty9.JettyContainerService";
    }

    @Override
    public String getBackendServersClassName() {
        return "com.google.appengine.tools.development.BackendServersEE8";
    }

    @Override
    public String getModulesClassName() {
        return "com.google.appengine.tools.development.ModulesEE8";
    }

    @Override
    public String getDelegatingModulesFilterHelperClassName() {
        return "com.google.appengine.tools.development.DelegatingModulesFilterHelperEE8";
    }

    @Override
    public File getResourcesDirectory() {
        return new File(ClassicSdk.getSdkRoot(), "docs");
    }

    private List<File> getImplLibFiles() {
        List<File> lf = this.getJetty9Jars("");
        lf.addAll(this.getJetty9JspJars());
        lf.addAll(this.getJetty9Jars("annotations"));
        lf.addAll(this.getLibs(sdkRoot, "impl"));
        lf.addAll(this.getLibs(sdkRoot, "impl/jetty9"));
        return Collections.unmodifiableList(lf);
    }

    public List<URL> getSharedJspLibs() {
        return Collections.unmodifiableList(ClassicSdk.toURLs((List<File>)this.getSharedJspLibFiles()));
    }

    private List<File> getJetty9Jars(String subDir) {
        File path = new File(sdkRoot, JETTY9_HOME_LIB_PATH + File.separator + subDir);
        if (!path.exists()) {
            throw new IllegalArgumentException("Unable to find " + path.getAbsolutePath());
        }
        ArrayList<File> jars = new ArrayList<File>();
        for (File f : ClassicSdk.listFiles(path)) {
            if (!f.getName().endsWith(".jar") || f.getName().startsWith("jetty-cdi") || f.getName().startsWith("cdi")) continue;
            jars.add(f);
        }
        return jars;
    }

    List<File> getJetty9JspJars() {
        List<File> lf = this.getJetty9Jars("apache-jsp");
        lf.addAll(this.getJetty9Jars("apache-jstl"));
        return lf;
    }

    List<File> getJetty9SharedLibFiles() {
        ArrayList<File> sharedLibs = new ArrayList<File>();
        sharedLibs.add(new File(sdkRoot, "lib/shared/jetty9/appengine-local-runtime-shared.jar"));
        File jettyHomeLib = new File(sdkRoot, JETTY9_HOME_LIB_PATH);
        sharedLibs.add(new File(jettyHomeLib, "servlet-api-3.1.jar"));
        File schemas = new File(jettyHomeLib, "servlet-schemas-3.1.jar");
        if (schemas.exists()) {
            sharedLibs.add(schemas);
        } else {
            schemas = new File(jettyHomeLib, "jetty-schemas-3.1.jar");
            if (schemas.exists()) {
                sharedLibs.add(schemas);
            }
        }
        class JettyVersionFilter
        implements FileFilter {
            JettyVersionFilter() {
            }

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("jetty-util-");
            }
        }
        File[] files = jettyHomeLib.listFiles(new JettyVersionFilter());
        sharedLibs.addAll(Arrays.asList(files));
        sharedLibs.addAll(this.getJetty9JspJars());
        return sharedLibs;
    }

    @Override
    public List<URL> getSharedLibs() {
        return Collections.unmodifiableList(ClassicSdk.toURLs((List<File>)this.getSharedLibFiles()));
    }

    @Override
    public List<URL> getUserJspLibs() {
        return Collections.unmodifiableList(ClassicSdk.toURLs(this.getJetty9JspJars()));
    }

    public List<File> getSharedLibFiles() {
        List<File> sharedLibs = this.getJetty9SharedLibFiles();
        if (isDevAppServerTest) {
            sharedLibs.addAll(ClassicSdk.getLibsRecursive(sdkRoot, "testing"));
        }
        return Collections.unmodifiableList(sharedLibs);
    }

    @Override
    public String getJSPCompilerClassName() {
        return "com.google.appengine.tools.development.jetty9.LocalJspC";
    }
}

