/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import java.util.LinkedList;
import java.util.List;

public abstract class Option {
    private final String shortName;
    private final String longName;
    private final boolean isFlag;
    private Style style;
    private List<String> values;

    public Option(String shortName, String longName, boolean isFlag) {
        this.shortName = shortName;
        this.longName = longName;
        this.isFlag = isFlag;
        this.values = new LinkedList<String>();
    }

    public boolean isFlag() {
        return this.isFlag;
    }

    public Style getArgStyle() {
        return this.style;
    }

    public String getValue() {
        return Iterables.getLast(this.values, null);
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String toString() {
        return "Option{shortName='" + this.shortName + "', longName='" + this.longName + "', isFlag=" + this.isFlag + ", style=" + String.valueOf((Object)this.style) + ", values='" + String.valueOf(this.values) + "'}";
    }

    public abstract void apply();

    public List<String> getHelpLines() {
        return ImmutableList.of();
    }

    boolean parse(String[] args, int currentArg) {
        String argVal = args[currentArg];
        if (this.shortName != null && argVal.equals("-" + this.shortName)) {
            if (this.isFlag()) {
                return true;
            }
            if (currentArg + 1 == args.length) {
                throw new IllegalArgumentException(this.shortName + " requires an argument.\n");
            }
            this.values.add(args[currentArg + 1]);
            this.style = Style.Short;
            return true;
        }
        if (this.longName != null) {
            if (this.isFlag()) {
                return argVal.equals("--" + this.longName);
            }
            if (!argVal.startsWith("--" + this.longName + "=")) {
                return false;
            }
            String[] tokens = argVal.split("=", 2);
            if (tokens.length == 1) {
                throw new IllegalArgumentException(this.longName + " requires an argument, for example, \"" + this.longName + "=FOO\"\n");
            }
            this.values.add(tokens[1]);
            this.style = Style.Long;
            return true;
        }
        return false;
    }

    public static enum Style {
        Short,
        Long;

    }
}

