/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.util.List;

public class DispatchXml {
    private final List<DispatchEntry> dispatchEntries;

    public static Builder builder() {
        return new Builder();
    }

    private DispatchXml(List<DispatchEntry> dispatchEntries) {
        this.dispatchEntries = dispatchEntries;
    }

    public String toYaml() {
        StringBuilder builder = new StringBuilder("dispatch:\n");
        for (DispatchEntry entry : this.dispatchEntries) {
            builder.append("- url: " + this.yamlQuote(entry.getUrl()) + "\n");
            builder.append("  module: " + entry.getModule() + "\n");
        }
        return builder.toString();
    }

    private String yamlQuote(String str) {
        return "'" + str.replace("'", "''") + "'";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dispatchEntries == null ? 0 : this.dispatchEntries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DispatchXml)) {
            return false;
        }
        DispatchXml other = (DispatchXml)obj;
        return !(this.dispatchEntries == null ? other.dispatchEntries != null : !this.dispatchEntries.equals(other.dispatchEntries));
    }

    public static class Builder {
        private final ImmutableList.Builder<DispatchEntry> dispatchEntriesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder addDispatchEntry(DispatchEntry entry) {
            entry.validate();
            this.dispatchEntriesBuilder.add((Object)entry);
            return this;
        }

        public DispatchXml build() {
            return new DispatchXml((List<DispatchEntry>)((Object)this.dispatchEntriesBuilder.build()));
        }
    }

    public static class DispatchEntry {
        private final String url;
        private final String module;

        public DispatchEntry(String url, String module) {
            this.url = url;
            this.module = module;
        }

        public String getUrl() {
            return this.url;
        }

        public String getModule() {
            return this.module;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DispatchEntry)) {
                return false;
            }
            DispatchEntry other = (DispatchEntry)obj;
            if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        private void validate() {
            if (this.url == null) {
                throw new AppEngineConfigException("Invalid url in dispatch.xml - " + this.url);
            }
            if (this.module == null) {
                throw new AppEngineConfigException("Invalid module in dispatch.xml - " + this.module);
            }
        }
    }
}

