/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.apphosting.utils.config.IndexYamlReader;
import com.google.apphosting.utils.config.IndexesXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class IndexesXmlReader
extends AbstractConfigXmlReader<IndexesXml> {
    public static final String GENERATED_INDEX_FILENAME = "datastore-indexes-auto.xml";
    public static final String INDEX_FILENAME = "datastore-indexes.xml";
    public static final String INDEX_YAML_FILENAME = "WEB-INF/index.yaml";
    public static final String AUTOINDEX_TAG = "autoGenerate";
    private static final String FILENAME = "WEB-INF/datastore-indexes.xml";
    private static final String INDEX_TAG = "datastore-index";
    public static final String KIND_PROP = "kind";
    public static final String ANCESTOR_PROP = "ancestor";
    public static final String PROPERTY_TAG = "property";
    public static final String NAME_PROP = "name";
    public static final String DIRECTION_PROP = "direction";
    public static final String MODE_PROP = "mode";
    private static final Logger logger = Logger.getLogger(IndexesXmlReader.class.getName());
    private IndexesXml indexesXml;

    public IndexesXmlReader(String appDir) {
        super(appDir, false);
    }

    public IndexesXml readIndexesXml() {
        return this.readConfigXml();
    }

    @Override
    protected IndexesXml readConfigXml() {
        block18: {
            String filename = null;
            this.indexesXml = new IndexesXml();
            try {
                InputStream is;
                if (this.fileExists()) {
                    filename = this.getFilename();
                    is = this.getInputStream();
                    try {
                        this.processXml(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    logger.info("Successfully processed " + filename);
                }
                if (this.yamlFileExists()) {
                    filename = this.getYamlFilename();
                    IndexYamlReader.parse(this.getYamlReader(), this.indexesXml);
                    logger.info("Successfully processed " + filename);
                }
                if (!this.generatedFileExists()) break block18;
                filename = this.getAutoFilename();
                is = this.getGeneratedStream();
                try {
                    this.processXml(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                logger.info("Successfully processed " + filename);
            }
            catch (Exception e) {
                String msg = "Received exception processing " + filename;
                logger.log(Level.SEVERE, msg, e);
                if (e instanceof AppEngineConfigException) {
                    throw (AppEngineConfigException)e;
                }
                throw new AppEngineConfigException(msg, e);
            }
        }
        return this.indexesXml;
    }

    @Override
    protected IndexesXml processXml(InputStream is) {
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        for (Element child : XmlUtils.getChildren(root)) {
            if (child.getTagName().equals(INDEX_TAG)) {
                this.parseIndex(child);
                continue;
            }
            throw new AppEngineConfigException(this.getFilename() + " contains <" + child.getTagName() + "> instead of <datastore-index/>");
        }
        return this.indexesXml;
    }

    private void parseIndex(Element indexElement) {
        IndexesXml.Type indexType;
        String kind = indexElement.getAttribute(KIND_PROP);
        Boolean ancestorProp = null;
        String anc = XmlUtils.getAttributeOrNull(indexElement, ANCESTOR_PROP);
        if (anc == null) {
            indexType = null;
        } else {
            indexType = IndexesXml.Type.ORDERED;
            ancestorProp = anc.equals("true") || anc.equals("1");
        }
        IndexesXml.Index index = this.indexesXml.addNewIndex(kind, ancestorProp);
        for (Element propertyElement : XmlUtils.getChildren(indexElement)) {
            String name = propertyElement.getAttribute(NAME_PROP);
            String direction = XmlUtils.getAttributeOrNull(propertyElement, DIRECTION_PROP);
            String mode = XmlUtils.getAttributeOrNull(propertyElement, MODE_PROP);
            if (direction != null) {
                if (mode != null || indexType == IndexesXml.Type.GEO_SPATIAL) {
                    throw new AppEngineConfigException("The 'direction' attribute may not be specified in a 'geospatial' index.");
                }
                indexType = IndexesXml.Type.ORDERED;
            } else if (mode != null) {
                if (indexType == IndexesXml.Type.ORDERED) {
                    throw new AppEngineConfigException("The 'mode' attribute may not be specified with 'direction' or 'ancestor'.");
                }
                indexType = IndexesXml.Type.GEO_SPATIAL;
            }
            index.addNewProperty(name, direction, mode);
        }
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }

    protected File getGeneratedFile() {
        File genFile = new File(GenerationDirectory.getGenerationDirectory(new File(this.appDir)), GENERATED_INDEX_FILENAME);
        return genFile;
    }

    public String getAutoFilename() {
        return this.getGeneratedFile().getPath();
    }

    protected boolean generatedFileExists() {
        return this.getGeneratedFile().exists();
    }

    protected InputStream getGeneratedStream() throws Exception {
        return new FileInputStream(this.getGeneratedFile());
    }

    protected String getYamlFilename() {
        return this.appDir + INDEX_YAML_FILENAME;
    }

    protected boolean yamlFileExists() {
        return new File(this.getYamlFilename()).exists();
    }

    protected Reader getYamlReader() {
        try {
            return new FileReader(this.getYamlFilename());
        }
        catch (FileNotFoundException ex) {
            throw new AppEngineConfigException("Cannot find file" + this.getYamlFilename());
        }
    }
}

