/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueueXml {
    static final String RATE_REGEX = "([0-9]+(\\.[0-9]+)?)/([smhd])";
    static final Pattern RATE_PATTERN = Pattern.compile("([0-9]+(\\.[0-9]+)?)/([smhd])");
    static final String TOTAL_STORAGE_LIMIT_REGEX = "^([0-9]+(\\.[0-9]*)?[BKMGT]?)";
    static final Pattern TOTAL_STORAGE_LIMIT_PATTERN = Pattern.compile("^([0-9]+(\\.[0-9]*)?[BKMGT]?)");
    private static final int MAX_QUEUE_NAME_LENGTH = 100;
    private static final String QUEUE_NAME_REGEX = "[a-zA-Z\\d-]{1,100}";
    private static final Pattern QUEUE_NAME_PATTERN = Pattern.compile("[a-zA-Z\\d-]{1,100}");
    private static final String TASK_AGE_LIMIT_REGEX = "([0-9]+(?:\\.?[0-9]*(?:[eE][\\-+]?[0-9]+)?)?)([smhd])";
    private static final Pattern TASK_AGE_LIMIT_PATTERN = Pattern.compile("([0-9]+(?:\\.?[0-9]*(?:[eE][\\-+]?[0-9]+)?)?)([smhd])");
    private static final String MODE_REGEX = "push|pull";
    private static final Pattern MODE_PATTERN = Pattern.compile("push|pull");
    private static final int MAX_TARGET_LENGTH = 100;
    private static final String TARGET_REGEX = "[a-z\\d\\-\\.]{1,100}";
    private static final Pattern TARGET_PATTERN = Pattern.compile("[a-z\\d\\-\\.]{1,100}");
    private static final String DEFAULT_QUEUE = "default";
    private final LinkedHashMap<String, Entry> entries = new LinkedHashMap();
    private Entry lastEntry;
    private String totalStorageLimit = "";

    public static Entry defaultEntry() {
        return new Entry(DEFAULT_QUEUE, 5.0, RateUnit.SECOND, 5, null, null);
    }

    public Entry addNewEntry() {
        this.validateLastEntry();
        this.lastEntry = new Entry();
        return this.lastEntry;
    }

    public void addEntry(Entry entry) {
        this.validateLastEntry();
        this.lastEntry = entry;
        this.validateLastEntry();
    }

    public Collection<Entry> getEntries() {
        this.validateLastEntry();
        return this.entries.values();
    }

    public void validateLastEntry() {
        if (this.lastEntry == null) {
            return;
        }
        if (this.lastEntry.getName() == null) {
            throw new AppEngineConfigException("Queue entry must have a name.");
        }
        if (this.entries.containsKey(this.lastEntry.getName())) {
            throw new AppEngineConfigException("Queue entry has duplicate name.");
        }
        if ("pull".equals(this.lastEntry.getMode())) {
            if (this.lastEntry.getRate() != null) {
                throw new AppEngineConfigException("Rate must not be specified for pull queue.");
            }
            if (this.lastEntry.getBucketSize() != null) {
                throw new AppEngineConfigException("Bucket size must not be specified for pull queue.");
            }
            if (this.lastEntry.getMaxConcurrentRequests() != null) {
                throw new AppEngineConfigException("MaxConcurrentRequests must not be specified for pull queue.");
            }
            RetryParameters retryParameters = this.lastEntry.getRetryParameters();
            if (retryParameters != null) {
                if (retryParameters.getAgeLimitSec() != null) {
                    throw new AppEngineConfigException("Age limit must not be specified for pull queue.");
                }
                if (retryParameters.getMinBackoffSec() != null) {
                    throw new AppEngineConfigException("Min backoff must not be specified for pull queue.");
                }
                if (retryParameters.getMaxBackoffSec() != null) {
                    throw new AppEngineConfigException("Max backoff must not be specified for pull queue.");
                }
                if (retryParameters.getMaxDoublings() != null) {
                    throw new AppEngineConfigException("Max doublings must not be specified for pull queue.");
                }
            }
        } else if (this.lastEntry.getRate() == null) {
            throw new AppEngineConfigException("A queue rate is required for push queue.");
        }
        this.entries.put(this.lastEntry.getName(), this.lastEntry);
        this.lastEntry = null;
    }

    public void setTotalStorageLimit(String s) {
        this.totalStorageLimit = s;
    }

    public String getTotalStorageLimit() {
        return this.totalStorageLimit;
    }

    public String toYaml() {
        StringBuilder builder = new StringBuilder();
        if (this.getTotalStorageLimit().length() > 0) {
            builder.append("total_storage_limit: " + this.getTotalStorageLimit() + "\n\n");
        }
        builder.append("queue:\n");
        for (Entry ent : this.getEntries()) {
            List<AclEntry> acl;
            String mode;
            String target;
            RetryParameters retryParameters;
            Integer maxConcurrentRequests;
            Integer bucketSize;
            builder.append("- name: " + ent.getName() + "\n");
            Double rate = ent.getRate();
            if (rate != null) {
                builder.append("  rate: " + rate + "/" + ent.getRateUnit().getIdent() + "\n");
            }
            if ((bucketSize = ent.getBucketSize()) != null) {
                builder.append("  bucket_size: " + bucketSize + "\n");
            }
            if ((maxConcurrentRequests = ent.getMaxConcurrentRequests()) != null) {
                builder.append("  max_concurrent_requests: " + maxConcurrentRequests + "\n");
            }
            if ((retryParameters = ent.getRetryParameters()) != null) {
                builder.append("  retry_parameters:\n");
                if (retryParameters.getRetryLimit() != null) {
                    builder.append("    task_retry_limit: " + retryParameters.getRetryLimit() + "\n");
                }
                if (retryParameters.getAgeLimitSec() != null) {
                    builder.append("    task_age_limit: " + retryParameters.getAgeLimitSec() + "s\n");
                }
                if (retryParameters.getMinBackoffSec() != null) {
                    builder.append("    min_backoff_seconds: " + retryParameters.getMinBackoffSec() + "\n");
                }
                if (retryParameters.getMaxBackoffSec() != null) {
                    builder.append("    max_backoff_seconds: " + retryParameters.getMaxBackoffSec() + "\n");
                }
                if (retryParameters.getMaxDoublings() != null) {
                    builder.append("    max_doublings: " + retryParameters.getMaxDoublings() + "\n");
                }
            }
            if ((target = ent.getTarget()) != null) {
                builder.append("  target: " + target + "\n");
            }
            if ((mode = ent.getMode()) != null) {
                builder.append("  mode: " + mode + "\n");
            }
            if ((acl = ent.getAcl()) == null) continue;
            builder.append("  acl:\n");
            for (AclEntry aclEntry : acl) {
                if (aclEntry.getUserEmail() != null) {
                    builder.append("  - user_email: " + aclEntry.getUserEmail() + "\n");
                    continue;
                }
                if (aclEntry.getWriterEmail() == null) continue;
                builder.append("  - writer_email: " + aclEntry.getWriterEmail() + "\n");
            }
        }
        return builder.toString();
    }

    public static class Entry {
        private String name;
        private Double rate;
        private RateUnit rateUnit;
        private Integer bucketSize;
        private Integer maxConcurrentRequests;
        private RetryParameters retryParameters;
        private String target;
        private String mode;
        private List<AclEntry> acl;

        public Entry() {
            this.name = null;
            this.rate = null;
            this.rateUnit = RateUnit.SECOND;
            this.bucketSize = null;
            this.maxConcurrentRequests = null;
            this.retryParameters = null;
            this.target = null;
            this.mode = null;
            this.acl = null;
        }

        public Entry(String name, double rate, RateUnit rateUnit, int bucketSize, Integer maxConcurrentRequests, String target) {
            this.name = name;
            this.rate = rate;
            this.rateUnit = rateUnit;
            this.bucketSize = bucketSize;
            this.maxConcurrentRequests = maxConcurrentRequests;
            this.target = target;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String queueName) {
            if (queueName == null || queueName.length() == 0 || !QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
                throw new AppEngineConfigException("Queue name does not match expression " + String.valueOf(QUEUE_NAME_PATTERN) + "; found '" + queueName + "'");
            }
            this.name = queueName;
        }

        public void setMode(String mode) {
            if (mode == null || mode.length() == 0 || !MODE_PATTERN.matcher(mode).matches()) {
                throw new AppEngineConfigException("mode must be either 'push' or 'pull'");
            }
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public List<AclEntry> getAcl() {
            return this.acl;
        }

        public void setAcl(List<AclEntry> acl) {
            this.acl = acl;
        }

        public void addAcl(AclEntry aclEntry) {
            this.acl.add(aclEntry);
        }

        public Double getRate() {
            return this.rate;
        }

        public void setRate(double rate) {
            this.rate = rate;
        }

        public void setRate(String rateString) {
            if (rateString.equals("0")) {
                this.rate = 0.0;
                this.rateUnit = RateUnit.SECOND;
                return;
            }
            Matcher matcher = RATE_PATTERN.matcher(rateString);
            if (!matcher.matches()) {
                throw new AppEngineConfigException("Invalid queue rate was specified.");
            }
            String digits = matcher.group(1);
            this.rateUnit = RateUnit.valueOf(matcher.group(3).charAt(0));
            this.rate = Double.valueOf(digits);
        }

        public RateUnit getRateUnit() {
            return this.rateUnit;
        }

        public void setRateUnit(RateUnit rateUnit) {
            this.rateUnit = rateUnit;
        }

        public Integer getBucketSize() {
            return this.bucketSize;
        }

        public void setBucketSize(int bucketSize) {
            this.bucketSize = bucketSize;
        }

        public void setBucketSize(String bucketSize) {
            try {
                this.bucketSize = Integer.valueOf(bucketSize);
            }
            catch (NumberFormatException exception) {
                throw new AppEngineConfigException("Invalid bucket-size was specified.", exception);
            }
        }

        public Integer getMaxConcurrentRequests() {
            return this.maxConcurrentRequests;
        }

        public void setMaxConcurrentRequests(int maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
        }

        public void setMaxConcurrentRequests(String maxConcurrentRequests) {
            try {
                this.maxConcurrentRequests = Integer.valueOf(maxConcurrentRequests);
            }
            catch (NumberFormatException exception) {
                throw new AppEngineConfigException("Invalid max-concurrent-requests was specified: '" + maxConcurrentRequests + "'", exception);
            }
        }

        public RetryParameters getRetryParameters() {
            return this.retryParameters;
        }

        public void setRetryParameters(RetryParameters retryParameters) {
            this.retryParameters = retryParameters;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            Matcher matcher = TARGET_PATTERN.matcher(target);
            if (!matcher.matches()) {
                throw new AppEngineConfigException("Invalid queue target was specified. Target: '" + target + "'");
            }
            this.target = target;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.acl == null ? 0 : this.acl.hashCode());
            result = 31 * result + (this.bucketSize == null ? 0 : this.bucketSize.hashCode());
            result = 31 * result + (this.maxConcurrentRequests == null ? 0 : this.maxConcurrentRequests.hashCode());
            result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.rate == null ? 0 : this.rate.hashCode());
            result = 31 * result + (this.rateUnit == null ? 0 : this.rateUnit.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            result = 31 * result + (this.retryParameters == null ? 0 : this.retryParameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.acl == null ? other.acl != null : !this.acl.equals(other.acl)) {
                return false;
            }
            if (this.bucketSize == null ? other.bucketSize != null : !this.bucketSize.equals(other.bucketSize)) {
                return false;
            }
            if (this.maxConcurrentRequests == null ? other.maxConcurrentRequests != null : !this.maxConcurrentRequests.equals(other.maxConcurrentRequests)) {
                return false;
            }
            if (this.mode == null ? other.mode != null : !this.mode.equals(other.mode)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.rate == null ? other.rate != null : !this.rate.equals(other.rate)) {
                return false;
            }
            if (this.rateUnit == null ? other.rateUnit != null : !this.rateUnit.equals((Object)other.rateUnit)) {
                return false;
            }
            if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
                return false;
            }
            return !(this.retryParameters == null ? other.retryParameters != null : !this.retryParameters.equals(other.retryParameters));
        }
    }

    public static enum RateUnit {
        SECOND('s', 1),
        MINUTE('m', SECOND.getSeconds() * 60),
        HOUR('h', MINUTE.getSeconds() * 60),
        DAY('d', HOUR.getSeconds() * 24);

        final char ident;
        final int seconds;

        private RateUnit(char ident, int seconds) {
            this.ident = ident;
            this.seconds = seconds;
        }

        static RateUnit valueOf(char unit) {
            switch (unit) {
                case 's': {
                    return SECOND;
                }
                case 'm': {
                    return MINUTE;
                }
                case 'h': {
                    return HOUR;
                }
                case 'd': {
                    return DAY;
                }
            }
            throw new AppEngineConfigException("Invalid rate was specified.");
        }

        public char getIdent() {
            return this.ident;
        }

        public int getSeconds() {
            return this.seconds;
        }
    }

    public static class RetryParameters {
        private Integer retryLimit = null;
        private Integer ageLimitSec = null;
        private Double minBackoffSec = null;
        private Double maxBackoffSec = null;
        private Integer maxDoublings = null;

        public Integer getRetryLimit() {
            return this.retryLimit;
        }

        public void setRetryLimit(int retryLimit) {
            this.retryLimit = retryLimit;
        }

        public void setRetryLimit(String retryLimit) {
            this.retryLimit = Integer.valueOf(retryLimit);
        }

        public Integer getAgeLimitSec() {
            return this.ageLimitSec;
        }

        public void setAgeLimitSec(String ageLimitString) {
            Matcher matcher = TASK_AGE_LIMIT_PATTERN.matcher(ageLimitString);
            if (!matcher.matches() || matcher.groupCount() != 2) {
                throw new AppEngineConfigException("Invalid task age limit was specified.");
            }
            double rateUnitSec = RateUnit.valueOf(matcher.group(2).charAt(0)).getSeconds();
            Double ageLimit = Double.parseDouble(matcher.group(1)) * rateUnitSec;
            this.ageLimitSec = ageLimit.intValue();
        }

        public Double getMinBackoffSec() {
            return this.minBackoffSec;
        }

        public void setMinBackoffSec(double minBackoffSec) {
            this.minBackoffSec = minBackoffSec;
        }

        public void setMinBackoffSec(String minBackoffSec) {
            this.minBackoffSec = Double.valueOf(minBackoffSec);
        }

        public Double getMaxBackoffSec() {
            return this.maxBackoffSec;
        }

        public void setMaxBackoffSec(double maxBackoffSec) {
            this.maxBackoffSec = maxBackoffSec;
        }

        public void setMaxBackoffSec(String maxBackoffSec) {
            this.maxBackoffSec = Double.valueOf(maxBackoffSec);
        }

        public Integer getMaxDoublings() {
            return this.maxDoublings;
        }

        public void setMaxDoublings(int maxDoublings) {
            this.maxDoublings = maxDoublings;
        }

        public void setMaxDoublings(String maxDoublings) {
            this.maxDoublings = Integer.valueOf(maxDoublings);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ageLimitSec == null ? 0 : this.ageLimitSec.hashCode());
            result = 31 * result + (this.maxBackoffSec == null ? 0 : this.maxBackoffSec.hashCode());
            result = 31 * result + (this.maxDoublings == null ? 0 : this.maxDoublings.hashCode());
            result = 31 * result + (this.minBackoffSec == null ? 0 : this.minBackoffSec.hashCode());
            result = 31 * result + (this.retryLimit == null ? 0 : this.retryLimit.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RetryParameters other = (RetryParameters)obj;
            if (this.ageLimitSec == null ? other.ageLimitSec != null : !this.ageLimitSec.equals(other.ageLimitSec)) {
                return false;
            }
            if (this.maxBackoffSec == null ? other.maxBackoffSec != null : !this.maxBackoffSec.equals(other.maxBackoffSec)) {
                return false;
            }
            if (this.maxDoublings == null ? other.maxDoublings != null : !this.maxDoublings.equals(other.maxDoublings)) {
                return false;
            }
            if (this.minBackoffSec == null ? other.minBackoffSec != null : !this.minBackoffSec.equals(other.minBackoffSec)) {
                return false;
            }
            return !(this.retryLimit == null ? other.retryLimit != null : !this.retryLimit.equals(other.retryLimit));
        }
    }

    public static class AclEntry {
        private String userEmail = null;
        private String writerEmail = null;

        public void setUserEmail(String userEmail) {
            this.userEmail = userEmail;
        }

        public String getUserEmail() {
            return this.userEmail;
        }

        public void setWriterEmail(String writerEmail) {
            this.writerEmail = writerEmail;
        }

        public String getWriterEmail() {
            return this.writerEmail;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.userEmail == null ? 0 : this.userEmail.hashCode());
            result = 31 * result + (this.writerEmail == null ? 0 : this.writerEmail.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AclEntry other = (AclEntry)obj;
            if (this.userEmail == null ? other.userEmail != null : !this.userEmail.equals(other.userEmail)) {
                return false;
            }
            return !(this.writerEmail == null ? other.writerEmail != null : !this.writerEmail.equals(other.writerEmail));
        }
    }
}

