/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine;

import java.io.File;

public class Utils {
    public static String getPythonExecutableLocation() {
        String pythonLocation = "python";
        boolean isWindows = System.getProperty("os.name").contains("Windows");
        if (isWindows) {
            pythonLocation = System.getenv("CLOUDSDK_PYTHON");
            if (pythonLocation == null) {
                pythonLocation = "python.exe";
            }
        } else {
            String possibleLinuxPythonLocation = System.getenv("CLOUDSDK_PYTHON");
            if (possibleLinuxPythonLocation != null) {
                pythonLocation = possibleLinuxPythonLocation;
            }
        }
        return pythonLocation;
    }

    public static String getCloudSDKLocation() {
        String gcloudDir;
        boolean isWindows = System.getProperty("os.name").contains("Windows");
        if (isWindows) {
            String relPath = "\\Google\\Cloud SDK\\google-cloud-sdk";
            String localSDK = System.getenv("LOCALAPPDATA") + relPath;
            if (new File(localSDK).exists()) {
                return localSDK;
            }
            String programFiles = System.getenv("ProgramFiles");
            if (programFiles == null) {
                programFiles = System.getenv("ProgramFiles(x86)");
            }
            gcloudDir = programFiles == null ? "cannotFindProgramFiles" : programFiles + relPath;
        } else {
            gcloudDir = System.getProperty("user.home") + "/google-cloud-sdk";
            if (!new File(gcloudDir).exists()) {
                gcloudDir = "/google/google-cloud-sdk";
                if (!new File(gcloudDir).exists()) {
                    gcloudDir = "/usr/lib/google-cloud-sdk";
                }
                if (!new File(gcloudDir).exists()) {
                    gcloudDir = "/usr/local/share/google/google-cloud-sdk";
                }
            }
        }
        return gcloudDir;
    }

    public static boolean canDisableImportOfPythonModuleSite() {
        String sitePackages = System.getenv("CLOUDSDK_PYTHON_SITEPACKAGES");
        String virtualEnv = System.getenv("VIRTUAL_ENV");
        boolean noSiteDefined = sitePackages == null || sitePackages.isEmpty();
        boolean noVirtEnvDefined = virtualEnv == null || virtualEnv.isEmpty();
        return noSiteDefined && noVirtEnvDefined;
    }
}

