/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.gcloudapp;

import com.google.appengine.SdkResolver;
import com.google.appengine.Utils;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.tools.admin.AppCfg;
import com.google.apphosting.utils.config.AppEngineApplicationXml;
import com.google.apphosting.utils.config.AppEngineApplicationXmlReader;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.EarHelper;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.ini4j.Ini;
import org.ini4j.Profile;

public abstract class AbstractGcloudMojo
extends AbstractMojo {
    protected MavenProject maven_project;
    protected String gcloud_directory;
    protected String docker_host;
    protected String docker_tls_verify;
    protected String docker_cert_path;
    protected String verbosity;
    protected String gcloud_project;
    protected String version;
    protected boolean quiet = true;
    protected String application_directory;
    protected boolean remote;
    protected String docker_build;
    protected String staging_directory;
    protected String runtime;
    protected String server;
    protected boolean force;
    protected String compile_encoding;
    protected boolean delete_jsps;
    protected boolean disable_jar_jsps;
    protected boolean enable_jar_classes;
    protected boolean enable_jar_splitting;
    protected boolean no_symlinks;
    protected boolean retain_upload_dir;
    protected String jar_splitting_excludes;
    protected boolean deployCommand = false;
    protected String appengine_config_directory;
    protected String gcloud_app_prefix;
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> projectRepos;
    protected List<RemoteRepository> pluginRepos;

    protected abstract ArrayList<String> getCommand(String var1) throws MojoExecutionException;

    protected ArrayList<String> setupInitialCommands(ArrayList<String> commands) throws MojoExecutionException {
        File s;
        File script;
        String pythonLocation = Utils.getPythonExecutableLocation();
        commands.add(pythonLocation);
        if (Utils.canDisableImportOfPythonModuleSite()) {
            commands.add("-S");
        }
        if (this.gcloud_directory == null) {
            this.gcloud_directory = Utils.getCloudSDKLocation();
        }
        if (!(script = new File(s = new File(this.gcloud_directory), "/lib/googlecloudsdk/gcloud/gcloud.py")).exists()) {
            script = new File(s, "/lib/gcloud.py");
        }
        if (!script.exists()) {
            this.getLog().error((CharSequence)"Cannot determine the default location of the Google Cloud SDK.");
            this.getLog().error((CharSequence)"If you need to install the Google Cloud SDK, follow the instructions located at https://cloud.google.com/appengine/docs/java/managed-vms");
            this.getLog().error((CharSequence)"You can then set it via <gcloud_directory> </gcloud_directory> in the pom.xml");
            throw new MojoExecutionException("Unknown Google Cloud SDK location: " + this.gcloud_directory);
        }
        if (this.deployCommand) {
            commands.add(script.getAbsolutePath());
            if (this.quiet) {
                commands.add("--quiet");
            }
            if (this.verbosity != null) {
                commands.add("--verbosity=" + this.verbosity);
            }
            if (this.gcloud_project != null) {
                commands.add("--project=" + this.gcloud_project);
            }
            if (this.gcloud_app_prefix != null) {
                commands.add(this.gcloud_app_prefix);
            }
            commands.add("app");
        } else {
            File devServer = new File(this.gcloud_directory + "/platform/google_appengine/dev_appserver.py");
            if (!devServer.exists()) {
                this.installJavaAppEngineComponent(pythonLocation);
            }
            commands.add(this.gcloud_directory + "/platform/google_appengine/dev_appserver.py");
            commands.add("--skip_sdk_update_check=true");
            if (this.verbosity != null) {
                commands.add("--dev_appserver_log_level=" + this.verbosity);
            }
            if (this.gcloud_project != null) {
                commands.add("-A");
                commands.add(this.gcloud_project);
            } else {
                commands.add("-A");
                commands.add("app");
            }
        }
        return commands;
    }

    protected void startCommand(File appDirFile, ArrayList<String> devAppServerCommand, WaitDirective waitDirective) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Running " + Joiner.on((String)" ").join(devAppServerCommand)));
        try {
            boolean userDefined;
            ProcessBuilder processBuilder = new ProcessBuilder(devAppServerCommand);
            processBuilder.directory(appDirFile);
            processBuilder.redirectErrorStream(true);
            Map<String, String> env = processBuilder.environment();
            String env_docker_host = env.get("DOCKER_HOST");
            String docker_host_tls_verify = env.get("DOCKER_TLS_VERIFY");
            String docker_host_cert_path = env.get("DOCKER_CERT_PATH");
            boolean bl = userDefined = env_docker_host != null || docker_host_tls_verify != null || docker_host_cert_path != null;
            if (!userDefined) {
                if ("ENV_or_default".equals(this.docker_host)) {
                    if (env_docker_host == null) {
                        env_docker_host = env.get("DEVSHELL_CLIENT_PORT") != null ? "unix:///var/run/docker.sock" : "tcp://192.168.99.100:2376";
                    }
                } else {
                    env_docker_host = this.docker_host;
                }
                env.put("DOCKER_HOST", env_docker_host);
                if (env_docker_host.startsWith("tcp")) {
                    boolean dockerless;
                    if ("ENV_or_default".equals(this.docker_tls_verify)) {
                        if (env.get("DOCKER_TLS_VERIFY") == null) {
                            env.put("DOCKER_TLS_VERIFY", "1");
                        }
                    } else {
                        env.put("DOCKER_TLS_VERIFY", this.docker_tls_verify);
                    }
                    boolean bl2 = dockerless = this.deployCommand && this.remote;
                    if (!dockerless) {
                        if ("ENV_or_default".equals(this.docker_cert_path)) {
                            if (env.get("DOCKER_CERT_PATH") == null) {
                                env.put("DOCKER_CERT_PATH", System.getProperty("user.home") + File.separator + ".docker" + File.separator + "machine" + File.separator + "machines" + File.separator + "default");
                            }
                        } else {
                            env.put("DOCKER_CERT_PATH", this.docker_cert_path);
                        }
                    }
                }
            }
            env.put("PYTHONPATH", this.gcloud_directory + "/platform/google_appengine/lib/docker");
            final Process devServerProcess = processBuilder.start();
            final CountDownLatch waitStartedLatch = new CountDownLatch(1);
            final Scanner stdOut = new Scanner(devServerProcess.getInputStream());
            Thread stdOutThread = new Thread("standard-out-redirection-devappserver"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean serverStartedOK = false;
                    try {
                        long healthCount = 0L;
                        while (stdOut.hasNextLine() && !Thread.interrupted()) {
                            String line = stdOut.nextLine();
                            if (line.contains("GET /_ah/health?IsLastSuccessful=yes HTTP/1.1\" 200 2")) {
                                waitStartedLatch.countDown();
                                if (healthCount % 20L == 0L) {
                                    AbstractGcloudMojo.this.getLog().info((CharSequence)line);
                                }
                                ++healthCount;
                                continue;
                            }
                            if (line.contains("Dev App Server is now running")) {
                                waitStartedLatch.countDown();
                                serverStartedOK = true;
                                continue;
                            }
                            if (line.contains("INFO:oejs.Server:main: Started")) {
                                waitStartedLatch.countDown();
                                serverStartedOK = true;
                                continue;
                            }
                            AbstractGcloudMojo.this.getLog().info((CharSequence)line);
                        }
                    }
                    finally {
                        waitStartedLatch.countDown();
                        if (!serverStartedOK && !AbstractGcloudMojo.this.deployCommand) {
                            throw new RuntimeException("The Java Dev Server has stopped.");
                        }
                    }
                }
            };
            stdOutThread.setDaemon(true);
            stdOutThread.start();
            final Scanner stdErr = new Scanner(devServerProcess.getErrorStream());
            Thread stdErrThread = new Thread("standard-err-redirection-devappserver"){

                @Override
                public void run() {
                    while (stdErr.hasNextLine() && !Thread.interrupted()) {
                        AbstractGcloudMojo.this.getLog().error((CharSequence)stdErr.nextLine());
                    }
                }
            };
            stdErrThread.setDaemon(true);
            stdErrThread.start();
            if (waitDirective == WaitDirective.WAIT_SERVER_STOPPED) {
                Runtime.getRuntime().addShutdownHook(new Thread("destroy-devappserver"){

                    @Override
                    public void run() {
                        if (devServerProcess != null) {
                            devServerProcess.destroy();
                        }
                    }
                });
                devServerProcess.waitFor();
                int status = devServerProcess.exitValue();
                if (status != 0) {
                    this.getLog().error((CharSequence)("Error: gcloud app command with exit code : " + status));
                    throw new MojoExecutionException("Error: gcloud app command exit code is: " + status);
                }
            } else if (waitDirective == WaitDirective.WAIT_SERVER_STARTED) {
                waitStartedLatch.await();
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"App Engine Dev Server started in Async mode and running.");
                this.getLog().info((CharSequence)"you can stop it with this command: mvn gcloud:run_stop");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not start the dev app server", (Exception)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String getApplicationDirectory() throws MojoExecutionException {
        if (this.application_directory != null) {
            return this.application_directory;
        }
        this.application_directory = this.maven_project.getBuild().getDirectory() + "/" + this.maven_project.getBuild().getFinalName();
        File appDirFile = new File(this.application_directory);
        if (!appDirFile.exists()) {
            throw new MojoExecutionException("The application directory does not exist : " + this.application_directory);
        }
        if (!appDirFile.isDirectory()) {
            throw new MojoExecutionException("The application directory is not a directory : " + this.application_directory);
        }
        return this.application_directory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getProjectIdfromMetaData() {
        try {
            URL url = new URL("http://metadata/computeMetadata/v1/project/project-id");
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("X-Google-Metadata-Request", "True");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));){
                String string = reader.readLine();
                return string;
            }
        }
        catch (IOException ignore) {
            return null;
        }
    }

    protected String getAppId() throws MojoExecutionException {
        if (this.gcloud_project != null) {
            return this.gcloud_project;
        }
        try {
            String project;
            String userHome = System.getProperty("os.name").contains("Windows") ? System.getenv("APPDATA") : System.getProperty("user.home") + "/.config";
            File cloudSDKProperties = new File(userHome + "/gcloud/properties");
            String env = System.getenv("CLOUDSDK_CONFIG");
            if (env != null) {
                cloudSDKProperties = new File(env, "properties");
            }
            if (cloudSDKProperties.exists()) {
                Ini ini = new Ini();
                ini.load((Reader)new FileReader(cloudSDKProperties));
                Profile.Section section = (Profile.Section)ini.get((Object)"core");
                String project2 = (String)section.get((Object)"project");
                if (project2 != null) {
                    this.getLog().info((CharSequence)("Getting project name: " + project2 + " from gcloud settings."));
                    return project2;
                }
            }
            if ((project = this.getProjectIdfromMetaData()) != null) {
                this.getLog().info((CharSequence)("Getting project name: " + project + " from the metadata server."));
                return project;
            }
        }
        catch (IOException userHome) {
            // empty catch block
        }
        String appDir = this.getApplicationDirectory();
        if (EarHelper.isEar((String)appDir)) {
            AppEngineApplicationXmlReader reader = new AppEngineApplicationXmlReader();
            AppEngineApplicationXml appEngineApplicationXml = reader.processXml(AbstractGcloudMojo.getInputStream(new File(appDir, "META-INF/appengine-application.xml")));
            return appEngineApplicationXml.getApplicationId();
        }
        if (new File(appDir, "WEB-INF/appengine-web.xml").exists()) {
            return this.getAppEngineWebXml(appDir).getAppId();
        }
        return null;
    }

    private static InputStream getInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalStateException("File should exist - '" + file + "'");
        }
    }

    protected AppEngineWebXml getAppEngineWebXml(String webAppDir) throws MojoExecutionException {
        AppEngineWebXmlReader reader = new AppEngineWebXmlReader(webAppDir);
        AppEngineWebXml appengineWebXml = reader.readAppEngineWebXml();
        return appengineWebXml;
    }

    protected void resolveAndSetSdkRoot() throws MojoExecutionException {
        File sdkBaseDir = SdkResolver.getSdk(this.maven_project, this.repoSystem, this.repoSession, this.pluginRepos, this.projectRepos);
        try {
            System.setProperty("appengine.sdk.root", sdkBaseDir.getCanonicalPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not open SDK zip archive.", (Exception)e);
        }
    }

    protected String getJavaVersion() {
        String javaVersion = "1.7";
        Plugin p = this.maven_project.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (p != null) {
            Xpp3Dom config = (Xpp3Dom)p.getConfiguration();
            if (config == null) {
                return javaVersion;
            }
            Xpp3Dom domVersion = config.getChild("target");
            if (domVersion != null) {
                javaVersion = domVersion.getValue();
            }
        }
        return javaVersion;
    }

    protected File executeAppCfgStagingCommand(String appDir) throws MojoExecutionException {
        File index;
        File[] yamlFiles;
        boolean isFlex;
        ArrayList<String> arguments = new ArrayList<String>();
        File destinationDir = new File(this.staging_directory);
        if (!destinationDir.getParentFile().getAbsolutePath().equals(this.maven_project.getBuild().getDirectory())) {
            throw new MojoExecutionException("Does not want to delete a directory no under the target directory" + this.staging_directory);
        }
        try {
            FileUtils.deleteDirectory((File)destinationDir);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot delete staging directory.", (Exception)ex);
        }
        this.getLog().info((CharSequence)("Creating staging directory in: " + destinationDir.getAbsolutePath()));
        this.resolveAndSetSdkRoot();
        AppEngineWebXml appengineWeb = this.getAppEngineWebXml(appDir);
        if ("true".equals(appengineWeb.getBetaSettings().get("java_quickstart"))) {
            arguments.add("--enable_quickstart");
        }
        arguments.add("--disable_update_check");
        File appDirFile = new File(appDir);
        if (!new File(appDirFile, ".appyamlgenerated").exists()) {
            try {
                PrintWriter out = new PrintWriter(new File(appDirFile, ".appyamlgenerated"));
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                Date date = new Date();
                System.out.println(dateFormat.format(date));
                out.println("generated by the Maven Plugin on " + dateFormat.format(date));
                out.close();
            }
            catch (FileNotFoundException ex) {
                throw new MojoExecutionException("Error: generating .appyamlgenerated " + ex);
            }
        }
        arguments.add("-A");
        arguments.add("notused");
        if (this.version != null && !this.version.isEmpty()) {
            arguments.add("-V");
            arguments.add(this.version);
        }
        if (this.server != null && !this.server.isEmpty()) {
            arguments.add("-s");
            arguments.add(this.server);
        }
        if (this.gcloud_project != null) {
            arguments.add("-A");
            arguments.add(this.gcloud_project);
        }
        if (this.enable_jar_splitting) {
            arguments.add("--enable_jar_splitting");
        }
        if (this.jar_splitting_excludes != null && !this.jar_splitting_excludes.isEmpty()) {
            arguments.add("--jar_splitting_excludes=" + this.jar_splitting_excludes);
        }
        if (this.retain_upload_dir) {
            arguments.add("--retain_upload_dir");
        }
        if (this.compile_encoding != null) {
            arguments.add("--compile-encoding=" + this.compile_encoding);
        }
        if (this.force) {
            arguments.add("-f");
        }
        if (this.delete_jsps) {
            arguments.add("--delete_jsps");
        }
        if (this.enable_jar_classes) {
            arguments.add("--enable_jar_classes");
        }
        if (this.runtime != null) {
            arguments.add("--runtime=" + this.runtime);
        }
        boolean isVm = appengineWeb.getUseVm();
        boolean isStandard = ("1".equals(appengineWeb.getEnv()) || "std".equals(appengineWeb.getEnv())) && !isVm;
        boolean bl = isFlex = "2".equals(appengineWeb.getEnv()) || "flex".equals(appengineWeb.getEnv()) || "flexible".equals(appengineWeb.getEnv());
        if (isStandard && this.getJavaVersion().equals("1.8")) {
            throw new MojoExecutionException("For now, Standard GAE runtime only works with Java7, but the pom.xml is targetting 1.8");
        }
        if (isFlex) {
            arguments.add("-R");
            arguments.add("-r");
            arguments.add("java");
        } else if (isVm && this.getJavaVersion().equals("1.8")) {
            arguments.add("-R");
            arguments.add("-r");
            arguments.add("java");
        }
        arguments.add("stage");
        arguments.add(appDir);
        arguments.add(destinationDir.getAbsolutePath());
        this.getLog().info((CharSequence)("Running appcfg " + Joiner.on((String)" ").join(arguments)));
        AppCfg.main((String[])arguments.toArray(new String[arguments.size()]));
        try {
            File fileAppYaml = new File(destinationDir, "/app.yaml");
            String string = Files.toString((File)fileAppYaml, (Charset)Charsets.UTF_8);
            if (isVm && this.getJavaVersion().equals("1.8")) {
                String string2 = string.replace("runtime: java", "runtime: custom");
                Files.write((CharSequence)string2, (File)fileAppYaml, (Charset)Charsets.UTF_8);
                File dockerFile = new File(destinationDir, "/Dockerfile");
                if (!dockerFile.exists()) {
                    Files.write((CharSequence)"FROM gcr.io/google_appengine/jetty9-compat\nADD . /app\n", (File)dockerFile, (Charset)Charsets.UTF_8);
                }
            }
        }
        catch (IOException ioe) {
            System.out.println("Error " + ioe);
        }
        for (File f : yamlFiles = new File(destinationDir, "/WEB-INF/appengine-generated").listFiles()) {
            try {
                Files.copy((File)f, (File)new File(appDir, f.getName()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error: copying yaml file " + ex);
            }
        }
        File file = new File(destinationDir, "/WEB-INF/quickstart-web.xml");
        if (file.exists()) {
            try {
                Files.copy((File)file, (File)new File(appDir, "/WEB-INF/quickstart-web.xml"));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error: copying WEB-INF/quickstart-web.xml" + ex);
            }
        }
        if ((index = new File(appDir, "/WEB-INF/datastore-indexes.xml")).exists()) {
            index.delete();
        }
        return destinationDir;
    }

    private void installJavaAppEngineComponent(String pythonLocation) throws MojoExecutionException {
        ArrayList<String> installCommand = new ArrayList<String>();
        installCommand.add(pythonLocation);
        if (Utils.canDisableImportOfPythonModuleSite()) {
            installCommand.add("-S");
        }
        installCommand.add(this.gcloud_directory + "/lib/gcloud.py");
        installCommand.add("components");
        installCommand.add("update");
        installCommand.add("app-engine-java");
        installCommand.add("--quiet");
        ProcessBuilder pb = new ProcessBuilder(installCommand);
        this.getLog().info((CharSequence)"Installing the Cloud SDK app-engine-java component");
        this.getLog().info((CharSequence)"Please, be patient, it takes a while on slow network...");
        try {
            Process process = pb.start();
            final Scanner stdOut = new Scanner(process.getInputStream());
            new Thread("standard-out-redirection"){

                @Override
                public void run() {
                    while (stdOut.hasNextLine() && !Thread.interrupted()) {
                        AbstractGcloudMojo.this.getLog().info((CharSequence)stdOut.nextLine());
                    }
                }
            };
            process.waitFor();
            this.getLog().info((CharSequence)"Cloud SDK app-engine-java component installed.");
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("Error: cannot execute gcloud command " + ex);
        }
    }

    protected static enum WaitDirective {
        WAIT_SERVER_STARTED,
        WAIT_SERVER_STOPPED;

    }
}

