/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.gcloudapp;

import com.google.appengine.gcloudapp.AbstractGcloudMojo;
import com.google.appengine.gcloudapp.GCloudAppStage;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class GCloudAppDeploy
extends GCloudAppStage {
    private boolean promote = true;
    protected String bucket;

    public GCloudAppDeploy() {
        this.deployCommand = true;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        File appToDeploy = this.executeStaging();
        ArrayList<String> devAppServerCommand = this.getCommand(appToDeploy.getAbsolutePath());
        this.startCommand(appToDeploy, devAppServerCommand, AbstractGcloudMojo.WaitDirective.WAIT_SERVER_STOPPED);
    }

    private void addOtherConfigFiles(ArrayList<String> command, String appDir) {
        if (new File(appDir + "/cron.yaml").exists()) {
            command.add(appDir + "/cron.yaml");
        }
        if (new File(appDir + "/queue.yaml").exists()) {
            command.add(appDir + "/queue.yaml");
        }
        if (new File(appDir + "/dispatch.yaml").exists()) {
            command.add(appDir + "/dispatch.yaml");
        }
        if (new File(appDir + "/index.yaml").exists()) {
            command.add(appDir + "/index.yaml");
        }
        if (new File(appDir + "/dos.yaml").exists()) {
            command.add(appDir + "/dos.yaml");
        }
    }

    @Override
    protected ArrayList<String> getCommand(String appDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Running gcloud app deploy...");
        ArrayList<String> deployCommand = new ArrayList<String>();
        this.setupInitialCommands(deployCommand);
        deployCommand.add("deploy");
        File f = new File(appDir, "WEB-INF/appengine-web.xml");
        if (!f.exists()) {
            File appyaml = new File(appDir, "app.yaml");
            if (appyaml.exists()) {
                deployCommand.add(appDir + "/app.yaml");
                this.addOtherConfigFiles(deployCommand, appDir);
            } else {
                File ear = new File(appDir);
                for (File w : ear.listFiles()) {
                    if (!new File(w, "WEB-INF/appengine-web.xml").exists()) continue;
                    deployCommand.add(w.getAbsolutePath() + "/app.yaml");
                    this.addOtherConfigFiles(deployCommand, w.getAbsolutePath());
                }
            }
        } else {
            deployCommand.add(appDir + "/app.yaml");
            this.addOtherConfigFiles(deployCommand, appDir);
        }
        if (this.version != null) {
            deployCommand.add("--version=" + this.version);
        }
        if (this.server != null) {
            deployCommand.add("--server=" + this.server);
        }
        if (this.force) {
            deployCommand.add("--force");
        }
        if (this.docker_build != null) {
            deployCommand.add("--docker-build=" + this.docker_build);
        } else if (this.remote) {
            deployCommand.add("--remote");
        }
        if (this.bucket != null) {
            deployCommand.add("--bucket=" + this.bucket);
        }
        if (this.promote) {
            deployCommand.add("--promote");
        } else {
            deployCommand.add("--no-promote");
        }
        String projectIdUsed = this.gcloud_project;
        if (projectIdUsed == null) {
            projectIdUsed = "the Cloud SDK default project";
        }
        String versionUsed = this.version;
        if (this.version == null) {
            versionUsed = "the time of deployment";
        }
        this.getLog().info((CharSequence)("Note that the project ID and version specified in application configuration files (e.g. app.yaml or appengine-web.xml) are ignored. The project ID is set to " + projectIdUsed + " and the version is set to " + versionUsed + "."));
        return deployCommand;
    }
}

