/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.gcloudapp;

import com.google.appengine.gcloudapp.AbstractGcloudMojo;
import com.google.appengine.gcloudapp.GCloudAppModules;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class GCloudAppInstances
extends AbstractGcloudMojo {
    private String version;
    private String instance = "1";

    protected abstract String[] getSubCommand();

    public GCloudAppInstances() {
        this.deployCommand = true;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"");
        ArrayList<String> devAppServerCommand = this.createCommand(this.getApplicationDirectory(), this.getSubCommand());
        this.startCommand(new File(this.getApplicationDirectory()), devAppServerCommand, AbstractGcloudMojo.WaitDirective.WAIT_SERVER_STOPPED);
    }

    protected ArrayList<String> createCommand(String appDir, String[] subCommand) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Running gcloud app instances...");
        ArrayList<String> devAppServerCommand = new ArrayList<String>();
        this.setupInitialCommands(devAppServerCommand);
        devAppServerCommand.add("instances");
        File appwebxml = new File(appDir, "WEB-INF/appengine-web.xml");
        File appyaml = new File(this.appengine_config_directory, "app.yaml");
        String service = null;
        String localVersion = null;
        if (appwebxml.exists()) {
            AppEngineWebXml xmlContent = this.getAppEngineWebXml(appDir);
            service = xmlContent.getModule();
            if (service == null) {
                service = xmlContent.getService();
            }
            localVersion = xmlContent.getMajorVersionId();
        } else if (appyaml.exists()) {
            try {
                YamlReader reader = new YamlReader((Reader)new FileReader(appyaml));
                Object object = reader.read();
                reader.close();
                Map map = (Map)object;
                service = (String)map.get("module");
                if (service == null) {
                    service = (String)map.get("service");
                }
            }
            catch (YamlException | FileNotFoundException ex) {
                Logger.getLogger(GCloudAppModules.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(GCloudAppModules.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.println("Cannot find app.yaml or appengine-web.xml");
            return null;
        }
        for (String c : subCommand) {
            devAppServerCommand.add(c);
        }
        if (service == null) {
            service = "default";
        }
        devAppServerCommand.add("--service");
        devAppServerCommand.add(service);
        if (this.version != null) {
            devAppServerCommand.add("--version");
            devAppServerCommand.add(this.version);
        } else if (localVersion != null) {
            devAppServerCommand.add("--version");
            devAppServerCommand.add(localVersion);
        } else {
            this.getLog().error((CharSequence)"Warning: the Gcloud <version> Maven configuration is not defined, or <version> is not defined in appengine-web.xml");
        }
        if (this.instance != null) {
            devAppServerCommand.add(this.instance);
        } else {
            this.getLog().error((CharSequence)"You need to specify an instance via <instance> configuration.");
        }
        return devAppServerCommand;
    }

    @Override
    protected ArrayList<String> getCommand(String appDir) throws MojoExecutionException {
        return null;
    }

    public static class DisableDebug
    extends GCloudAppInstances {
        @Override
        protected String[] getSubCommand() {
            return new String[]{"disable-debug"};
        }
    }

    public static class EnableDebug
    extends GCloudAppInstances {
        @Override
        protected String[] getSubCommand() {
            return new String[]{"enable-debug"};
        }
    }
}

