/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.gcloudapp;

import com.google.appengine.gcloudapp.AbstractGcloudMojo;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class GCloudAppModules
extends AbstractGcloudMojo {
    private String server;
    private String version;

    protected abstract String[] getSubCommand();

    public GCloudAppModules() {
        this.deployCommand = true;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"");
        ArrayList<String> devAppServerCommand = this.createCommand(this.getApplicationDirectory(), this.getSubCommand());
        throw new MojoExecutionException("Modules commands are removed. Please use enable_debug/disable_debug or service_start/service_stop goals.");
    }

    protected ArrayList<String> createCommand(String appDir, String[] subCommand) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Running gcloud app modules...");
        ArrayList<String> devAppServerCommand = new ArrayList<String>();
        this.setupInitialCommands(devAppServerCommand);
        devAppServerCommand.add("modules");
        File appwebxml = new File(appDir, "WEB-INF/appengine-web.xml");
        File appyaml = new File(this.appengine_config_directory, "app.yaml");
        String module = null;
        String localVersion = null;
        if (appwebxml.exists()) {
            AppEngineWebXml xmlContent = this.getAppEngineWebXml(appDir);
            module = xmlContent.getModule();
            localVersion = xmlContent.getMajorVersionId();
        } else if (appyaml.exists()) {
            try {
                YamlReader reader = new YamlReader((Reader)new FileReader(appyaml));
                Object object = reader.read();
                reader.close();
                Map map = (Map)object;
                module = (String)map.get("module");
                if (module == null) {
                    module = (String)map.get("service");
                }
            }
            catch (YamlException | FileNotFoundException ex) {
                Logger.getLogger(GCloudAppModules.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(GCloudAppModules.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            File ear = new File(appDir);
            for (File w : ear.listFiles()) {
                if (!new File(w, "WEB-INF/appengine-web.xml").exists()) continue;
                System.out.println("Need to handle EAR for module " + w.getAbsolutePath());
            }
            return null;
        }
        for (String c : subCommand) {
            devAppServerCommand.add(c);
        }
        if (module == null) {
            module = "default";
        }
        devAppServerCommand.add(module);
        if (this.version != null) {
            devAppServerCommand.add("--version=" + this.version);
        } else if (localVersion != null) {
            devAppServerCommand.add("--version=" + localVersion);
        } else {
            this.getLog().error((CharSequence)"Warning: the Gcloud <version> Maven configuration is not defined, or <version> is not defined in appengine-web.xml");
        }
        if (this.server != null) {
            devAppServerCommand.add("--server=" + this.server);
        }
        return devAppServerCommand;
    }

    @Override
    protected ArrayList<String> getCommand(String appDir) throws MojoExecutionException {
        return null;
    }

    public static class Stop
    extends GCloudAppModules {
        @Override
        protected String[] getSubCommand() {
            return new String[]{"stop"};
        }
    }

    public static class Start
    extends GCloudAppModules {
        @Override
        protected String[] getSubCommand() {
            return new String[]{"start"};
        }
    }

    public static class SetManaged
    extends GCloudAppModules {
        private String set_managed_by;

        @Override
        protected String[] getSubCommand() {
            return new String[]{"set-managed-by", "--" + this.set_managed_by};
        }
    }

    public static class Promote
    extends GCloudAppModules {
        @Override
        protected String[] getSubCommand() {
            return new String[]{"promote"};
        }
    }

    public static class Delete
    extends GCloudAppModules {
        @Override
        protected String[] getSubCommand() {
            return new String[]{"delete"};
        }
    }
}

