/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.gcloudapp;

import com.google.appengine.gcloudapp.AbstractGcloudMojo;
import com.google.appengine.repackaged.com.google.api.client.util.Throwables;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class GCloudAppRun
extends AbstractGcloudMojo {
    private String api_host;
    private List<String> modules;
    private String host;
    private String admin_host;
    private String storage_path;
    private String log_level;
    private String logs_path;
    private String auth_domain;
    private String max_module_instances;
    private String appidentity_email_address;
    private String appidentity_private_key_path;
    private String blobstore_path;
    private String datastore_path;
    private boolean clear_datastore;
    private boolean allow_skipped_files;
    private boolean enable_mvm_logs;
    private boolean enable_sendmail;
    private boolean use_mtime_file_watcher;
    private List<String> jvm_flag;
    private String default_gcs_bucket_name;
    private boolean enable_cloud_datastore;
    private String datastore_consistency_policy;
    private String php_executable_path;
    private String python_startup_script;
    private boolean require_indexes;
    private boolean show_mail_body;
    private boolean smtp_allow_tls;
    private String smtp_host;
    private String smtp_password;
    private String smtp_user;
    private String custom_entrypoint;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File appDirFile;
        this.getLog().info((CharSequence)"");
        if (this.application_directory == null) {
            this.application_directory = this.maven_project.getBuild().getDirectory() + "/" + this.maven_project.getBuild().getFinalName();
        }
        if (!(appDirFile = new File(this.application_directory)).exists()) {
            File f = new File(this.maven_project.getBasedir(), this.application_directory);
            if (f.exists()) {
                this.application_directory = f.getAbsolutePath();
            } else {
                throw new MojoExecutionException("The application directory does not exist : " + this.application_directory);
            }
        }
        if (!appDirFile.isDirectory()) {
            throw new MojoExecutionException("The application directory is not a directory : " + this.application_directory);
        }
        this.stopDevAppServer();
        try {
            ArrayList<String> devAppServerCommand = this.getCommand(this.application_directory);
            this.startCommand(appDirFile, devAppServerCommand, AbstractGcloudMojo.WaitDirective.WAIT_SERVER_STOPPED);
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
            throw new MojoExecutionException("Execution error: " + ex);
        }
    }

    @Override
    protected ArrayList<String> getCommand(String appDir) throws MojoExecutionException {
        boolean isAppYamlGenerated;
        this.getLog().info((CharSequence)"Running gcloud app run...");
        ArrayList<String> devAppServerCommand = new ArrayList<String>();
        this.setupInitialCommands(devAppServerCommand);
        File appDirectory = new File(appDir);
        File f = new File(appDirectory, "WEB-INF/appengine-web.xml");
        if (!f.exists()) {
            f = new File(appDirectory, "app.yaml");
            isAppYamlGenerated = new File(appDirectory, ".appyamlgenerated").exists();
            if (f.exists() && !isAppYamlGenerated) {
                devAppServerCommand.add(f.getAbsolutePath());
            } else {
                boolean oneMod = false;
                for (File w : appDirectory.listFiles()) {
                    if (!new File(w, "WEB-INF/appengine-web.xml").exists()) continue;
                    this.executeAppCfgStagingCommand(w.getAbsolutePath());
                    devAppServerCommand.add(w.getAbsolutePath());
                    oneMod = true;
                }
                if (!oneMod) {
                    this.executeAppCfgStagingCommand(this.application_directory);
                    devAppServerCommand.add(appDirectory.getAbsolutePath());
                }
            }
        } else {
            f = new File(appDirectory, "app.yaml");
            isAppYamlGenerated = new File(appDirectory, ".appyamlgenerated").exists();
            if (f.exists() && !isAppYamlGenerated) {
                devAppServerCommand.add(f.getAbsolutePath());
            } else {
                this.executeAppCfgStagingCommand(this.application_directory);
                devAppServerCommand.add(appDirectory.getAbsolutePath() + "/app.yaml");
            }
        }
        if (this.modules != null && !this.modules.isEmpty()) {
            for (String modDir : this.modules) {
                this.getLog().info((CharSequence)("Running gcloud app run with extra module in " + modDir));
                devAppServerCommand.add(new File(modDir).getAbsolutePath());
            }
        }
        if (this.host != null) {
            String[] parts = this.host.split(":");
            devAppServerCommand.add("--host");
            devAppServerCommand.add(parts[0]);
            devAppServerCommand.add("--port");
            devAppServerCommand.add(parts[1]);
        }
        if (this.api_host != null) {
            String[] parts = this.api_host.split(":");
            devAppServerCommand.add("--api_host");
            devAppServerCommand.add(parts[0]);
            devAppServerCommand.add("--api_port");
            devAppServerCommand.add(parts[1]);
        }
        if (this.admin_host != null) {
            String[] parts = this.admin_host.split(":");
            devAppServerCommand.add("--admin_host");
            devAppServerCommand.add(parts[0]);
            devAppServerCommand.add("--admin_port");
            devAppServerCommand.add(parts[1]);
        }
        if (this.storage_path != null) {
            devAppServerCommand.add("--storage_path=" + this.storage_path);
        }
        if (this.log_level != null) {
            devAppServerCommand.add("--log_level=" + this.log_level);
        }
        if (this.logs_path != null) {
            devAppServerCommand.add("--logs_path=" + this.logs_path);
        }
        if (this.auth_domain != null) {
            devAppServerCommand.add("--auth_domain=" + this.auth_domain);
        }
        if (this.max_module_instances != null) {
            devAppServerCommand.add("--max_module_instances=" + this.max_module_instances);
        }
        if (this.appidentity_email_address != null) {
            devAppServerCommand.add("--appidentity_email_address=" + this.appidentity_email_address);
        }
        if (this.appidentity_private_key_path != null) {
            devAppServerCommand.add("--appidentity_private_key_path=" + this.appidentity_private_key_path);
        }
        if (this.blobstore_path != null) {
            devAppServerCommand.add("--blobstore_path=" + this.blobstore_path);
        }
        if (this.datastore_path != null) {
            devAppServerCommand.add("--datastore_path=" + this.datastore_path);
        }
        if (this.clear_datastore) {
            devAppServerCommand.add("--clear_datastore");
        }
        if (this.allow_skipped_files) {
            devAppServerCommand.add("--allow_skipped_files");
        }
        if (this.enable_mvm_logs) {
            devAppServerCommand.add("--enable_mvm_logs");
        }
        if (this.enable_sendmail) {
            devAppServerCommand.add("--enable_sendmail");
        }
        if (this.use_mtime_file_watcher) {
            devAppServerCommand.add("--use_mtime_file_watcher");
        }
        if (this.jvm_flag != null && !this.jvm_flag.isEmpty()) {
            for (String opt : this.jvm_flag) {
                devAppServerCommand.add("--jvm_flag=" + opt);
            }
        }
        if (this.default_gcs_bucket_name != null) {
            devAppServerCommand.add("--default_gcs_bucket_name=" + this.default_gcs_bucket_name);
        }
        if (this.enable_cloud_datastore) {
            devAppServerCommand.add("--enable_cloud_datastore");
        }
        if (this.datastore_consistency_policy != null) {
            devAppServerCommand.add("--datastore_consistency_policy=" + this.datastore_consistency_policy);
        }
        if (this.php_executable_path != null) {
            devAppServerCommand.add("--php_executable_path=" + this.php_executable_path);
        }
        if (this.python_startup_script != null) {
            devAppServerCommand.add("--python_startup_script=" + this.python_startup_script);
        }
        if (this.require_indexes) {
            devAppServerCommand.add("--require_indexes");
        }
        if (this.show_mail_body) {
            devAppServerCommand.add("--show_mail_body");
        }
        if (this.smtp_allow_tls) {
            devAppServerCommand.add("--smt_allow_tls");
        }
        if (this.smtp_host != null) {
            String[] parts = this.host.split(":");
            devAppServerCommand.add("--smtp_host");
            devAppServerCommand.add(parts[0]);
            devAppServerCommand.add("--smtp_port");
            devAppServerCommand.add(parts[1]);
        }
        if (this.smtp_password != null) {
            devAppServerCommand.add("--smtp_password=" + this.smtp_password);
        }
        if (this.smtp_user != null) {
            devAppServerCommand.add("--smtp_user=" + this.smtp_user);
        }
        if (this.custom_entrypoint != null) {
            devAppServerCommand.add("--custom_entrypoint=" + this.custom_entrypoint);
        }
        if (this.runtime != null) {
            devAppServerCommand.add("--runtime=" + this.runtime);
        }
        return devAppServerCommand;
    }

    protected void stopDevAppServer() throws MojoExecutionException {
        try {
            String ad = "localhost";
            if (this.host != null) {
                String[] parts = this.host.split(":");
                ad = parts[0];
            }
            URL url = new URL("http", ad, 8000, "/quit");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("GET");
            ByteStreams.toByteArray((InputStream)connection.getInputStream());
            connection.setReadTimeout(4000);
            connection.disconnect();
            this.getLog().info((CharSequence)"Shutting down Cloud SDK Server on port 8000 and waiting 4 seconds...");
            Thread.sleep(4000L);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("URL malformed attempting to stop the devserver : " + e.getMessage());
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"Was not able to contact the devappserver to shut it down.  Most likely this is due to it simply not running anymore.", (Throwable)e);
        }
        catch (InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

