/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.gcloudapp;

import com.google.appengine.gcloudapp.AbstractGcloudMojo;
import com.google.appengine.repackaged.com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class GCloudAppStage
extends AbstractGcloudMojo {
    public GCloudAppStage() {
        this.deployCommand = true;
    }

    protected File createStagingAreaEnv2() throws MojoExecutionException {
        File targetDir;
        File artifactToDeploy;
        String packaging = this.maven_project.getPackaging();
        File stagingDir = new File(this.staging_directory);
        File appengineConfigDir = new File(this.appengine_config_directory);
        stagingDir.mkdir();
        File appyaml = new File(appengineConfigDir, "app.yaml");
        if (appyaml.exists()) {
            try {
                Files.copy((File)appyaml, (File)new File(stagingDir, "app.yaml"));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error: copying app.yaml" + ex);
            }
        }
        try {
            File[] out = new PrintWriter(new File(stagingDir, "app.yaml"));
            out.println("runtime: java");
            out.println("vm: true");
            out.println("api_version: 1");
            out.println("threadsafe: True");
            out.println("handlers:");
            out.println("  - url: .*");
            out.println("    script: dynamic");
            out.close();
        }
        catch (FileNotFoundException ex) {
            throw new MojoExecutionException("Error: creating default app.yaml " + ex);
        }
        if (appengineConfigDir.exists()) {
            for (File file : appengineConfigDir.listFiles()) {
                if (file.getName().equals("app.yaml")) continue;
                try {
                    Files.copy((File)file, (File)new File(stagingDir, file.getName()));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error: copying " + file.getAbsolutePath() + " " + ex);
                }
            }
        }
        if (!(artifactToDeploy = new File(targetDir = new File(this.maven_project.getBuild().getDirectory()), this.maven_project.getBuild().getFinalName() + "-jar-with-dependencies." + packaging)).exists()) {
            artifactToDeploy = new File(targetDir, this.maven_project.getBuild().getFinalName() + "." + packaging);
        }
        if (!artifactToDeploy.exists()) {
            artifactToDeploy = new File(targetDir, this.maven_project.getBuild().getFinalName() + "-fat." + packaging);
        }
        if (artifactToDeploy.exists()) {
            try {
                File stagingArtifact = new File(stagingDir, artifactToDeploy.getName());
                Files.copy((File)artifactToDeploy, (File)stagingArtifact);
                if (!System.getProperty("os.name").contains("Windows")) {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                    perms.add(PosixFilePermission.OWNER_READ);
                    perms.add(PosixFilePermission.OWNER_WRITE);
                    perms.add(PosixFilePermission.GROUP_READ);
                    perms.add(PosixFilePermission.OTHERS_READ);
                    java.nio.file.Files.setPosixFilePermissions(stagingArtifact.toPath(), perms);
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error: copying artifact" + ex);
            }
        }
        return stagingDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File stagingDir = this.executeStaging();
        this.getLog().info((CharSequence)("Stagin directory updated at: " + stagingDir.getAbsolutePath()));
    }

    protected File executeStaging() throws MojoExecutionException {
        String appDir = this.maven_project.getBuild().getDirectory() + "/" + this.maven_project.getBuild().getFinalName();
        File appDirFile = new File(appDir);
        String aewebxml = appDir + "/WEB-INF/appengine-web.xml";
        String packaging = this.maven_project.getPackaging();
        if (packaging.equals("jar") || !new File(aewebxml).exists()) {
            return this.createStagingAreaEnv2();
        }
        if (!appDirFile.exists()) {
            throw new MojoExecutionException("The application directory does not exist : " + appDir);
        }
        if (!appDirFile.isDirectory()) {
            throw new MojoExecutionException("The application directory is not a directory : " + appDir);
        }
        File appYaml = new File(appDirFile, "app.yaml");
        boolean isAppYamlGenerated = new File(appDirFile, ".appyamlgenerated").exists();
        File appToDeploy = appYaml.exists() && !isAppYamlGenerated ? appDirFile : this.executeAppCfgStagingCommand(appDir);
        return appToDeploy;
    }

    protected ArrayList<String> collectAppCfgParameters() throws MojoExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.server != null && !this.server.isEmpty()) {
            arguments.add("-s");
            arguments.add(this.server);
        }
        if (this.gcloud_project != null) {
            arguments.add("-A");
            arguments.add(this.gcloud_project);
        }
        if (this.version != null && !this.version.isEmpty()) {
            arguments.add("-V");
            arguments.add(this.version);
        }
        if (this.enable_jar_splitting) {
            arguments.add("--enable_jar_splitting");
        }
        if (this.jar_splitting_excludes != null && !this.jar_splitting_excludes.isEmpty()) {
            arguments.add("--jar_splitting_excludes=" + this.jar_splitting_excludes);
        }
        if (this.retain_upload_dir) {
            arguments.add("--retain_upload_dir");
        }
        if (this.compile_encoding != null) {
            arguments.add("--compile-encoding=" + this.compile_encoding);
        }
        if (this.force) {
            arguments.add("-f");
        }
        if (this.delete_jsps) {
            arguments.add("--delete_jsps");
        }
        if (this.enable_jar_classes) {
            arguments.add("--enable_jar_classes");
        }
        if (this.runtime != null) {
            arguments.add("--runtime=" + this.runtime);
        }
        return arguments;
    }

    @Override
    protected ArrayList<String> getCommand(String appDir) throws MojoExecutionException {
        return new ArrayList<String>();
    }
}

