/*
 * Decompiled with CFR 0.152.
 */
package mediautil.test;

import java.io.IOException;
import java.io.InputStream;
import mediautil.test.TestCode;

class CrankyStream
extends InputStream {
    byte[] readBuf;
    int off;
    int len;
    int pos;
    int avail;
    private byte[] oneByteArr = new byte[1];

    public CrankyStream(byte[] readBuf, int off, int len) {
        this.readBuf = readBuf;
        this.off = off;
        this.len = len;
        this.pos = off;
        this.avail = len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Negative Length Read attempted, len = " + len);
        }
        byte b1 = b[off];
        byte b2 = b[off + len - 1];
        if (len == 0) {
            return 0;
        }
        int retVal = len;
        if (len > this.avail) {
            retVal = this.avail;
        }
        if (retVal <= 0) {
            retVal = -1;
        } else {
            retVal = TestCode.r.nextInt(retVal) + 1;
            System.arraycopy(this.readBuf, this.pos, b, off, retVal);
            this.pos += retVal;
            this.avail -= retVal;
        }
        return retVal;
    }

    @Override
    public int read() throws IOException {
        int retVal = -1;
        if (this.read(this.oneByteArr) == 1) {
            retVal = this.oneByteArr[0] & 0xFF;
        }
        return retVal;
    }

    @Override
    public long skip(long n) throws IOException {
        long retVal = n;
        if (n > (long)this.avail) {
            retVal = this.avail;
        }
        if (retVal > 0L) {
            retVal = TestCode.r.nextInt((int)retVal + 1);
            this.pos += (int)retVal;
            this.avail -= (int)retVal;
        } else {
            retVal = 0L;
        }
        return retVal;
    }

    @Override
    public int available() throws IOException {
        return this.avail > 0 ? 1 : 0;
    }
}

