/*
 * Decompiled with CFR 0.152.
 */
package mediautil.test;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Random;
import mediautil.gen.directio.IterativeReader;

class TestCode
implements IterativeReader {
    public static byte[] fileArr;
    public static Random r;
    public static int id;
    private InputStream ip;
    private int pos;
    private int n;
    private int skipProb;
    private int maxBuf;
    private int maxReads;
    private PrintStream refOp;
    private PrintStream sipOp;
    private byte[] readBuf;
    public static boolean flush;
    public static boolean debug;
    private boolean prevShort = false;

    public static void printBytes(PrintStream op, byte[] b, int off, int len) {
        while (len > 0) {
            op.println("" + b[off]);
            ++off;
            --len;
        }
    }

    public TestCode(InputStream ip, int n, int skipProb, int maxBuf, int maxReads) throws FileNotFoundException {
        this.ip = ip;
        this.n = n;
        this.skipProb = skipProb;
        this.maxBuf = maxBuf;
        this.maxReads = maxReads;
        this.pos = 0;
        this.readBuf = new byte[maxBuf];
        this.refOp = new PrintStream(new BufferedOutputStream(new FileOutputStream("sub" + n + "_ref.txt"), 100000));
        this.sipOp = new PrintStream(new BufferedOutputStream(new FileOutputStream("sub" + n + "_sip.txt"), 100000));
    }

    @Override
    public int nextRead(int numBytes) {
        int readCount = r.nextInt(this.maxReads) + 1;
        int len = 0;
        boolean isSkip = false;
        int retVal = 0;
        try {
            int actualRead;
            do {
                len = r.nextInt(this.maxBuf) + 1;
                isSkip = r.nextInt(16) < this.skipProb;
                String opMsg = isSkip ? "Skipped " : "Read ";
                this.refOp.println("Trying Id: " + id + ' ' + opMsg + this.pos + " - " + (this.pos + len));
                this.sipOp.println("Trying Id: " + id + ' ' + opMsg + this.pos + " - " + (this.pos + len));
                if (flush) {
                    this.refOp.flush();
                    this.sipOp.flush();
                }
                if (isSkip) {
                    actualRead = (int)this.ip.skip(len);
                } else {
                    int ofs = r.nextInt(this.maxBuf - len + 1);
                    actualRead = this.ip.read(this.readBuf, ofs, len);
                    TestCode.printBytes(this.refOp, fileArr, this.pos, actualRead);
                    TestCode.printBytes(this.sipOp, this.readBuf, ofs, actualRead);
                }
                if (actualRead > 0) {
                    if (actualRead < len) {
                        this.prevShort = true;
                    }
                    this.refOp.println("Id: " + id + " readCount: " + readCount + ' ' + opMsg + this.pos + " - " + (this.pos + actualRead));
                    this.sipOp.println("Id: " + id + " readCount: " + readCount + ' ' + opMsg + this.pos + " - " + (this.pos + actualRead));
                } else {
                    this.refOp.println("Id: " + id + " readCount: " + readCount + ' ' + " End Of Stream actualRead = " + actualRead);
                    this.sipOp.println("Id: " + id + " readCount: " + readCount + ' ' + " End Of Stream actualRead = " + actualRead);
                }
                if (flush) {
                    this.refOp.flush();
                    this.sipOp.flush();
                }
                if (actualRead <= 0) continue;
                this.pos += actualRead;
            } while (actualRead >= 0 && --readCount > 0);
            if (actualRead < 0) {
                retVal = 1;
                this.refOp.close();
                this.sipOp.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.sipOp.println("Exception for Id: " + id + " isSkip = " + isSkip + " readCount: " + readCount + ' ' + " Len = " + len);
            e.printStackTrace(this.sipOp);
            this.sipOp.flush();
            throw new RuntimeException("What the Heaven");
        }
        return retVal;
    }

    public void closeFiles() {
        this.refOp.close();
        this.sipOp.close();
        this.refOp = null;
        this.sipOp = null;
    }

    static {
        flush = false;
        debug = false;
    }
}

