/*
 * Decompiled with CFR 0.152.
 */
package mediautil.test;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Random;
import mediautil.gen.directio.IterativeWriter;

class TestWriterCode
implements IterativeWriter {
    public static byte[] fileArr;
    public static Random r;
    public static int id;
    private OutputStream op;
    private int pos;
    private int maxBuf;
    private int maxWrites;
    private PrintStream refOp;
    private byte[] writeBuf;
    public static boolean flush;
    public static boolean debug;
    private boolean prevShort = false;

    public static void printBytes(PrintStream op, byte[] b, int off, int len) {
        while (len > 0) {
            op.println("" + b[off]);
            ++off;
            --len;
        }
    }

    public TestWriterCode(OutputStream op, int maxBuf, int maxWrites) throws FileNotFoundException {
        this.op = op;
        this.maxBuf = maxBuf;
        this.maxWrites = maxWrites;
        this.pos = 0;
        this.refOp = new PrintStream(new BufferedOutputStream(new FileOutputStream("D:/work/deldir/sub_ref.txt"), 100000));
    }

    @Override
    public int nextWrite(int numBytes) {
        int writeCount = r.nextInt(this.maxWrites) + 1;
        int len = 0;
        int retVal = 0;
        try {
            int maxLen;
            do {
                int actualRead = len = r.nextInt(this.maxBuf) + 1;
                maxLen = fileArr.length - this.pos;
                if (len > maxLen) {
                    actualRead = maxLen;
                }
                String opMsg = "Read ";
                this.refOp.println("Trying Id: " + id + ' ' + opMsg + this.pos + " - " + (this.pos + len));
                if (flush) {
                    this.refOp.flush();
                }
                this.op.write(fileArr, this.pos, actualRead);
                TestWriterCode.printBytes(this.refOp, fileArr, this.pos, actualRead);
                if (maxLen <= len) {
                    this.op.close();
                }
                this.refOp.println("Id: " + id + " writeCount: " + writeCount + ' ' + opMsg + this.pos + " - " + (this.pos + actualRead));
                if (flush) {
                    this.refOp.flush();
                }
                if (actualRead <= 0) continue;
                this.pos += actualRead;
            } while (maxLen > len && --writeCount > 0);
            if (maxLen <= len) {
                retVal = 1;
                this.refOp.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.refOp.println("Exception for Id: " + id + " writeCount: " + writeCount + ' ' + " Len = " + len);
            e.printStackTrace(this.refOp);
            this.refOp.flush();
            throw new RuntimeException("What the Heaven");
        }
        return retVal;
    }

    public void closeFiles() {
        this.refOp.close();
        this.refOp = null;
    }

    static {
        flush = false;
        debug = false;
    }
}

