/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags;

import com.google.common.base.Ascii;
import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FlagConverters {
    private static final Converter<String, Boolean> BOOLEAN_CONVERTER = new Converter<String, Boolean>(){

        protected Boolean doForward(String input) {
            switch (Ascii.toLowerCase((String)input)) {
                case "1": 
                case "t": 
                case "y": 
                case "yes": 
                case "true": {
                    return true;
                }
                case "0": 
                case "f": 
                case "n": 
                case "no": 
                case "false": {
                    return false;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(input).length()).append("'").append(input).append("' is an invalid input").toString());
        }

        protected String doBackward(Boolean input) {
            return input.toString();
        }
    };
    private static final Converter<String, Integer> INTEGER_CONVERTER = new Converter<String, Integer>(){

        protected Integer doForward(String input) {
            return Integer.decode(input);
        }

        protected String doBackward(Integer input) {
            return input.toString();
        }
    };
    private static final Converter<String, Long> LONG_CONVERTER = new Converter<String, Long>(){

        protected Long doForward(String input) {
            return Long.decode(input);
        }

        protected String doBackward(Long input) {
            return input.toString();
        }
    };
    private static final Converter<String, Float> FLOAT_CONVERTER = new Converter<String, Float>(){

        protected Float doForward(String input) {
            return Float.valueOf(input);
        }

        protected String doBackward(Float input) {
            return input.toString();
        }
    };
    private static final Converter<String, Double> DOUBLE_CONVERTER = new Converter<String, Double>(){

        protected Double doForward(String input) {
            return Double.valueOf(input);
        }

        protected String doBackward(Double input) {
            return input.toString();
        }
    };

    public static Converter<String, Boolean> toBoolean() {
        return BOOLEAN_CONVERTER;
    }

    public static Converter<String, Integer> toInteger() {
        return INTEGER_CONVERTER;
    }

    public static Converter<String, Long> toLong() {
        return LONG_CONVERTER;
    }

    public static Converter<String, Float> toFloat() {
        return FLOAT_CONVERTER;
    }

    public static Converter<String, Double> toDouble() {
        return DOUBLE_CONVERTER;
    }

    public static <T> Converter<String, List<T>> toList(Converter<String, T> elemConverter, String separator) {
        return FlagConverters.toIterable(elemConverter, separator).andThen(new Converter<Iterable<T>, List<T>>(){

            protected ImmutableList<T> doForward(Iterable<T> input) {
                return ImmutableList.copyOf(input);
            }

            protected Iterable<T> doBackward(List<T> input) {
                return input;
            }
        });
    }

    public static <T> Converter<String, List<T>> toList(Converter<String, T> elemConverter) {
        return FlagConverters.toList(elemConverter, ",");
    }

    public static <T> Converter<String, Set<T>> toSet(Converter<String, T> elemConverter, String separator) {
        return FlagConverters.toIterable(elemConverter, separator).andThen(new Converter<Iterable<T>, Set<T>>(){

            protected ImmutableSet<T> doForward(Iterable<T> input) {
                return ImmutableSet.copyOf(input);
            }

            protected Iterable<T> doBackward(Set<T> input) {
                return input;
            }
        });
    }

    public static <T> Converter<String, Set<T>> toSet(Converter<String, T> elemConverter) {
        return FlagConverters.toSet(elemConverter, ",");
    }

    public static <K, V> Converter<String, Map<K, V>> toMap(Converter<String, K> keyConverter, Converter<String, V> valueConverter, String entrySeparator, String keyValueSeparator) {
        return FlagConverters.toMapEntryCollection(keyConverter, valueConverter, entrySeparator, keyValueSeparator).andThen(new Converter<Iterable<Map.Entry<K, V>>, Map<K, V>>(){

            protected ImmutableMap<K, V> doForward(Iterable<Map.Entry<K, V>> entries) {
                return ImmutableMap.copyOf(entries);
            }

            protected Iterable<Map.Entry<K, V>> doBackward(Map<K, V> map) {
                return map.entrySet();
            }
        });
    }

    public static <K, V> Converter<String, Map<K, V>> toMap(Converter<String, K> keyConverter, Converter<String, V> valueConverter) {
        return FlagConverters.toMap(keyConverter, valueConverter, ",", "=");
    }

    public static <K, V> Converter<String, Multimap<K, V>> toMultimap(Converter<String, K> keyConverter, Converter<String, V> valueConverter, String entrySeparator, String keyValueSeparator) {
        return FlagConverters.toMapEntryCollection(keyConverter, valueConverter, entrySeparator, keyValueSeparator).andThen(new Converter<Iterable<Map.Entry<K, V>>, Multimap<K, V>>(){

            protected ImmutableMultimap<K, V> doForward(Iterable<Map.Entry<K, V>> entries) {
                return ImmutableMultimap.copyOf(entries);
            }

            protected Iterable<Map.Entry<K, V>> doBackward(Multimap<K, V> map) {
                return map.entries();
            }
        });
    }

    public static <K, V> Converter<String, Multimap<K, V>> toMultimap(Converter<String, K> keyConverter, Converter<String, V> valueConverter) {
        return FlagConverters.toMultimap(keyConverter, valueConverter, ",", "=");
    }

    private static <T> Converter<String, Iterable<T>> toIterable(final Converter<String, T> elemConverter, final String separator) {
        Preconditions.checkNotNull(elemConverter);
        Preconditions.checkNotNull((Object)separator);
        final Splitter splitter = FlagConverters.makeSplitter(separator);
        return new Converter<String, Iterable<T>>(){

            protected Iterable<T> doForward(String text) {
                return Iterables.transform((Iterable)splitter.split((CharSequence)text), (Function)elemConverter);
            }

            protected String doBackward(Iterable<T> values) {
                return FluentIterable.from(values).transform((Function)elemConverter.reverse()).join(Joiner.on((String)separator));
            }
        };
    }

    private static <K, V> Converter<String, Iterable<Map.Entry<K, V>>> toMapEntryCollection(final Converter<String, K> keyConverter, final Converter<String, V> valueConverter, final String entrySeparator, final String keyValueSeparator) {
        Preconditions.checkNotNull(keyConverter);
        Preconditions.checkNotNull(valueConverter);
        Preconditions.checkNotNull((Object)entrySeparator);
        Preconditions.checkNotNull((Object)keyValueSeparator);
        final Splitter entrySplitter = FlagConverters.makeSplitter(entrySeparator);
        final Splitter keyValueSplitter = FlagConverters.makeKeyValueSplitter(keyValueSeparator);
        return new Converter<String, Iterable<Map.Entry<K, V>>>(){

            protected Iterable<Map.Entry<K, V>> doForward(String text) {
                ImmutableList.Builder result = ImmutableList.builder();
                for (String entry : entrySplitter.split((CharSequence)text)) {
                    List keyValue = keyValueSplitter.splitToList((CharSequence)entry);
                    Preconditions.checkArgument((keyValue.size() == 2 ? 1 : 0) != 0);
                    Object key = keyConverter.convert((Object)((String)keyValue.get(0)));
                    Object value = valueConverter.convert((Object)((String)keyValue.get(1)));
                    result.add((Object)Maps.immutableEntry((Object)key, (Object)value));
                }
                return result.build();
            }

            protected String doBackward(Iterable<Map.Entry<K, V>> mapEntries) {
                return FluentIterable.from(mapEntries).transform(entry -> {
                    String string = (String)keyConverter.reverse().convert(entry.getKey());
                    String string2 = (String)valueConverter.reverse().convert(entry.getValue());
                    return new StringBuilder(String.valueOf(string).length() + String.valueOf(keyValueSeparator).length() + String.valueOf(string2).length()).append(string).append(keyValueSeparator).append(string2).toString();
                }).join(Joiner.on((String)entrySeparator));
            }
        };
    }

    private static Splitter makeSplitter(String separator) {
        return Splitter.on((String)separator).trimResults().omitEmptyStrings();
    }

    private static Splitter makeKeyValueSplitter(String separator) {
        return Splitter.on((String)separator).trimResults().limit(2);
    }

    private FlagConverters() {
    }
}

