/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags;

import com.google.common.flags.Flag;
import com.google.common.flags.FlagDescription;
import com.google.common.flags.FlagException;
import org.jspecify.nullness.Nullable;

public class InvalidFlagValueException
extends FlagException {
    private static final long serialVersionUID = 2398478978L;
    @Nullable String flagName;
    @Nullable String flagValue;

    public InvalidFlagValueException(@Nullable String text) {
        super(text);
    }

    public InvalidFlagValueException(@Nullable String text, @Nullable Throwable cause) {
        super(text, cause);
    }

    public InvalidFlagValueException(@Nullable String text, String flagName, Flag<?> flag) {
        super(text);
        FlagDescription.checkNotNull(flagName, flag);
        this.flagName = flagName;
        this.flagValue = flag.parsableStringValue();
    }

    @Override
    public @Nullable String getMessage() {
        String text = super.getMessage();
        if (this.flagName != null) {
            String string = this.flagName;
            String string2 = this.flagValue;
            return new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(text).length()).append("Invalid value for flag ").append(string).append(": ").append(string2).append(" (").append(text).append(")").toString();
        }
        return text;
    }
}

