/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.base;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class GenericStreamField<T>
extends ObjectStreamField {
    private FieldStrategy<T> fieldStrategy;
    private static final FieldStrategy OBJECT_FIELD_STRATEGY = new FieldStrategy<Object>(){

        @Override
        public Object get(String name, ObjectInputStream.GetField getField) throws IOException {
            return getField.get(name, null);
        }

        @Override
        public void put(String name, ObjectOutputStream.PutField putField, Object t) {
            putField.put(name, t);
        }
    };
    private static final ImmutableMap<Class<?>, FieldStrategy<?>> PRIMITIVE_FIELD_STRATEGIES = new ImmutableMap.Builder().put(Boolean.TYPE, (Object)new FieldStrategy<Boolean>(){

        @Override
        public Boolean get(String name, ObjectInputStream.GetField getField) throws IOException {
            return getField.get(name, false);
        }

        @Override
        public void put(String name, ObjectOutputStream.PutField putField, Boolean t) {
            putField.put(name, t);
        }
    }).put(Byte.TYPE, (Object)new FieldStrategy<Byte>(){

        @Override
        public Byte get(String name, ObjectInputStream.GetField getField) throws IOException {
            return getField.get(name, (byte)0);
        }

        @Override
        public void put(String name, ObjectOutputStream.PutField putField, Byte t) {
            putField.put(name, t);
        }
    }).put(Character.TYPE, (Object)new FieldStrategy<Character>(){

        @Override
        public Character get(String name, ObjectInputStream.GetField getField) throws IOException {
            return Character.valueOf(getField.get(name, '\u0000'));
        }

        @Override
        public void put(String name, ObjectOutputStream.PutField putField, Character t) {
            putField.put(name, t.charValue());
        }
    }).put(Double.TYPE, (Object)new FieldStrategy<Double>(){

        @Override
        public Double get(String name, ObjectInputStream.GetField getField) throws IOException {
            return getField.get(name, 0.0);
        }

        @Override
        public void put(String name, ObjectOutputStream.PutField putField, Double t) {
            putField.put(name, t);
        }
    }).put(Float.TYPE, (Object)new FieldStrategy<Float>(){

        @Override
        public Float get(String name, ObjectInputStream.GetField getField) throws IOException {
            return Float.valueOf(getField.get(name, 0.0f));
        }

        @Override
        public void put(String name, ObjectOutputStream.PutField putField, Float t) {
            putField.put(name, t.floatValue());
        }
    }).put(Integer.TYPE, (Object)new FieldStrategy<Integer>(){

        @Override
        public Integer get(String name, ObjectInputStream.GetField getField) throws IOException {
            return getField.get(name, 0);
        }

        @Override
        public void put(String name, ObjectOutputStream.PutField putField, Integer t) {
            putField.put(name, t);
        }
    }).put(Long.TYPE, (Object)new FieldStrategy<Long>(){

        @Override
        public Long get(String name, ObjectInputStream.GetField getField) throws IOException {
            return getField.get(name, 0L);
        }

        @Override
        public void put(String name, ObjectOutputStream.PutField putField, Long t) {
            putField.put(name, t);
        }
    }).put(Short.TYPE, (Object)new FieldStrategy<Short>(){

        @Override
        public Short get(String name, ObjectInputStream.GetField getField) throws IOException {
            return getField.get(name, (short)0);
        }

        @Override
        public void put(String name, ObjectOutputStream.PutField putField, Short t) {
            putField.put(name, t);
        }
    }).build();

    private GenericStreamField(String name, Class<?> type, FieldStrategy<T> fieldStrategy) {
        super(name, type);
        this.fieldStrategy = fieldStrategy;
    }

    public boolean isPresent(ObjectInputStream.GetField getField) throws IOException {
        return !getField.defaulted(this.getName());
    }

    public T get(ObjectInputStream.GetField getField) throws IOException {
        return this.fieldStrategy.get(this.getName(), getField);
    }

    public void put(ObjectOutputStream out, T t) throws IOException {
        this.put(out.putFields(), t);
    }

    public void put(ObjectOutputStream.PutField putField, T t) {
        this.fieldStrategy.put(this.getName(), putField, t);
    }

    public static <R, T extends R> GenericStreamField<T> newInstance(String name, Class<R> rawType) {
        if (rawType == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        FieldStrategy fieldStrategy = rawType.isPrimitive() ? (FieldStrategy)PRIMITIVE_FIELD_STRATEGIES.get(rawType) : OBJECT_FIELD_STRATEGY;
        return new GenericStreamField<T>(name, rawType, fieldStrategy);
    }

    private static interface FieldStrategy<T> {
        public T get(String var1, ObjectInputStream.GetField var2) throws IOException;

        public void put(String var1, ObjectOutputStream.PutField var2, T var3);
    }
}

