/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.base.shell;

import com.google.common.base.Preconditions;
import com.google.io.base.shell.LogUtil;
import com.google.io.base.shell.TerminationStatus;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CommandResult {
    private static final Logger log = Logger.getLogger("com.google.io.base.shell.Command");
    private static final byte[] NO_BYTES = new byte[0];
    static final ByteArrayOutputStream EMPTY_OUTPUT = new ByteArrayOutputStream(){

        @Override
        public byte[] toByteArray() {
            return NO_BYTES;
        }
    };
    static final ByteArrayOutputStream NO_OUTPUT_COLLECTED = new ByteArrayOutputStream(){

        @Override
        public byte[] toByteArray() {
            throw new IllegalStateException("Output was not collected");
        }
    };
    private final ByteArrayOutputStream stdout;
    private final ByteArrayOutputStream stderr;
    private final TerminationStatus terminationStatus;

    public static CommandResult createForTesting(ByteArrayOutputStream stdout, ByteArrayOutputStream stderr, TerminationStatus status) {
        return new CommandResult(stdout, stderr, status);
    }

    CommandResult(ByteArrayOutputStream stdout, ByteArrayOutputStream stderr, TerminationStatus terminationStatus) {
        Preconditions.checkNotNull((Object)stdout);
        Preconditions.checkNotNull((Object)stderr);
        Preconditions.checkNotNull((Object)terminationStatus);
        this.stdout = stdout;
        this.stderr = stderr;
        this.terminationStatus = terminationStatus;
    }

    public byte[] getStdout() {
        return this.stdout.toByteArray();
    }

    public byte[] getStderr() {
        return this.stderr.toByteArray();
    }

    @Deprecated
    public int getExitStatus() {
        return this.terminationStatus.getRawResult();
    }

    public TerminationStatus getTerminationStatus() {
        return this.terminationStatus;
    }

    void logThis() {
        if (!log.isLoggable(Level.FINER)) {
            return;
        }
        log.logp(Level.FINER, "com.google.io.base.shell.CommandResult", "logThis", this.terminationStatus.toString());
        if (this.stdout == NO_OUTPUT_COLLECTED) {
            return;
        }
        String string = String.valueOf(LogUtil.toTruncatedString(this.stdout.toByteArray()));
        log.logp(Level.FINER, "com.google.io.base.shell.CommandResult", "logThis", string.length() != 0 ? "Stdout: ".concat(string) : new String("Stdout: "));
        String string2 = String.valueOf(LogUtil.toTruncatedString(this.stderr.toByteArray()));
        log.logp(Level.FINER, "com.google.io.base.shell.CommandResult", "logThis", string2.length() != 0 ? "Stderr: ".concat(string2) : new String("Stderr: "));
    }
}

