/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.io.protocol.Extensions;
import com.google.io.protocol.ProtoString;
import com.google.io.protocol.Protocol;
import com.google.io.protocol.ProtocolMessage;
import com.google.io.protocol.ProtocolSink;
import com.google.io.protocol.ProtocolSource;
import com.google.io.protocol.ProtocolSupport;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Extension;
import com.google.protobuf.MutableMessage;
import com.google.protobuf.WireFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class LazyParsingExtension {
    List<ByteBuffer> raw;
    Extension parsedAs;
    volatile Object parsed;

    static LazyParsingExtension raw(ByteBuffer raw) {
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>();
        list.add(raw);
        return new LazyParsingExtension(list, null, null);
    }

    static LazyParsingExtension empty(Extension singleParsedAs) {
        return new LazyParsingExtension(null, singleParsedAs, LazyParsingExtension.newValue(singleParsedAs));
    }

    static <T> LazyParsingExtension parsed(Extension<?, T> parsedAs, T parsed) {
        return new LazyParsingExtension(null, parsedAs, parsed);
    }

    private LazyParsingExtension(List<ByteBuffer> raw, Extension parsedAs, Object parsed) {
        this.raw = raw;
        this.parsedAs = parsedAs;
        this.parsed = parsed;
    }

    LazyParsingExtension copy() {
        if (this.parsedAs == null) {
            return new LazyParsingExtension(this.raw, null, null);
        }
        LazyParsingExtension copy = LazyParsingExtension.empty(this.parsedAs);
        copy.merge(this);
        return copy;
    }

    Descriptors.FieldDescriptor getFieldDescriptor() {
        if (this.parsedAs != null) {
            return this.parsedAs.getDescriptor();
        }
        return null;
    }

    public final void addRaw(ByteBuffer buffer) {
        this.merge(LazyParsingExtension.raw(buffer));
    }

    public final void merge(LazyParsingExtension other) {
        if (this.isParsed() && other.isParsed()) {
            this.parsed = LazyParsingExtension.merge(this.parsedAs, this.parsed, other.parsed);
        } else if (this.isParsed() && !other.isParsed()) {
            this.parsed = LazyParsingExtension.merge(this.parsedAs, this.parsed, other.read(this.parsedAs));
        } else if (!this.isParsed() && other.isParsed()) {
            this.parsed = LazyParsingExtension.merge(other.parsedAs, this.read(other.parsedAs), other.parsed);
        } else {
            this.raw.addAll(other.raw);
        }
    }

    public final <T> T read(Extension<?, T> extension) {
        this.parseIfNeeded(extension);
        return (T)this.parsed;
    }

    public final boolean isParsed() {
        return this.parsed != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final <T> void parseIfNeeded(Extension<?, T> extension) {
        Object object;
        if (!this.isParsed()) {
            object = this;
            synchronized (object) {
                if (!this.isParsed()) {
                    this.parsedAs = extension;
                    this.parsed = LazyParsingExtension.readFromRepeatedTags(extension, this.raw);
                    this.raw = null;
                }
            }
        }
        Preconditions.checkState((this.parsedAs != null ? 1 : 0) != 0);
        Preconditions.checkState((this.parsed != null ? 1 : 0) != 0);
        if (this.parsedAs.getNumber() != extension.getNumber() || this.parsedAs.getLiteType() != extension.getLiteType()) {
            object = String.valueOf(this.parsedAs);
            String string = String.valueOf(extension);
            throw new IllegalArgumentException(new StringBuilder(78 + String.valueOf(object).length() + String.valueOf(string).length()).append("Already parsed as a different extension. Parsed as: ").append((String)object).append(", attempting to parse as ").append(string).append(".").toString());
        }
        Preconditions.checkState((boolean)this.isParsed(), (Object)"isParsed() should be true right after data is parsed.");
    }

    public final void writeParsed(ProtocolSink sink) {
        if (!this.isParsed()) {
            throw new IllegalStateException("Extension is not yet parsed.");
        }
        int wireTag = Extensions.getWireTag(this.parsedAs);
        if (this.parsedAs.isRepeated()) {
            for (Object dataPiece : (List)this.parsed) {
                LazyParsingExtension.writeSingle(wireTag, this.parsedAs.getLiteType(), this.parsedAs.getMessageType(), dataPiece, sink);
            }
        } else {
            LazyParsingExtension.writeSingle(wireTag, this.parsedAs.getLiteType(), this.parsedAs.getMessageType(), this.parsed, sink);
        }
    }

    public final int encodingSizeParsed() {
        if (!this.isParsed()) {
            throw new IllegalStateException("Extension is not yet parsed.");
        }
        int wireTag = Extensions.getWireTag(this.parsedAs);
        if (this.parsedAs.isRepeated()) {
            int result = 0;
            for (Object dataPiece : (List)this.parsed) {
                result += LazyParsingExtension.encodingSizeSingle(wireTag, this.parsedAs.getLiteType(), dataPiece);
            }
            return result;
        }
        return LazyParsingExtension.encodingSizeSingle(wireTag, this.parsedAs.getLiteType(), this.parsed);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof LazyParsingExtension) {
            LazyParsingExtension other = (LazyParsingExtension)obj;
            if (this.isParsed() && other.isParsed()) {
                return this.parsedAs == other.parsedAs && this.parsed.equals(other.parsed);
            }
            if (!this.isParsed() && !other.isParsed()) {
                return this.raw.equals(other.raw);
            }
            if (this.isParsed()) {
                return this.parsed.equals(LazyParsingExtension.readFromRepeatedTags(this.parsedAs, other.raw));
            }
            return other.parsed.equals(LazyParsingExtension.readFromRepeatedTags(other.parsedAs, this.raw));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        if (!this.isParsed()) {
            LazyParsingExtension lazyParsingExtension = this;
            synchronized (lazyParsingExtension) {
                if (!this.isParsed()) {
                    int hash = 1;
                    for (ByteBuffer oneRaw : this.raw) {
                        hash = 31 * hash + oneRaw.hashCode();
                    }
                    return hash;
                }
            }
        }
        if (this.parsed instanceof Collection) {
            int hash = 1;
            for (Object unitParsed : (Collection)this.parsed) {
                hash = 31 * hash + this.hashCode(this.parsedAs, unitParsed);
            }
            return hash;
        }
        return 31 + this.hashCode(this.parsedAs, this.parsed);
    }

    private int hashCode(Extension unitExtension, Object unitParsed) {
        int wireTag = Extensions.getWireTag(unitExtension);
        int encodedSize = LazyParsingExtension.encodingSizeSingle(wireTag, unitExtension.getLiteType(), unitParsed);
        ProtocolSink sink = new ProtocolSink(encodedSize);
        LazyParsingExtension.writeSingle(wireTag, unitExtension.getLiteType(), unitExtension.getMessageType(), unitParsed, sink);
        int offset = Protocol.varIntSize(wireTag);
        return ByteBuffer.wrap(sink.array(), offset, encodedSize - offset).hashCode();
    }

    static void reportInvalidType(WireFormat.FieldType fieldType) {
        String string = String.valueOf((Object)fieldType);
        throw new Extensions.LazyParsingException(new StringBuilder(37 + String.valueOf(string).length()).append("Proto1 does not support proto2 type: ").append(string).toString());
    }

    private static boolean isPrimitive(Extension ext) throws Extensions.LazyParsingException {
        switch (ext.getLiteType()) {
            case BOOL: 
            case INT32: 
            case FIXED32: 
            case INT64: 
            case FIXED64: 
            case FLOAT: 
            case DOUBLE: 
            case BYTES: {
                return true;
            }
            case MESSAGE: {
                return false;
            }
        }
        LazyParsingExtension.reportInvalidType(ext.getLiteType());
        return false;
    }

    private static void mergeSerialized(ProtocolMessage<?> mergeInto, ByteBuffer source) throws Extensions.LazyParsingException {
        ProtocolSource protoSource = new ProtocolSource(source);
        protoSource.push(protoSource.getVarInt());
        if (!mergeInto.mergeFrom(protoSource)) {
            String string = String.valueOf(mergeInto.getClass());
            String string2 = String.valueOf(source);
            throw new Extensions.LazyParsingException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to parse ").append(string).append(" proto from ").append(string2).toString());
        }
    }

    private static void mergeSerializedToProto2MutableMessage(MutableMessage mergeInto, ByteBuffer source) throws Extensions.LazyParsingException {
        ProtocolSource protoSource = new ProtocolSource(source);
        protoSource.push(protoSource.getVarInt());
        if (!ProtocolSupport.mergeProto2MutableMessage(mergeInto, protoSource)) {
            String string = String.valueOf(mergeInto.getClass());
            String string2 = String.valueOf(source);
            throw new Extensions.LazyParsingException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to parse ").append(string).append(" proto from ").append(string2).toString());
        }
    }

    @VisibleForTesting
    static <T> T readOne(Extension<?, T> ext, ByteBuffer data) {
        switch (ext.getLiteType()) {
            case BOOL: {
                return (T)Boolean.valueOf(Protocol.getBoolean(data));
            }
            case INT32: {
                return (T)Integer.valueOf(Protocol.getVarInt(data));
            }
            case INT64: {
                return (T)Long.valueOf(Protocol.getVarLong(data));
            }
            case FIXED32: {
                return (T)Integer.valueOf(new ProtocolSource(data).getInt());
            }
            case FIXED64: {
                return (T)Long.valueOf(new ProtocolSource(data).getLong());
            }
            case FLOAT: {
                return (T)Float.valueOf(new ProtocolSource(data).getFloat());
            }
            case DOUBLE: {
                return (T)Double.valueOf(new ProtocolSource(data).getDouble());
            }
            case BYTES: {
                return (T)new ProtoString(Protocol.getPrefixedData(data));
            }
            case MESSAGE: {
                MutableMessage result = ((MutableMessage)ext.getMessageDefaultInstance()).newMessageForType();
                if (ext.getMessageType() == Extension.MessageType.PROTO1) {
                    LazyParsingExtension.mergeSerialized((ProtocolMessage)result, data);
                } else {
                    LazyParsingExtension.mergeSerializedToProto2MutableMessage(result, data);
                }
                return (T)result;
            }
        }
        LazyParsingExtension.reportInvalidType(ext.getLiteType());
        return null;
    }

    @VisibleForTesting
    static <T> T readFromRepeatedTags(Extension<?, T> ext, List<ByteBuffer> allSourceData) {
        if (ext.isRepeated()) {
            ArrayList<T> result = new ArrayList<T>();
            for (ByteBuffer b : allSourceData) {
                result.add(LazyParsingExtension.readOne(ext, b.asReadOnlyBuffer()));
            }
            return (T)result;
        }
        if (LazyParsingExtension.isPrimitive(ext)) {
            return LazyParsingExtension.readOne(ext, allSourceData.get(allSourceData.size() - 1).asReadOnlyBuffer());
        }
        MutableMessage result = null;
        for (ByteBuffer extData : allSourceData) {
            if (result == null) {
                result = ((MutableMessage)ext.getMessageDefaultInstance()).newMessageForType();
            }
            if (ext.getMessageType() == Extension.MessageType.PROTO1) {
                LazyParsingExtension.mergeSerialized((ProtocolMessage)result, extData.asReadOnlyBuffer());
                continue;
            }
            LazyParsingExtension.mergeSerializedToProto2MutableMessage(result, extData.asReadOnlyBuffer());
        }
        return (T)result;
    }

    private static <T> T merge(Extension<?, T> ext, T mergeInto, T mergeFrom) {
        if (ext.isRepeated()) {
            List fromList = (List)mergeFrom;
            List toList = (List)mergeInto;
            if (LazyParsingExtension.isPrimitive(ext)) {
                toList.addAll(fromList);
            } else {
                for (Object value : fromList) {
                    toList.add(((MutableMessage)value).clone());
                }
            }
            return mergeInto;
        }
        if (LazyParsingExtension.isPrimitive(ext)) {
            return mergeFrom;
        }
        ((MutableMessage)mergeInto).mergeFrom((MutableMessage)mergeFrom);
        return mergeInto;
    }

    private static <T> T newValue(Extension<?, T> ext) {
        if (ext.isRepeated()) {
            return (T)new ArrayList();
        }
        if (ext.getLiteType() == WireFormat.FieldType.MESSAGE) {
            return (T)((MutableMessage)ext.getMessageDefaultInstance()).newMessageForType();
        }
        return (T)ext.getDefaultValue();
    }

    private static void writeSingle(int wireTag, WireFormat.FieldType fieldType, Extension.MessageType messageType, Object data, ProtocolSink sink) {
        sink.putVarInt(wireTag);
        switch (fieldType) {
            case BOOL: {
                sink.putBoolean((Boolean)data);
                break;
            }
            case INT32: {
                sink.putVarInt((Integer)data);
                break;
            }
            case FIXED32: {
                sink.putInt((Integer)data);
                break;
            }
            case INT64: {
                sink.putVarLong((Long)data);
                break;
            }
            case FIXED64: {
                sink.putLong((Long)data);
                break;
            }
            case FLOAT: {
                sink.putFloat(((Float)data).floatValue());
                break;
            }
            case DOUBLE: {
                sink.putDouble((Double)data);
                break;
            }
            case BYTES: {
                sink.putPrefixedData(((ProtoString)data).getAsBytes());
                break;
            }
            case MESSAGE: {
                if (messageType == Extension.MessageType.PROTO1) {
                    sink.putForeign((ProtocolMessage)data);
                    break;
                }
                sink.putProto2MutableMessage((MutableMessage)data);
                break;
            }
            default: {
                LazyParsingExtension.reportInvalidType(fieldType);
            }
        }
    }

    private static int encodingSizeSingle(int wireTag, WireFormat.FieldType fieldType, Object data) {
        int tagSize = Protocol.varIntSize(wireTag);
        switch (fieldType) {
            case BOOL: {
                return tagSize + 1;
            }
            case INT32: {
                return tagSize + Protocol.varIntSize((Integer)data);
            }
            case FIXED32: 
            case FLOAT: {
                return tagSize + 4;
            }
            case INT64: {
                return tagSize + Protocol.varLongSize((Long)data);
            }
            case FIXED64: 
            case DOUBLE: {
                return tagSize + 8;
            }
            case BYTES: {
                int bytesLength = ((ProtoString)data).getAsBytes().length;
                return tagSize + Protocol.varIntSize(bytesLength) + bytesLength;
            }
            case MESSAGE: {
                int messageLength = ((MutableMessage)data).getSerializedSize();
                return tagSize + Protocol.varIntSize(messageLength) + messageLength;
            }
        }
        LazyParsingExtension.reportInvalidType(fieldType);
        return 0;
    }

    int encodingSize(int wireTag) {
        if (this.isParsed()) {
            return this.encodingSizeParsed();
        }
        int result = this.raw.size() * Protocol.varIntSize(wireTag);
        for (ByteBuffer b : this.raw) {
            result += b.remaining();
        }
        return result;
    }

    void put(int wireTag, ProtocolSink sink) {
        if (this.isParsed()) {
            this.writeParsed(sink);
        } else {
            for (ByteBuffer b : this.raw) {
                sink.putVarInt(wireTag);
                sink.putBytes(b.array());
            }
        }
    }
}

