/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags;

import com.google.common.flags.BaseEnumFlag;
import com.google.common.flags.FlagDescription;
import com.google.common.flags.FlagInfo;
import com.google.common.flags.Flags;
import com.google.common.flags.IllegalFlagStateException;
import com.google.common.flags.InvalidFlagValueException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.WriteOnly;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jspecify.nullness.Nullable;

public abstract class Flag<T> {
    volatile T value;
    final T defaultValue;
    @WriteOnly
    boolean accessed = false;
    boolean setFromString = false;
    private volatile @Nullable String commandLineName;
    private volatile @Nullable String commandLineValue;
    final @Nullable String declaringClassName;
    private volatile @Nullable FlagInfo flagInfo;
    private static final boolean IS_ANDROID = Flag.computeIsAndroid();

    protected Flag(T defaultValue) {
        this.defaultValue = defaultValue;
        this.declaringClassName = Flag.findLeafConstructingClassName(new Exception().fillInStackTrace());
        this.value = defaultValue;
        Flags.addFlag(this);
    }

    private static @Nullable String findLeafConstructingClassName(Throwable throwable) {
        for (StackTraceElement ste : throwable.getStackTrace()) {
            if (!ste.getMethodName().equals("<clinit>")) continue;
            return ste.getClassName().replace('$', '.');
        }
        return null;
    }

    @CanIgnoreReturnValue
    public T get() {
        this.accessed = true;
        return this.value;
    }

    @CanIgnoreReturnValue
    public final @NonNull T getNonNull() {
        T value = this.get();
        if (value == null) {
            FlagInfo info = this.getInfo();
            String flagName = info == null ? "" : info.longFlagName() + " ";
            throw new IllegalStateException("Flag " + flagName + "is null");
        }
        return value;
    }

    public final @NonNull T orElseGet(FlagValueSupplier<? extends @NonNull T> supplier) {
        if (this.defaultValue != null) {
            throw new IllegalStateException("orElseGet is only meaningful for flags with null defaults");
        }
        T value = this.get();
        if (value != null) {
            return value;
        }
        T fallback = supplier.get();
        return FlagDescription.checkNotNull(fallback);
    }

    public final @Nullable String parsableStringValue() {
        T value = this.get();
        return value != null ? this.parsableStringValue(value) : null;
    }

    protected String parsableStringValue(T value) {
        return FlagDescription.checkNotNull(value).toString();
    }

    public final String toString() {
        return String.valueOf(this.get());
    }

    public final boolean equals(@Nullable Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean wasSetFromString() {
        return this.setFromString;
    }

    public final T getDefault() {
        return this.defaultValue;
    }

    @Nullable String getDetails() {
        return null;
    }

    public final @Nullable FlagInfo getInfo() {
        if (this.flagInfo == null) {
            this.setInfo(Flags.getFlagInfo(this));
        }
        return this.flagInfo;
    }

    final void setInfo(@Nullable FlagInfo flagInfo) {
        this.flagInfo = flagInfo;
    }

    public final @Nullable String getCommandLineName() {
        if (this.commandLineName != null) {
            return this.commandLineName;
        }
        FlagInfo info = this.getInfo();
        if (info != null) {
            List<String> names = info.names();
            if (!names.isEmpty()) {
                return names.get(0);
            }
            return info.longFlagName();
        }
        return null;
    }

    private String getLongestName() {
        FlagInfo info = this.getInfo();
        if (info != null) {
            return info.longFlagName();
        }
        if (this.commandLineName != null) {
            return this.commandLineName;
        }
        return "<unknown>";
    }

    public final @Nullable String getCommandLineValue() {
        return this.commandLineValue;
    }

    private void checkWriteState() {
        if (!Flags.isParseInProgress() && !this.isSetFromStringAllowed()) {
            throw new IllegalFlagStateException("Setting flag " + this.getLongestName() + " from string is not allowed.");
        }
        if (this.accessed && !Flags.stateCheckingDisabled()) {
            throw new IllegalFlagStateException("Attempted to set flag " + this.getLongestName() + " after it was read");
        }
    }

    private void checkTestWriteState() {
        if (this.accessed && !Flags.stateCheckingDisabled()) {
            throw new IllegalFlagStateException("Attempted to set flag " + this.getLongestName() + " for tests without disabling state checking");
        }
    }

    private void warnIfDeprecated() {
        if (IS_ANDROID) {
            return;
        }
        FlagInfo info = this.getInfo();
        if (info != null && info.isDeprecated()) {
            FlagLogger.logger.logp(Level.WARNING, "com.google.common.flags.Flag", "warnIfDeprecated", "Flag --" + info.longFlagName() + " is deprecated: " + info.doc());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void setFromNameAndString(@Nullable String commandLineName, @Nullable String valueString, @Nullable String commandLineValue) throws InvalidFlagValueException {
        this.checkWriteState();
        this.setFromString = true;
        this.commandLineName = commandLineName;
        this.commandLineValue = commandLineValue;
        if (valueString == null) {
            if (!Flags.stateCheckingDisabled()) throw new NullPointerException();
            this.setToNull();
            return;
        } else {
            this.value = FlagDescription.checkNotNull(this.parse(valueString));
            this.warnIfDeprecated();
        }
    }

    private void setToNull() {
        this.value = null;
    }

    public final void setFromString(@Nullable String valueString) throws InvalidFlagValueException {
        if (IS_ANDROID) {
            throw new UnsupportedOperationException("Under Android, common.flags is untested, does not automatically read command-line parameters, and has historically had bugs. We have disabled setFromString there. Note that even *reading* the value of a flag under Android may cause problems. The safest bet is to avoid linking in the flags code at all.");
        }
        this.setFromNameAndString(null, valueString, valueString);
    }

    @ForOverride
    protected boolean isSetFromStringAllowed() {
        return true;
    }

    public void resetForTest() {
        this.checkTestWriteState();
        this.commandLineName = null;
        this.commandLineValue = null;
        this.accessed = false;
        this.setFromString = false;
        this.value = this.defaultValue;
    }

    private static boolean computeIsAndroid() {
        try {
            String value = System.getProperties().getProperty("java.runtime.name");
            return value != null && value.contains("Android");
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public void setForTest(T newValue) {
        if (IS_ANDROID) {
            throw new UnsupportedOperationException("Under Android, common.flags is untested, does not automatically read command-line parameters, and has historically had bugs. We have disabled setForTest there. Note that even *reading* the value of a flag under Android may cause problems. The safest bet is to avoid linking in the flags code at all.");
        }
        this.setForTestInternal(newValue);
    }

    final void setForTestInternal(T newValue) {
        this.checkTestWriteState();
        this.commandLineName = null;
        this.commandLineValue = null;
        this.value = newValue;
    }

    protected abstract T parse(String var1) throws InvalidFlagValueException;

    public static Flag<String> value(String defaultValue) {
        return new StringFlag<String>(defaultValue);
    }

    public static Flag<@Nullable String> nullString() {
        return new StringFlag<Object>(null);
    }

    public static Flag<Integer> value(int defaultValue) {
        return new IntegerFlag<Integer>(defaultValue, Integer.MIN_VALUE, null);
    }

    public static Flag<@Nullable Integer> nullInteger() {
        return new IntegerFlag<Integer>(null, Integer.MIN_VALUE, null);
    }

    public static Flag<Integer> nonnegativeValue(int defaultValue) {
        return new IntegerFlag<Integer>(defaultValue, 0, null);
    }

    public static Flag<@Nullable Integer> nullNonnegativeValue() {
        return new IntegerFlag<Integer>(null, 0, null);
    }

    public static Flag<Integer> positiveValue(int defaultValue) {
        return new IntegerFlag<Integer>(defaultValue, 1, null);
    }

    public static Flag<@Nullable Integer> nullPositiveValue() {
        return new IntegerFlag<Integer>(null, 1, null);
    }

    private static Integer parseIntegerOrMax(String text) {
        return "MAX".equals(text) ? Integer.valueOf(Integer.MAX_VALUE) : Integer.decode(text);
    }

    public static Flag<Long> value(long defaultValue) {
        return new LongFlag<Long>(defaultValue, null);
    }

    public static Flag<@Nullable Long> nullLong() {
        return new LongFlag<Long>(null, null);
    }

    public static Flag<Long> nonnegativeValue(long defaultValue) {
        return new Flag<Long>(Long.valueOf(defaultValue)){

            @Override
            protected Long parse(String text) throws InvalidFlagValueException {
                try {
                    Long val = Flag.parseLongOrMax(text);
                    if (val < 0L) {
                        throw new InvalidFlagValueException("Must not be negative");
                    }
                    return val;
                }
                catch (NumberFormatException e) {
                    throw new InvalidFlagValueException("Invalid integer syntax", e);
                }
            }
        };
    }

    public static Flag<Long> positiveValue(long defaultValue) {
        return new Flag<Long>(Long.valueOf(defaultValue)){

            @Override
            protected Long parse(String text) throws InvalidFlagValueException {
                try {
                    Long value = Flag.parseLongOrMax(text);
                    if (value <= 0L) {
                        throw new InvalidFlagValueException("Must be positive");
                    }
                    return value;
                }
                catch (NumberFormatException e) {
                    throw new InvalidFlagValueException("Invalid integer syntax", e);
                }
            }
        };
    }

    private static Long parseLongOrMax(String text) {
        return "MAX".equals(text) ? Long.valueOf(Long.MAX_VALUE) : Long.decode(text);
    }

    public static Flag<Float> value(float defaultValue) {
        return new FloatFlag<Float>(Float.valueOf(defaultValue), null);
    }

    public static Flag<@Nullable Float> nullFloat() {
        return new FloatFlag<Float>(null, null);
    }

    private static Float parseFloatOrMax(String text) {
        return "MAX".equals(text) ? Float.valueOf(Float.POSITIVE_INFINITY) : Float.valueOf(text);
    }

    public static Flag<Double> value(double defaultValue) {
        return new DoubleFlag<Double>(defaultValue, null);
    }

    public static Flag<@Nullable Double> nullDouble() {
        return new DoubleFlag<Double>(null, null);
    }

    private static Double parseDoubleOrMax(String text) {
        return "MAX".equals(text) ? Double.valueOf(Double.POSITIVE_INFINITY) : Double.valueOf(text);
    }

    public static Flag<Boolean> value(boolean defaultValue) {
        return new BooleanFlag<Boolean>(defaultValue, null);
    }

    public static Flag<@Nullable Boolean> nullBoolean() {
        return new BooleanFlag<Boolean>(null, null);
    }

    public static Flag<BigDecimal> value(BigDecimal defaultValue) {
        return new BigDecimalFlag<BigDecimal>(FlagDescription.checkNotNull(defaultValue));
    }

    public static Flag<@Nullable BigDecimal> nullBigDecimal() {
        return new BigDecimalFlag<Object>(null);
    }

    public static Flag<Class<?>> value(Class<?> defaultValue) {
        return new ClassFlag(FlagDescription.checkNotNull(defaultValue), Object.class, null);
    }

    public static Flag<@Nullable Class<?>> nullableClass(@Nullable Class<? extends Object> defaultValue) {
        return new ClassFlag(defaultValue, Object.class, null);
    }

    public static Flag<@Nullable Class<?>> nullClass() {
        return new ClassFlag(null, Object.class, null);
    }

    public static <T> Flag<Class<? extends T>> value(Class<? extends T> defaultValue, Class<T> constraint) {
        return new ClassFlag(FlagDescription.checkNotNull(defaultValue), constraint, null);
    }

    public static <T> Flag<@Nullable Class<? extends T>> nullClass(Class<T> constraint) {
        return new ClassFlag(null, constraint, null);
    }

    public static <T extends Enum<T>> Flag<T> value(T defaultValue) {
        FlagDescription.checkNotNull(defaultValue);
        return Flag.value(defaultValue, false);
    }

    public static <E extends Enum<E>> Flag<E> value(E defaultValue, boolean autoUpperCase) {
        FlagDescription.checkNotNull(defaultValue);
        return new EnumFlag(defaultValue, defaultValue.getDeclaringClass(), autoUpperCase, null);
    }

    public static <E extends Enum<E>> Flag<@Nullable E> value(Class<E> enumType, boolean autoUpperCase) {
        FlagDescription.checkNotNull(enumType);
        return new EnumFlag(null, enumType, autoUpperCase, null);
    }

    public static <E extends Enum<E>, T extends E> Flag<T> value(Class<E> enumType, T defaultValue) {
        FlagDescription.checkNotNull(enumType);
        return new EnumFlag((Enum)defaultValue, enumType, false, null);
    }

    public static <E extends Enum<E>> Flag<@Nullable E> nullEnum(Class<E> enumType) {
        FlagDescription.checkNotNull(enumType);
        return new EnumFlag(null, enumType, false, null);
    }

    @Deprecated
    public static Flag<Date> value(Date defaultValue, DateFormat format) {
        FlagDescription.checkNotNull(defaultValue);
        FlagDescription.checkNotNull(format);
        return new DateFlag<Date>(defaultValue, format);
    }

    @Deprecated
    public static Flag<@Nullable Date> nullDate(DateFormat format) {
        FlagDescription.checkNotNull(format);
        return new DateFlag<Object>(null, format);
    }

    public static Flag<List<Integer>> integerList(int ... defaultValues) {
        List<Integer> defaultValue = new ArrayList();
        for (int i : defaultValues) {
            defaultValue.add(i);
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new Flag<List<Integer>>(defaultValue){

            @Override
            protected List<Integer> parse(String text) throws InvalidFlagValueException {
                ArrayList<Integer> result = new ArrayList<Integer>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseIntegerOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().isEmpty()) continue;
                        throw new InvalidFlagValueException("Invalid integer syntax " + s, e);
                    }
                }
                return Collections.unmodifiableList(result);
            }

            @Override
            public String parsableStringValue(List<Integer> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    private static String joinToStrings(Iterable<?> objs) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objs) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static Flag<List<Long>> longList(long ... defaultValues) {
        List<Long> defaultValue = new ArrayList();
        for (long i : defaultValues) {
            defaultValue.add(i);
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new Flag<List<Long>>(defaultValue){

            @Override
            protected List<Long> parse(String text) throws InvalidFlagValueException {
                ArrayList<Long> result = new ArrayList<Long>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseLongOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().isEmpty()) continue;
                        throw new InvalidFlagValueException("Invalid long syntax " + s, e);
                    }
                }
                return Collections.unmodifiableList(result);
            }

            @Override
            public String parsableStringValue(List<Long> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static Flag<List<Double>> doubleList(double ... defaultValues) {
        List<Double> defaultValue = new ArrayList();
        for (double i : defaultValues) {
            defaultValue.add(i);
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new Flag<List<Double>>(defaultValue){

            @Override
            protected List<Double> parse(String text) throws InvalidFlagValueException {
                ArrayList<Double> result = new ArrayList<Double>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseDoubleOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().isEmpty()) continue;
                        throw new InvalidFlagValueException("Invalid double syntax " + s, e);
                    }
                }
                return Collections.unmodifiableList(result);
            }

            @Override
            public String parsableStringValue(List<Double> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static <T extends Enum<T>> Flag<List<T>> enumList(Class<T> enumType, T ... defaultValues) {
        return Flag.enumList(enumType, (boolean)false, defaultValues);
    }

    public static <T extends Enum<T>> Flag<List<T>> enumList(Class<T> enumType, boolean autoUpperCase, T ... defaultValues) {
        FlagDescription.checkNotNull(enumType, "enumType must not be null");
        List<T> defaultValue = new ArrayList();
        for (T t : defaultValues) {
            FlagDescription.checkNotNull(t, "Elements of defaultValues must not be null");
            defaultValue.add(t);
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new EnumListFlag(defaultValue, enumType, autoUpperCase);
    }

    public static Flag<List<String>> stringList(String ... defaultValues) {
        List<String> defaultValue = new ArrayList();
        for (String s : defaultValues) {
            defaultValue.add(FlagDescription.checkNotNull(s));
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new Flag<List<String>>(defaultValue){

            @Override
            protected List<String> parse(String text) {
                return Collections.unmodifiableList(Flag.splitCsvString(text));
            }

            @Override
            public String parsableStringValue(List<String> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static Flag<Set<String>> stringSet(String ... defaultValues) {
        LinkedHashSet<String> defaultValue = new LinkedHashSet<String>();
        for (String s : defaultValues) {
            defaultValue.add(FlagDescription.checkNotNull(s));
        }
        return new Flag<Set<String>>(Collections.unmodifiableSet(defaultValue)){

            @Override
            protected Set<String> parse(String text) {
                return Collections.unmodifiableSet(new LinkedHashSet(Flag.splitCsvString(text)));
            }

            @Override
            public String parsableStringValue(Set<String> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    private static List<String> splitCsvString(String text) {
        ArrayList<String> result = new ArrayList<String>();
        if (!text.trim().isEmpty()) {
            for (String s : text.split(",")) {
                result.add(s.trim());
            }
        }
        return result;
    }

    public static Flag<Set<Integer>> integerSet(int ... defaultValues) {
        LinkedHashSet<Integer> defaultValue = new LinkedHashSet<Integer>();
        for (int s : defaultValues) {
            defaultValue.add(s);
        }
        return new Flag<Set<Integer>>(Collections.unmodifiableSet(defaultValue)){

            @Override
            protected Set<Integer> parse(String text) throws InvalidFlagValueException {
                LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseIntegerOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().isEmpty()) continue;
                        throw new InvalidFlagValueException("Invalid integer syntax " + s, e);
                    }
                }
                return Collections.unmodifiableSet(result);
            }

            @Override
            public String parsableStringValue(Set<Integer> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static Flag<Set<Long>> longSet(long ... defaultValues) {
        LinkedHashSet<Long> defaultValue = new LinkedHashSet<Long>();
        for (long s : defaultValues) {
            defaultValue.add(s);
        }
        return new Flag<Set<Long>>(Collections.unmodifiableSet(defaultValue)){

            @Override
            protected Set<Long> parse(String text) throws InvalidFlagValueException {
                LinkedHashSet<Long> result = new LinkedHashSet<Long>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseLongOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().isEmpty()) continue;
                        throw new InvalidFlagValueException("Invalid long syntax " + s, e);
                    }
                }
                return Collections.unmodifiableSet(result);
            }

            @Override
            public String parsableStringValue(Set<Long> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static Flag<List<String>> stringCollector(String ... defaultValues) {
        final ArrayList<String> defaults = new ArrayList<String>(defaultValues.length);
        for (String s : defaultValues) {
            FlagDescription.checkNotNull(s);
            defaults.add(s);
        }
        final ArrayList result = new ArrayList(defaults);
        return new Flag<List<String>>(Collections.unmodifiableList(result)){
            private boolean resultCleared;
            {
                super(defaultValue);
                this.resultCleared = false;
            }

            @Override
            protected List<String> parse(String text) {
                if (!this.resultCleared) {
                    this.resultCleared = true;
                    result.clear();
                }
                result.add(text);
                return Collections.unmodifiableList(result);
            }

            @Override
            public String parsableStringValue(List<String> value) {
                throw new UnsupportedOperationException("List can not be represented in a single String: " + value);
            }

            @Override
            public void resetForTest() {
                super.resetForTest();
                result.clear();
                result.addAll(defaults);
                this.resultCleared = false;
            }

            @Override
            String getDetails() {
                return "can be specified multiple times, values will be aggregated.";
            }
        };
    }

    public static Flag<Map<String, String>> stringMap() {
        return Flag.stringMap(Collections.emptyMap());
    }

    public static Flag<Map<String, String>> stringMap(Map<String, String> defaultValue) {
        FlagDescription.checkNotNull(defaultValue);
        return new StringMapFlag<Map<String, String>>(defaultValue);
    }

    public static Flag<@Nullable Map<String, String>> nullableStringMap(@Nullable Map<String, String> defaultValue) {
        return new StringMapFlag<Map<String, String>>(defaultValue);
    }

    private static class StringMapFlag<M extends @Nullable Map<String, String>>
    extends Flag<M> {
        StringMapFlag(M defaultValue) {
            super(defaultValue);
        }

        @Override
        protected M parse(String text) throws InvalidFlagValueException {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            if (!text.trim().isEmpty()) {
                for (String s : text.split(",")) {
                    int index = s.indexOf(61);
                    if (index == -1) {
                        throw new InvalidFlagValueException("Invalid map entry syntax " + s);
                    }
                    result.put(s.substring(0, index).trim(), s.substring(index + 1).trim());
                }
            }
            LinkedHashMap<String, String> resultM = result;
            return (M)resultM;
        }

        @Override
        public String parsableStringValue(M value) {
            ArrayList<String> keyValueStrings = new ArrayList<String>();
            for (Map.Entry entry : ((Map)FlagDescription.checkNotNull(value)).entrySet()) {
                keyValueStrings.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            return Flag.joinToStrings(keyValueStrings);
        }
    }

    private static class EnumListFlag<T extends Enum<T>>
    extends BaseEnumFlag<T, List<T>> {
        private EnumListFlag(List<T> defaultValue, Class<T> enumType, boolean autoUpperCase) {
            super(defaultValue, enumType, autoUpperCase);
        }

        @Override
        protected List<T> parse(String text) throws InvalidFlagValueException {
            ArrayList result = new ArrayList();
            if (!text.trim().isEmpty()) {
                for (String s : text.split(",")) {
                    result.add(this.parseEnum(s.trim()));
                }
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public String parsableStringValue(List<T> value) {
            FlagDescription.checkNotNull(value);
            return Flag.joinToStrings(EnumListFlag.enumNames(value));
        }
    }

    private static class DateFlag<T extends @Nullable Date>
    extends Flag<T> {
        private final DateFormat format;

        DateFlag(T defaultValue, DateFormat format) {
            super(defaultValue);
            this.format = format;
        }

        @Override
        protected T parse(String text) throws InvalidFlagValueException {
            try {
                Date value = this.format.parse(text);
                return (T)value;
            }
            catch (ParseException ex) {
                throw new InvalidFlagValueException("Invalid date syntax", ex);
            }
        }

        @Override
        public String parsableStringValue(T value) {
            FlagDescription.checkNotNull(value);
            return this.format.format((Date)value);
        }
    }

    private static class EnumFlag<E extends Enum<E>, T extends @Nullable E>
    extends BaseEnumFlag<E, T> {
        private EnumFlag(T defaultValue, Class<E> enumType, boolean autoUpperCase) {
            super(defaultValue, enumType, autoUpperCase);
        }

        @Override
        protected T parse(String name) throws InvalidFlagValueException {
            Object ret = this.parseEnum(name);
            return (T)ret;
        }

        @Override
        public String parsableStringValue(T value) {
            return ((Enum)FlagDescription.checkNotNull(value)).name();
        }

        /* synthetic */ EnumFlag(Enum x0, Class x1, boolean x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    private static class ClassFlag<T, D extends @Nullable Class<? extends T>>
    extends Flag<D> {
        private final Class<T> constraint;

        private ClassFlag(D defaultValue, Class<T> constraint) {
            super(defaultValue);
            this.constraint = FlagDescription.checkNotNull(constraint);
        }

        @Override
        protected D parse(String text) throws InvalidFlagValueException {
            try {
                Class<T> value = ClassFlag.classForName(text).asSubclass(this.constraint);
                return (D)value;
            }
            catch (ClassCastException ex) {
                throw new InvalidFlagValueException("Not a subtype of " + this.constraint, ex);
            }
        }

        @Override
        public String parsableStringValue(D value) {
            return ((Class)FlagDescription.checkNotNull(value)).getName();
        }

        private static Class<?> classForName(String name) throws InvalidFlagValueException {
            try {
                return Class.forName(FlagDescription.checkNotNull(name));
            }
            catch (ClassNotFoundException e) {
                throw new InvalidFlagValueException("No class name with the given name could be found; there are several possible causes: the class exists but is not available to the classloader (e.g. missing dependency), the class name is misspelled, or the class name needs to be fully qualified.", e);
            }
        }

        /* synthetic */ ClassFlag(Class x0, Class x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class BigDecimalFlag<T extends @Nullable BigDecimal>
    extends Flag<T> {
        BigDecimalFlag(T defaultValue) {
            super(defaultValue);
        }

        @Override
        protected T parse(String text) throws InvalidFlagValueException {
            try {
                BigDecimal value = new BigDecimal(text);
                return (T)value;
            }
            catch (NumberFormatException ex) {
                throw new InvalidFlagValueException("Invalid BigDecimal syntax", ex);
            }
        }
    }

    private static class BooleanFlag<T extends @Nullable Boolean>
    extends Flag<T> {
        private static final Pattern TRUE_PATTERN = Pattern.compile("^(true|t|yes|y|1)$", 2);
        private static final Pattern FALSE_PATTERN = Pattern.compile("^(false|f|no|n|0)$", 2);

        private BooleanFlag(T defaultValue) {
            super(defaultValue);
        }

        @Override
        protected T parse(String text) throws InvalidFlagValueException {
            if (TRUE_PATTERN.matcher(text).matches()) {
                return (T)Boolean.TRUE;
            }
            if (FALSE_PATTERN.matcher(text).matches()) {
                return (T)Boolean.FALSE;
            }
            throw new InvalidFlagValueException("Invalid boolean syntax");
        }

        /* synthetic */ BooleanFlag(Boolean x0, 1 x1) {
            this(x0);
        }
    }

    private static class DoubleFlag<T extends @Nullable Double>
    extends Flag<T> {
        private DoubleFlag(T defaultValue) {
            super(defaultValue);
        }

        @Override
        protected T parse(String text) throws InvalidFlagValueException {
            try {
                Double value = Flag.parseDoubleOrMax(text);
                return (T)value;
            }
            catch (NumberFormatException ex) {
                throw new InvalidFlagValueException("Invalid double syntax", ex);
            }
        }

        /* synthetic */ DoubleFlag(Double x0, 1 x1) {
            this(x0);
        }
    }

    private static class FloatFlag<T extends @Nullable Float>
    extends Flag<T> {
        private FloatFlag(T defaultValue) {
            super(defaultValue);
        }

        @Override
        protected T parse(String text) throws InvalidFlagValueException {
            try {
                Float value = Flag.parseFloatOrMax(text);
                return (T)value;
            }
            catch (NumberFormatException ex) {
                throw new InvalidFlagValueException("Invalid float syntax", ex);
            }
        }

        /* synthetic */ FloatFlag(Float x0, 1 x1) {
            this(x0);
        }
    }

    private static class LongFlag<T extends @Nullable Long>
    extends Flag<T> {
        private LongFlag(T defaultValue) {
            super(defaultValue);
        }

        @Override
        protected T parse(String text) throws InvalidFlagValueException {
            try {
                Long value = Flag.parseLongOrMax(text);
                return (T)value;
            }
            catch (NumberFormatException ex) {
                throw new InvalidFlagValueException("Invalid long syntax", ex);
            }
        }

        /* synthetic */ LongFlag(Long x0, 1 x1) {
            this(x0);
        }
    }

    private static class IntegerFlag<T extends @Nullable Integer>
    extends Flag<T> {
        private final int lowerBound;

        private IntegerFlag(T defaultValue, int lowerBound) {
            super(defaultValue);
            this.lowerBound = lowerBound;
        }

        @Override
        protected T parse(String text) throws InvalidFlagValueException {
            try {
                Integer value = Flag.parseIntegerOrMax(text);
                if (value < this.lowerBound) {
                    throw new InvalidFlagValueException("Must be at least " + this.lowerBound);
                }
                Integer valueT = value;
                return (T)valueT;
            }
            catch (NumberFormatException ex) {
                throw new InvalidFlagValueException("Invalid integer syntax", ex);
            }
        }

        /* synthetic */ IntegerFlag(Integer x0, int x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class StringFlag<T extends @Nullable String>
    extends Flag<T> {
        StringFlag(T defaultValue) {
            super(defaultValue);
        }

        @Override
        protected T parse(String valueString) {
            return (T)valueString;
        }
    }

    public static interface FlagValueSupplier<T> {
        public T get();
    }

    private static class FlagLogger {
        private static final Logger logger = Logger.getLogger(Flag.class.getName());

        private FlagLogger() {
        }
    }
}

