/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags;

import com.google.common.flags.DocLevel;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jspecify.nullness.Nullable;

class FlagDescription
implements Comparable<FlagDescription> {
    private final String shortFlagName;
    private final String containerClassName;
    private final @Nullable String simpleFieldName;
    private final String type;
    private final String doc;
    private final DocLevel docLevel;
    private final @Nullable String altName;
    private final boolean isDeprecated;
    private final String longFlagName;

    private FlagDescription(String shortFlagName, String containerClassName, @Nullable String simpleFieldName, String type, String doc, DocLevel docLevel, @Nullable String altName, boolean isDeprecated) {
        this.shortFlagName = shortFlagName;
        this.containerClassName = containerClassName;
        this.simpleFieldName = simpleFieldName;
        this.type = type;
        this.doc = doc;
        this.docLevel = docLevel;
        this.altName = FlagDescription.emptyStringToNull(altName);
        this.isDeprecated = isDeprecated;
        FlagDescription.checkNotReserved(this.getShortFlagName());
        FlagDescription.checkNotReserved(this.getAltName());
        this.longFlagName = containerClassName + "." + this.getShortFlagName();
    }

    private static void checkNotReserved(@Nullable String s) {
        if (s != null && (s.equals("help") || s.equals("helpxml") || s.equals("flagfile") || s.equals("flagresource"))) {
            throw new IllegalArgumentException("The " + s + " flag is built-in and may not be registered");
        }
    }

    static Builder createFlagFromField(String fullyQualifiedFieldName, String shortFlagName) {
        FlagDescription.checkNotNull(shortFlagName);
        int lastDotIndex = FlagDescription.findLastDotIndex(fullyQualifiedFieldName);
        return new Builder(fullyQualifiedFieldName.substring(0, lastDotIndex), fullyQualifiedFieldName.substring(lastDotIndex + 1), shortFlagName);
    }

    static Builder createManuallyRegisteredFlag(String shortFlagName, String containerClassName) {
        return new Builder(containerClassName, null, shortFlagName);
    }

    String getLongFlagName() {
        return this.longFlagName;
    }

    String getFullyQualifiedFieldName() {
        return this.getContainerClassName() + "." + this.getSimpleFieldName();
    }

    String getSimpleFieldName() {
        String simpleFieldName = this.simpleFieldName;
        if (simpleFieldName == null) {
            throw new UnsupportedOperationException("Flag " + this.getLongFlagName() + " is not associated with a field");
        }
        return simpleFieldName;
    }

    boolean isField() {
        return this.simpleFieldName != null;
    }

    String getShortFlagName() {
        return this.shortFlagName;
    }

    String getContainerClassName() {
        return this.containerClassName;
    }

    String getType() {
        return this.type;
    }

    String getDoc() {
        return this.doc;
    }

    DocLevel getDocLevel() {
        return this.docLevel;
    }

    @Nullable String getAltName() {
        return this.altName;
    }

    @Nullable String getLongAltName() {
        return this.altName != null ? this.containerClassName + "." + this.altName : null;
    }

    boolean isDeprecated() {
        return this.isDeprecated;
    }

    boolean isPositiveFormOfName(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return name.equals(this.getShortFlagName()) || name.equals(this.getAltName()) || name.equals(this.getLongFlagName()) || name.equals(this.getLongAltName());
    }

    public String toString() {
        return this.getLongFlagName();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof FlagDescription)) {
            return false;
        }
        FlagDescription o = (FlagDescription)other;
        return o.shortFlagName.equals(this.shortFlagName) && o.containerClassName.equals(this.containerClassName) && FlagDescription.nullSafeEquals(o.simpleFieldName, this.simpleFieldName) && o.type.equals(this.type) && o.doc.equals(this.doc) && o.docLevel.equals((Object)this.docLevel) && FlagDescription.nullSafeEquals(o.altName, this.altName) && o.isDeprecated == this.isDeprecated;
    }

    public int hashCode() {
        return this.getLongFlagName().hashCode();
    }

    @Override
    public int compareTo(FlagDescription o) {
        return this.getLongFlagName().compareTo(o.getLongFlagName());
    }

    private static int findLastDotIndex(String name) {
        int idx = name.lastIndexOf(".");
        if (idx <= 0) {
            throw new IllegalArgumentException("Package name required in name: " + name);
        }
        return idx;
    }

    private static boolean nullSafeEquals(@Nullable Object left, @Nullable Object right) {
        return left == null ? left == right : left.equals(right);
    }

    private static @Nullable String emptyStringToNull(@Nullable String string) {
        return string == null || string.isEmpty() ? null : string;
    }

    @CanIgnoreReturnValue
    static <T> T checkNotNull(@Nullable T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return o;
    }

    static <T> void checkNotNull(T ... os) {
        for (T o : os) {
            if (o != null) continue;
            throw new NullPointerException();
        }
    }

    @CanIgnoreReturnValue
    static <T> T checkNotNull(@Nullable T o, String message) {
        if (o == null) {
            throw new NullPointerException(message);
        }
        return o;
    }

    @CanIgnoreReturnValue
    static <T> T checkStateNotNull(@Nullable T o) {
        if (o == null) {
            throw new IllegalStateException();
        }
        return o;
    }

    static class Builder {
        private final String containerClassName;
        private final @Nullable String simpleFieldName;
        private final String shortFlagName;
        private @Nullable String type;
        private @Nullable String doc;
        private @Nullable DocLevel docLevel;
        private @Nullable String altName;
        private boolean isDeprecated;

        private Builder(String containerClassName, @Nullable String simpleFieldName, String shortFlagName) {
            this.containerClassName = containerClassName;
            this.simpleFieldName = simpleFieldName;
            this.shortFlagName = shortFlagName;
        }

        Builder type(String type) {
            this.type = FlagDescription.checkNotNull(type);
            return this;
        }

        Builder doc(String doc) {
            this.doc = FlagDescription.checkNotNull(doc);
            return this;
        }

        Builder altName(@Nullable String altName) {
            this.altName = altName;
            return this;
        }

        Builder docLevel(DocLevel docLevel) {
            this.docLevel = FlagDescription.checkNotNull(docLevel);
            return this;
        }

        Builder isDeprecated(boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        FlagDescription build() {
            return new FlagDescription(this.shortFlagName, this.containerClassName, this.simpleFieldName, FlagDescription.checkStateNotNull(this.type), FlagDescription.checkStateNotNull(this.doc), FlagDescription.checkStateNotNull(this.docLevel), this.altName, this.isDeprecated);
        }
    }
}

