/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.protocol;

import com.google.io.protocol.ExtendableProtocolMessage;
import com.google.io.protocol.MessageSet;
import com.google.io.protocol.ProtoString;
import com.google.io.protocol.Protocol;
import com.google.io.protocol.ProtocolMessage;
import com.google.io.protocol.ProtocolSupport;
import com.google.io.protocol.ProtocolType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMutableMessage;
import com.google.protobuf.Extension;
import com.google.protobuf.Message;
import com.google.protobuf.MutableMessage;
import com.google.protobuf.WireFormat;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public final class Extensions {
    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Boolean> newBooleanExtension(int wireTag, boolean defaultValue) {
        return new BooleanExtension(wireTag, defaultValue, null);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Integer> newIntegerExtension(int wireTag, int defaultValue) {
        return new IntegerExtension(wireTag, defaultValue, null);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Integer> newFixedIntegerExtension(int wireTag, int defaultValue) {
        return new FixedIntegerExtension(wireTag, defaultValue, null);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Long> newLongExtension(int wireTag, long defaultValue) {
        return new LongExtension(wireTag, defaultValue, null);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Long> newFixedLongExtension(int wireTag, long defaultValue) {
        return new FixedLongExtension(wireTag, defaultValue, null);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Float> newFloatExtension(int wireTag, float defaultValue) {
        return new FloatExtension(wireTag, Float.valueOf(defaultValue), null);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Double> newDoubleExtension(int wireTag, double defaultValue) {
        return new DoubleExtension(wireTag, defaultValue, null);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, ProtoString> newStringExtension(int wireTag, ProtoString defaultValue) {
        return new StringExtension(wireTag, defaultValue, null);
    }

    public static <E extends ExtendableProtocolMessage<E>, P extends ProtocolMessage<P>> com.google.protobuf.Extension<E, P> newMessageExtension(int wireTag, P defaultValue) {
        return new MessageExtension(wireTag, defaultValue, null);
    }

    public static <E extends ExtendableProtocolMessage<E>, P extends MutableMessage> com.google.protobuf.Extension<E, P> newProto2MutableMessageExtension(int wireTag, P defaultValue) {
        return new Proto2MutableMessageExtension(wireTag, defaultValue, null);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Boolean> newBooleanExtension(int wireTag, boolean defaultValue, ExtensionDescriptorLoader loader) {
        return new BooleanExtension(wireTag, defaultValue, loader);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Integer> newIntegerExtension(int wireTag, int defaultValue, ExtensionDescriptorLoader loader) {
        return new IntegerExtension(wireTag, defaultValue, loader);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Integer> newFixedIntegerExtension(int wireTag, int defaultValue, ExtensionDescriptorLoader loader) {
        return new FixedIntegerExtension(wireTag, defaultValue, loader);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Long> newLongExtension(int wireTag, long defaultValue, ExtensionDescriptorLoader loader) {
        return new LongExtension(wireTag, defaultValue, loader);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Long> newFixedLongExtension(int wireTag, long defaultValue, ExtensionDescriptorLoader loader) {
        return new FixedLongExtension(wireTag, defaultValue, loader);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Float> newFloatExtension(int wireTag, float defaultValue, ExtensionDescriptorLoader loader) {
        return new FloatExtension(wireTag, Float.valueOf(defaultValue), loader);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, Double> newDoubleExtension(int wireTag, double defaultValue, ExtensionDescriptorLoader loader) {
        return new DoubleExtension(wireTag, defaultValue, loader);
    }

    public static <E extends ExtendableProtocolMessage<E>> com.google.protobuf.Extension<E, ProtoString> newStringExtension(int wireTag, ProtoString defaultValue, ExtensionDescriptorLoader loader) {
        return new StringExtension(wireTag, defaultValue, loader);
    }

    public static <E extends ExtendableProtocolMessage<E>, P extends ProtocolMessage<P>> com.google.protobuf.Extension<E, P> newMessageExtension(int wireTag, P defaultValue, ExtensionDescriptorLoader loader) {
        return new MessageExtension(wireTag, defaultValue, loader);
    }

    public static <E extends ExtendableProtocolMessage<E>, P extends MutableMessage> com.google.protobuf.Extension<E, P> newProto2MutableMessageExtension(int wireTag, P defaultValue, ExtensionDescriptorLoader loader) {
        return new Proto2MutableMessageExtension(wireTag, defaultValue, loader);
    }

    public static <E extends ExtendableProtocolMessage<E>, T> com.google.protobuf.Extension<E, List<T>> newRepeatedExtension(com.google.protobuf.Extension<E, T> ext) {
        if (ext instanceof Extension) {
            return new RepeatedExtension((Extension)ext);
        }
        throw new UnsupportedOperationException("Cannot create repeated extension on none-proto1 extensions");
    }

    public static <T extends Message> com.google.protobuf.Extension<MessageSet, T> newMessageSetExtension(int typeId, T defaultValue) {
        return new MessageSetExtension<T>(typeId, defaultValue);
    }

    public static ExtensionDescriptorLoader newMessageScopedExtensionDescriptorLoader(final MutableMessage defaultInstance, final String extensionName) {
        return new AbstractDescriptorLoader(){

            @Override
            public Descriptors.FieldDescriptor loadExtensionDescriptor() {
                return defaultInstance.getDescriptorForType().findFieldByName(extensionName);
            }
        };
    }

    public static ExtensionDescriptorLoader newFileScopedExtensionDescriptorLoader(final Class messageClass, final String descriptorOuterClass, final String extensionName) {
        return new AbstractDescriptorLoader(){

            @Override
            public Descriptors.FieldDescriptor loadExtensionDescriptor() {
                try {
                    Class<?> clazz = messageClass.getClassLoader().loadClass(descriptorOuterClass);
                    Descriptors.FileDescriptor file = (Descriptors.FileDescriptor)clazz.getField("descriptor").get(null);
                    return file.findExtensionByName(extensionName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot load descriptors: " + descriptorOuterClass + " is not a valid descriptor class name", e);
                }
            }
        };
    }

    private static com.google.protobuf.Extension newSingularExtensionForField(Descriptors.FieldDescriptor field, Object defaultValue, int wireTag, ExtensionDescriptorLoader loader) {
        switch (field.getType()) {
            case BOOL: {
                return new BooleanExtension(wireTag, (Boolean)(defaultValue == null ? Boolean.valueOf(false) : defaultValue), loader);
            }
            case ENUM: 
            case INT32: {
                return new IntegerExtension(wireTag, (Integer)(defaultValue == null ? Integer.valueOf(0) : defaultValue), loader);
            }
            case INT64: 
            case UINT64: 
            case UINT32: 
            case SINT32: 
            case SINT64: {
                return new LongExtension(wireTag, (Long)(defaultValue == null ? Long.valueOf(0L) : defaultValue), loader);
            }
            case FIXED32: 
            case SFIXED32: {
                return new FixedIntegerExtension(wireTag, (Integer)(defaultValue == null ? Integer.valueOf(0) : defaultValue), loader);
            }
            case FIXED64: 
            case SFIXED64: {
                return new FixedLongExtension(wireTag, (Long)(defaultValue == null ? Long.valueOf(0L) : defaultValue), loader);
            }
            case FLOAT: {
                return new FloatExtension(wireTag, (Float)(defaultValue == null ? Float.valueOf(0.0f) : defaultValue), loader);
            }
            case DOUBLE: {
                return new DoubleExtension(wireTag, (Double)(defaultValue == null ? Double.valueOf(0.0) : defaultValue), loader);
            }
            case BYTES: 
            case STRING: {
                return new StringExtension(wireTag, defaultValue == null ? ProtocolSupport.EMPTY_PROTO_STRING : new ProtoString((byte[])defaultValue), loader);
            }
            case MESSAGE: 
            case GROUP: {
                DynamicMutableMessage defaultInstance = DynamicMutableMessage.getDefaultInstance(field.getMessageType());
                return new Proto2MutableMessageExtension(wireTag, defaultInstance, loader);
            }
        }
        throw new RuntimeException("Unknown extension type: " + (Object)((Object)field.getType()));
    }

    static com.google.protobuf.Extension newExtensionForField(final Descriptors.FieldDescriptor field) {
        int wireTag = Protocol.makeTagWord(field.getNumber(), field.getLiteType().getWireType());
        ExtensionDescriptorLoader loader = new ExtensionDescriptorLoader(){

            @Override
            public Descriptors.FieldDescriptor getExtensionDescriptor() {
                return field;
            }
        };
        if (field.isRepeated()) {
            if (field.isPacked()) {
                return new StringExtension(wireTag, ProtocolSupport.EMPTY_PROTO_STRING, loader);
            }
            return Extensions.newRepeatedExtension(Extensions.newSingularExtensionForField(field, null, wireTag, loader));
        }
        Object defaultValue = null;
        if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            defaultValue = ProtocolType.convertFromProto2Reflection(field, field.getDefaultValue());
        }
        return Extensions.newSingularExtensionForField(field, defaultValue, wireTag, loader);
    }

    static int getWireTag(com.google.protobuf.Extension ext) {
        return Protocol.makeTagWord(ext.getNumber(), ext.getLiteType().getWireType());
    }

    private static abstract class AbstractDescriptorLoader
    implements ExtensionDescriptorLoader {
        private volatile Descriptors.FieldDescriptor descriptor;

        private AbstractDescriptorLoader() {
        }

        protected abstract Descriptors.FieldDescriptor loadExtensionDescriptor();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Descriptors.FieldDescriptor getExtensionDescriptor() {
            if (this.descriptor == null) {
                AbstractDescriptorLoader abstractDescriptorLoader = this;
                synchronized (abstractDescriptorLoader) {
                    if (this.descriptor == null) {
                        this.descriptor = this.loadExtensionDescriptor();
                    }
                }
            }
            return this.descriptor;
        }
    }

    public static interface ExtensionDescriptorLoader {
        public Descriptors.FieldDescriptor getExtensionDescriptor();
    }

    public static class LazyParsingException
    extends RuntimeException {
        public LazyParsingException(String s) {
            super(s);
        }
    }

    private static final class MessageSetExtension<T extends Message>
    extends com.google.protobuf.Extension<MessageSet, T> {
        private final int typeId;
        private final T defaultInstance;

        protected MessageSetExtension(int typeId, T defaultInstance) {
            this.typeId = typeId;
            this.defaultInstance = defaultInstance;
        }

        @Override
        public int getNumber() {
            return this.typeId;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.MESSAGE;
        }

        @Override
        public boolean isRepeated() {
            return false;
        }

        @Override
        public Descriptors.FieldDescriptor getDescriptor() {
            throw new UnsupportedOperationException("Proto1 extension does not yet support descriptors.");
        }

        @Override
        public T getDefaultValue() {
            return this.defaultInstance;
        }

        @Override
        public Message getMessageDefaultInstance() {
            return this.defaultInstance;
        }

        @Override
        protected Extension.ExtensionType getExtensionType() {
            return Extension.ExtensionType.PROTO1;
        }

        @Override
        protected Object fromReflectionType(Object value) {
            throw new UnsupportedOperationException("Cannot use Proto1 extension for Proto2 container messages.");
        }

        @Override
        protected Object singularFromReflectionType(Object value) {
            throw new UnsupportedOperationException("Cannot use Proto1 extension for Proto2 container messages.");
        }

        @Override
        protected Object toReflectionType(Object value) {
            throw new UnsupportedOperationException("Cannot use Proto1 extension for Proto2 container messages.");
        }

        @Override
        protected Object singularToReflectionType(Object value) {
            throw new UnsupportedOperationException("Cannot use Proto1 extension for Proto2 container messages.");
        }
    }

    private static final class RepeatedExtension<E extends ExtendableProtocolMessage<E>, T>
    extends Extension<E, List<T>> {
        private final Extension<E, T> unitExtension;

        protected RepeatedExtension(final Extension<E, T> unitExtension) {
            super(new ExtensionDescriptorLoader(){

                @Override
                public Descriptors.FieldDescriptor getExtensionDescriptor() {
                    return unitExtension.getDescriptor();
                }
            });
            this.unitExtension = unitExtension;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return this.unitExtension.getLiteType();
        }

        @Override
        public boolean isRepeated() {
            return true;
        }

        @Override
        public Message getMessageDefaultInstance() {
            return this.unitExtension.getMessageDefaultInstance();
        }

        @Override
        protected int getWireTag() {
            return this.unitExtension.getWireTag();
        }

        @Override
        public final List<T> getDefaultValue() {
            return Collections.emptyList();
        }

        @Override
        public final Extension.MessageType getMessageType() {
            return this.unitExtension.getMessageType();
        }
    }

    private static final class Proto2MutableMessageExtension<E extends ExtendableProtocolMessage<E>, P extends MutableMessage>
    extends Extension<E, P> {
        private final int wireTag;
        private final P defaultInstance;

        public Proto2MutableMessageExtension(int wireTag, P defaultInstance, ExtensionDescriptorLoader descriptorLoader) {
            super(descriptorLoader);
            this.wireTag = wireTag;
            this.defaultInstance = defaultInstance;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.MESSAGE;
        }

        @Override
        public Message getMessageDefaultInstance() {
            return this.defaultInstance.getDefaultInstanceForType();
        }

        @Override
        protected int getWireTag() {
            return this.wireTag;
        }

        @Override
        public P getDefaultValue() {
            return (P)this.defaultInstance.getDefaultInstanceForType();
        }

        @Override
        public Extension.MessageType getMessageType() {
            return Extension.MessageType.PROTO2;
        }
    }

    private static final class MessageExtension<E extends ExtendableProtocolMessage<E>, P extends ProtocolMessage<P>>
    extends Extension<E, P> {
        private final int wireTag;
        private final P defaultInstance;

        public MessageExtension(int wireTag, P defaultInstance, ExtensionDescriptorLoader descriptorLoader) {
            super(descriptorLoader);
            this.wireTag = wireTag;
            this.defaultInstance = defaultInstance;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.MESSAGE;
        }

        @Override
        public Message getMessageDefaultInstance() {
            return ((ProtocolMessage)this.defaultInstance).getDefaultInstanceForType();
        }

        @Override
        protected int getWireTag() {
            return this.wireTag;
        }

        @Override
        public final P getDefaultValue() {
            return (P)((ProtocolMessage)this.defaultInstance).getDefaultInstanceForType();
        }

        @Override
        public Extension.MessageType getMessageType() {
            return Extension.MessageType.PROTO1;
        }
    }

    private static final class StringExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, ProtoString> {
        public StringExtension(int wireTag, ProtoString defaultValue, ExtensionDescriptorLoader descriptorLoader) {
            super(wireTag, defaultValue, descriptorLoader);
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.BYTES;
        }
    }

    private static final class DoubleExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Double> {
        public DoubleExtension(int wireTag, Double defaultValue, ExtensionDescriptorLoader descriptorLoader) {
            super(wireTag, defaultValue, descriptorLoader);
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.DOUBLE;
        }
    }

    private static final class FloatExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Float> {
        public FloatExtension(int wireTag, Float defaultValue, ExtensionDescriptorLoader descriptorLoader) {
            super(wireTag, defaultValue, descriptorLoader);
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.FLOAT;
        }
    }

    private static final class FixedLongExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Long> {
        public FixedLongExtension(int wireTag, Long defaultValue, ExtensionDescriptorLoader descriptorLoader) {
            super(wireTag, defaultValue, descriptorLoader);
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.FIXED64;
        }
    }

    private static final class LongExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Long> {
        public LongExtension(int wireTag, Long defaultValue, ExtensionDescriptorLoader descriptorLoader) {
            super(wireTag, defaultValue, descriptorLoader);
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.INT64;
        }
    }

    private static final class FixedIntegerExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Integer> {
        public FixedIntegerExtension(int wireTag, Integer defaultValue, ExtensionDescriptorLoader descriptorLoader) {
            super(wireTag, defaultValue, descriptorLoader);
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.FIXED32;
        }
    }

    private static final class IntegerExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Integer> {
        public IntegerExtension(int wireTag, Integer defaultValue, ExtensionDescriptorLoader descriptorLoader) {
            super(wireTag, defaultValue, descriptorLoader);
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.INT32;
        }
    }

    private static final class BooleanExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Boolean> {
        public BooleanExtension(int wireTag, Boolean defaultValue, ExtensionDescriptorLoader descriptorLoader) {
            super(wireTag, defaultValue, descriptorLoader);
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return WireFormat.FieldType.BOOL;
        }
    }

    private static abstract class PrimitiveExtension<E extends ExtendableProtocolMessage<E>, T>
    extends Extension<E, T> {
        protected final int wireTag;
        private final T defaultValue;

        private PrimitiveExtension(int wireTag, T defaultValue, ExtensionDescriptorLoader descriptorLoader) {
            super(descriptorLoader);
            this.wireTag = wireTag;
            this.defaultValue = defaultValue;
        }

        @Override
        protected int getWireTag() {
            return this.wireTag;
        }

        @Override
        public T getDefaultValue() {
            return this.defaultValue;
        }
    }

    private static abstract class Extension<E extends ExtendableProtocolMessage<E>, T>
    extends com.google.protobuf.Extension<E, T>
    implements Serializable {
        private ExtensionDescriptorLoader descriptorLoader;

        public Extension(ExtensionDescriptorLoader descriptorLoader) {
            this.descriptorLoader = descriptorLoader;
        }

        @Override
        public int getNumber() {
            return WireFormat.getTagFieldNumber(this.getWireTag());
        }

        @Override
        public abstract WireFormat.FieldType getLiteType();

        @Override
        public boolean isRepeated() {
            return false;
        }

        @Override
        public Descriptors.FieldDescriptor getDescriptor() {
            if (this.descriptorLoader == null) {
                throw new UnsupportedOperationException("Proto2 reflection is not supported for this extension.");
            }
            return this.descriptorLoader.getExtensionDescriptor();
        }

        @Override
        public Message getMessageDefaultInstance() {
            return null;
        }

        @Override
        protected Extension.ExtensionType getExtensionType() {
            return Extension.ExtensionType.PROTO1;
        }

        public final RepeatedExtension<E, T> asRepeated() {
            return new RepeatedExtension(this);
        }

        @Override
        protected Object fromReflectionType(Object value) {
            throw new UnsupportedOperationException("Cannot use Proto1 extension for Proto2 container messages.");
        }

        @Override
        protected Object singularFromReflectionType(Object value) {
            throw new UnsupportedOperationException("Cannot use Proto1 extension for Proto2 container messages.");
        }

        @Override
        protected Object toReflectionType(Object value) {
            throw new UnsupportedOperationException("Cannot use Proto1 extension for Proto2 container messages.");
        }

        @Override
        protected Object singularToReflectionType(Object value) {
            throw new UnsupportedOperationException("Cannot use Proto1 extension for Proto2 container messages.");
        }

        protected abstract int getWireTag();
    }
}

