/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MutableMessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;

public abstract class AbstractMutableMessageLite
implements MutableMessageLite {
    private boolean isMutable = true;
    protected int cachedSize = -1;

    protected void makeImmutable() {
        this.isMutable = false;
    }

    protected void assertMutable() {
        if (!this.isMutable) {
            throw new IllegalStateException("Try to modify an immutable message.");
        }
    }

    @Override
    public MessageLite.Builder toBuilder() {
        throw new UnsupportedOperationException("toBuilder() is not supported in mutable messages.");
    }

    @Override
    public MessageLite.Builder newBuilderForType() {
        throw new UnsupportedOperationException("newBuilderForType() is not supported in mutable messages.");
    }

    @Override
    public MutableMessageLite mutableCopy() {
        throw new UnsupportedOperationException("mutableCopy() is not supported in mutable messages. Use clone() if you need to make a copy of the mutable message.");
    }

    @Override
    public MutableMessageLite clone() {
        throw new UnsupportedOperationException("clone() should be implemented by subclasses.");
    }

    @Override
    public ByteString toByteString() {
        try {
            ByteString.CodedBuilder out = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(out.getCodedOutput());
            return out.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a ByteString threw an IOException (should never happen).", e);
        }
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] result = new byte[this.getSerializedSize()];
            CodedOutputStream output = CodedOutputStream.newInstance(result);
            this.writeTo(output);
            output.checkNoSpaceLeft();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        int bufferSize = CodedOutputStream.computePreferredBufferSize(this.getSerializedSize());
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, bufferSize);
        this.writeTo(codedOutput);
        codedOutput.flush();
    }

    @Override
    public void writeDelimitedTo(OutputStream output) throws IOException {
        int serialized = this.getSerializedSize();
        int bufferSize = CodedOutputStream.computePreferredBufferSize(CodedOutputStream.computeUInt32SizeNoTag(serialized) + serialized);
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, bufferSize);
        codedOutput.writeUInt32NoTag(serialized);
        this.writeTo(codedOutput);
        codedOutput.flush();
    }

    UninitializedMessageException newUninitializedMessageException() {
        return new UninitializedMessageException(this);
    }

    @Override
    public final int getCachedSize() {
        return this.cachedSize;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int unused = this.getSerializedSize();
        this.writeToWithCachedSizes(output);
    }

    @Override
    public boolean mergeFrom(CodedInputStream input) {
        return this.mergeFrom(input, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public boolean mergeFrom(ByteString data) {
        CodedInputStream input = data.newCodedInput();
        return this.mergeFrom(input) && input.getLastTag() == 0;
    }

    @Override
    public boolean mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) {
        CodedInputStream input = data.newCodedInput();
        return this.mergeFrom(input, extensionRegistry) && input.getLastTag() == 0;
    }

    @Override
    public boolean mergeFrom(byte[] data) {
        return this.mergeFrom(data, 0, data.length);
    }

    @Override
    public boolean mergeFrom(byte[] data, int off, int len) {
        CodedInputStream input = CodedInputStream.newInstance(data, off, len);
        return this.mergeFrom(input) && input.getLastTag() == 0;
    }

    @Override
    public boolean mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) {
        return this.mergeFrom(data, 0, data.length, extensionRegistry);
    }

    @Override
    public boolean mergeFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) {
        CodedInputStream input = CodedInputStream.newInstance(data, off, len);
        return this.mergeFrom(input, extensionRegistry) && input.getLastTag() == 0;
    }

    @Override
    public boolean mergeFrom(ByteBuffer data) {
        CodedInputStream input = CodedInputStream.newInstance(data);
        return this.mergeFrom(input) && input.getLastTag() == 0;
    }

    @Override
    public boolean mergeFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) {
        CodedInputStream input = CodedInputStream.newInstance(data);
        return this.mergeFrom(input, extensionRegistry) && input.getLastTag() == 0;
    }

    @Override
    public boolean mergeFrom(InputStream input) {
        CodedInputStream codedInput = CodedInputStream.newInstance(input);
        return this.mergeFrom(codedInput) && codedInput.getLastTag() == 0;
    }

    @Override
    public boolean mergeFrom(InputStream input, ExtensionRegistryLite extensionRegistry) {
        CodedInputStream codedInput = CodedInputStream.newInstance(input);
        return this.mergeFrom(codedInput, extensionRegistry) && codedInput.getLastTag() == 0;
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream input) {
        return this.mergeDelimitedFrom(input, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) {
        try {
            int firstByte = input.read();
            if (firstByte == -1) {
                return false;
            }
            int size = CodedInputStream.readRawVarint32(firstByte, input);
            AbstractMessageLite.Builder.LimitedInputStream limitedInput = new AbstractMessageLite.Builder.LimitedInputStream(input, size);
            return this.mergeFrom(limitedInput, extensionRegistry);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean parseFrom(CodedInputStream input) {
        this.clear();
        return this.mergeFrom(input);
    }

    public boolean parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) {
        this.clear();
        return this.mergeFrom(input, extensionRegistry);
    }

    @Override
    public boolean parseFrom(ByteString data) {
        this.clear();
        return this.mergeFrom(data);
    }

    @Override
    public boolean parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) {
        this.clear();
        return this.mergeFrom(data, extensionRegistry);
    }

    @Override
    public boolean parseFrom(byte[] data) {
        this.clear();
        return this.mergeFrom(data, 0, data.length);
    }

    @Override
    public boolean parseFrom(byte[] data, int off, int len) {
        this.clear();
        return this.mergeFrom(data, off, len);
    }

    @Override
    public boolean parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) {
        this.clear();
        return this.mergeFrom(data, 0, data.length, extensionRegistry);
    }

    @Override
    public boolean parseFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) {
        this.clear();
        return this.mergeFrom(data, off, len, extensionRegistry);
    }

    @Override
    public boolean parseFrom(ByteBuffer data) {
        this.clear();
        return this.mergeFrom(data);
    }

    @Override
    public boolean parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) {
        this.clear();
        return this.mergeFrom(data, extensionRegistry);
    }

    @Override
    public boolean parseFrom(InputStream input) {
        this.clear();
        return this.mergeFrom(input);
    }

    @Override
    public boolean parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) {
        this.clear();
        return this.mergeFrom(input, extensionRegistry);
    }

    @Override
    public boolean parseDelimitedFrom(InputStream input) {
        this.clear();
        return this.mergeDelimitedFrom(input);
    }

    @Override
    public boolean parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) {
        this.clear();
        return this.mergeDelimitedFrom(input, extensionRegistry);
    }

    protected static UninitializedMessageException newUninitializedMessageException(MessageLite message) {
        return new UninitializedMessageException(message);
    }

    protected static <T extends MutableMessageLite> Parser<T> internalNewParserForType(final T defaultInstance) {
        return new AbstractParser<T>(){

            @Override
            public T parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                MutableMessageLite message = defaultInstance.newMessageForType();
                if (!message.mergeFrom(input, extensionRegistry)) {
                    throw InvalidProtocolBufferException.parseFailure().setUnfinishedMessage(message);
                }
                return message;
            }
        };
    }

    protected static <T> void addAll(Iterable<T> values, Collection<? super T> list) {
        AbstractMessageLite.Builder.addAll(values, list);
    }

    protected boolean isProto1Group() {
        return false;
    }
}

