/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Extension;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class MemoizingExtensionRegistry
extends ExtensionRegistry {
    private final ExtensionRegistry delegate;
    private final Map<String, ExtensionInfoOrNull> immutableExtensionsByName = new ConcurrentHashMap<String, ExtensionInfoOrNull>();
    private final Map<String, ExtensionInfoOrNull> mutableExtensionsByName = new ConcurrentHashMap<String, ExtensionInfoOrNull>();
    private final Map<DescriptorIntPair, ExtensionInfoOrNull> immutableExtensionsByNumber = new ConcurrentHashMap<DescriptorIntPair, ExtensionInfoOrNull>();
    private final Map<DescriptorIntPair, ExtensionInfoOrNull> mutableExtensionsByNumber = new ConcurrentHashMap<DescriptorIntPair, ExtensionInfoOrNull>();

    MemoizingExtensionRegistry(ExtensionRegistry delegate) {
        super(true);
        this.delegate = delegate;
    }

    @Override
    public ExtensionRegistry getUnmodifiable() {
        return this;
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findImmutableExtensionByName(String fullName) {
        ExtensionInfoOrNull cachedResult = this.immutableExtensionsByName.get(fullName);
        if (cachedResult != null) {
            return cachedResult.info;
        }
        ExtensionRegistry.ExtensionInfo result = this.delegate.findImmutableExtensionByName(fullName);
        this.immutableExtensionsByName.put(fullName, new ExtensionInfoOrNull(result));
        return result;
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findMutableExtensionByName(String fullName) {
        ExtensionInfoOrNull cachedResult = this.mutableExtensionsByName.get(fullName);
        if (cachedResult != null) {
            return cachedResult.info;
        }
        ExtensionRegistry.ExtensionInfo result = this.delegate.findMutableExtensionByName(fullName);
        this.mutableExtensionsByName.put(fullName, new ExtensionInfoOrNull(result));
        return result;
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findImmutableExtensionByNumber(Descriptors.Descriptor containingType, int fieldNumber) {
        DescriptorIntPair key = new DescriptorIntPair(containingType, fieldNumber);
        ExtensionInfoOrNull cachedResult = this.immutableExtensionsByNumber.get(key);
        if (cachedResult != null) {
            return cachedResult.info;
        }
        ExtensionRegistry.ExtensionInfo result = this.delegate.findImmutableExtensionByNumber(containingType, fieldNumber);
        this.immutableExtensionsByNumber.put(key, new ExtensionInfoOrNull(result));
        return result;
    }

    @Override
    public ExtensionRegistry.ExtensionInfo findMutableExtensionByNumber(Descriptors.Descriptor containingType, int fieldNumber) {
        DescriptorIntPair key = new DescriptorIntPair(containingType, fieldNumber);
        ExtensionInfoOrNull cachedResult = this.mutableExtensionsByNumber.get(key);
        if (cachedResult != null) {
            return cachedResult.info;
        }
        ExtensionRegistry.ExtensionInfo result = this.delegate.findMutableExtensionByNumber(containingType, fieldNumber);
        this.mutableExtensionsByNumber.put(key, new ExtensionInfoOrNull(result));
        return result;
    }

    @Override
    public Set<ExtensionRegistry.ExtensionInfo> getAllImmutableExtensionsByExtendedType(String fullName) {
        return this.delegate.getAllImmutableExtensionsByExtendedType(fullName);
    }

    @Override
    public Set<ExtensionRegistry.ExtensionInfo> getAllMutableExtensionsByExtendedType(String fullName) {
        return this.delegate.getAllMutableExtensionsByExtendedType(fullName);
    }

    @Override
    public void add(Extension<?, ?> extension) {
        throw MemoizingExtensionRegistry.newUnsupported();
    }

    @Override
    public void add(Descriptors.FieldDescriptor type) {
        throw MemoizingExtensionRegistry.newUnsupported();
    }

    @Override
    public void add(Descriptors.FieldDescriptor type, Message defaultInstance) {
        throw MemoizingExtensionRegistry.newUnsupported();
    }

    @Override
    public <ContainingType extends MessageLite> GeneratedMessageLite.GeneratedExtension<ContainingType, ?> findLiteExtensionByNumber(ContainingType containingTypeDefaultInstance, int fieldNumber) {
        throw new UnsupportedOperationException("MemoizingExtensionRegistry does not work for Lite extensions.");
    }

    private static UnsupportedOperationException newUnsupported() {
        return new UnsupportedOperationException("MemoizingExtensionRegistry cannot be modified");
    }

    private static final class DescriptorIntPair {
        private final Descriptors.Descriptor descriptor;
        private final int number;

        DescriptorIntPair(Descriptors.Descriptor descriptor, int number) {
            this.descriptor = descriptor;
            this.number = number;
        }

        public int hashCode() {
            return this.descriptor.hashCode() * 65535 + this.number;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescriptorIntPair)) {
                return false;
            }
            DescriptorIntPair other = (DescriptorIntPair)obj;
            return this.descriptor == other.descriptor && this.number == other.number;
        }
    }

    private static final class ExtensionInfoOrNull {
        private final ExtensionRegistry.ExtensionInfo info;

        ExtensionInfoOrNull(ExtensionRegistry.ExtensionInfo info) {
            this.info = info;
        }
    }
}

