/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMetadataProto;
import com.google.protobuf.InternalProtobufMeta;
import com.google.protobuf.Message;
import com.google.protobuf.MutableMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageFactories {
    private static final Logger logger = Logger.getLogger(MessageFactories.class.getName());

    public static ImmutableMessageFactory getImmutableMessageFactory() {
        return ImmutableGeneratedMessageFactory.getInstance();
    }

    public static MutableMessageFactory getMutableMessageFactory() {
        return MutableGeneratedMessageFactory.getInstance();
    }

    static Descriptors.Descriptor getDescriptorByName(String fullName) {
        LazyGeneratedMessageDefaultInstance lazyMessage = (LazyGeneratedMessageDefaultInstance)ImmutableGeneratedMessageFactory.instance.messageByName.get(fullName);
        if (lazyMessage == null) {
            lazyMessage = (LazyGeneratedMessageDefaultInstance)MutableGeneratedMessageFactory.instance.messageByName.get(fullName);
        }
        if (lazyMessage != null) {
            return lazyMessage.getDefaultInstance().getDescriptorForType();
        }
        return null;
    }

    private static Message getPrototypeFromMap(Descriptors.Descriptor type, Map<String, LazyGeneratedMessageDefaultInstance> map) {
        String name = type.getFullName();
        LazyGeneratedMessageDefaultInstance lazyDefaultInstance = map.get(name);
        if (lazyDefaultInstance == null) {
            return null;
        }
        Message defaultInstance = lazyDefaultInstance.getDefaultInstance();
        if (defaultInstance.getDescriptorForType() != type) {
            logger.logp(Level.WARNING, "com.google.protobuf.MessageFactories", "getPrototypeFromMap", "The descriptor doesn't match with the generated message descriptor with the same name.");
            return null;
        }
        return defaultInstance;
    }

    private static void loadMetadata(Map<String, LazyGeneratedMessageDefaultInstance> map, boolean immutable) {
        for (GeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry message : InternalProtobufMeta.getInstance().getMessages()) {
            MessageFactories.add(message, map, immutable);
        }
    }

    private static void add(GeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry entry, Map<String, LazyGeneratedMessageDefaultInstance> map, boolean immutable) {
        LazyGeneratedMessageDefaultInstance lazyDefaultInstance = new LazyGeneratedMessageDefaultInstance(entry.getLoadPathBytes());
        String name = entry.getName();
        if (entry.getImmutable() == immutable) {
            map.put(name, lazyDefaultInstance);
        }
    }

    private static final class LazyGeneratedMessageDefaultInstance {
        private ByteString loadPath;
        private volatile Message defaultInstance = null;

        public LazyGeneratedMessageDefaultInstance(ByteString loadPath) {
            this.loadPath = loadPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message getDefaultInstance() {
            if (this.defaultInstance == null) {
                LazyGeneratedMessageDefaultInstance lazyGeneratedMessageDefaultInstance = this;
                synchronized (lazyGeneratedMessageDefaultInstance) {
                    if (this.defaultInstance == null) {
                        this.loadDefaultInstance();
                    }
                }
            }
            return this.defaultInstance;
        }

        private void loadDefaultInstance() {
            String stringLoadPath = this.loadPath.toStringUtf8();
            try {
                Class<?> clazz = Class.forName(stringLoadPath);
                Method method = clazz.getDeclaredMethod("getDefaultInstance", new Class[0]);
                this.defaultInstance = (Message)method.invoke(null, new Object[0]);
                this.loadPath = null;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to load the class for the message at the load path: " + stringLoadPath, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to find getDefaultInstance() method.", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Failed to call getDefaultInstance() method.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to access getDefaultInstance() method.", e);
            }
        }
    }

    private static class MutableGeneratedMessageFactory
    implements MutableMessageFactory {
        private static final MutableGeneratedMessageFactory instance = new MutableGeneratedMessageFactory();
        private final Map<String, LazyGeneratedMessageDefaultInstance> messageByName = new HashMap<String, LazyGeneratedMessageDefaultInstance>();

        public static MutableMessageFactory getInstance() {
            return instance;
        }

        private MutableGeneratedMessageFactory() {
            MessageFactories.loadMetadata(this.messageByName, false);
        }

        @Override
        public MutableMessage getPrototype(Descriptors.Descriptor type) {
            return (MutableMessage)MessageFactories.getPrototypeFromMap(type, this.messageByName);
        }
    }

    private static class ImmutableGeneratedMessageFactory
    implements ImmutableMessageFactory {
        private static final ImmutableGeneratedMessageFactory instance = new ImmutableGeneratedMessageFactory();
        private final Map<String, LazyGeneratedMessageDefaultInstance> messageByName = new HashMap<String, LazyGeneratedMessageDefaultInstance>();

        public static ImmutableMessageFactory getInstance() {
            return instance;
        }

        private ImmutableGeneratedMessageFactory() {
            MessageFactories.loadMetadata(this.messageByName, true);
        }

        @Override
        public Message getPrototype(Descriptors.Descriptor type) {
            return MessageFactories.getPrototypeFromMap(type, this.messageByName);
        }
    }

    public static interface MutableMessageFactory {
        public MutableMessage getPrototype(Descriptors.Descriptor var1);
    }

    public static interface ImmutableMessageFactory {
        public Message getPrototype(Descriptors.Descriptor var1);
    }
}

