/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags;

import com.google.common.flags.FlagDescription;
import com.google.common.flags.FlagException;
import com.google.common.flags.FlagInfo;
import com.google.common.flags.Flags;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public final class UnrecognizedFlagException
extends FlagException {
    private static final long serialVersionUID = 43980234589L;
    private final List<String> flagNames;

    public UnrecognizedFlagException(String ... flagNames) {
        this(Arrays.asList(flagNames));
    }

    public UnrecognizedFlagException(List<String> flagNames) {
        super(String.format("Unrecognized flag(s): %s - if this is unexpected make sure you are (directly or indirectly) depending on the class that declares the flag", UnrecognizedFlagException.listToString(FlagDescription.checkNotNull(flagNames))));
        this.flagNames = flagNames;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(Objects.requireNonNull(super.getMessage()));
        for (String unrecognizedFlag : this.flagNames) {
            String candidateFlag = UnrecognizedFlagException.findCandidateFlag(unrecognizedFlag);
            if (candidateFlag == null) continue;
            sb.append("\n  Did you mean '").append(candidateFlag).append("'?");
        }
        return sb.toString();
    }

    private static @Nullable String findCandidateFlag(String unrecognizedFlagName) {
        for (FlagInfo flag : Flags.allFlags()) {
            if (!flag.shortFlagName().equals(unrecognizedFlagName)) continue;
            return "--" + flag.longFlagName();
        }
        return null;
    }

    private static String listToString(List<String> ls) {
        String str = ls.toString();
        return str.substring(1, str.length() - 1);
    }
}

