/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class InputStreamSink {
    private static final byte[] DISCARD = new byte[4096];

    private InputStreamSink() {
    }

    public static Runnable newRunnableSink(InputStream in) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        return new NullSink(in);
    }

    public static Runnable newRunnableSink(InputStream in, OutputStream out) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (out == null) {
            throw new NullPointerException("out");
        }
        return new CopySink(in, out);
    }

    public static Thread newSink(InputStream in) {
        Thread sink = new Thread(InputStreamSink.newRunnableSink(in));
        sink.start();
        return sink;
    }

    public static Thread newSink(InputStream in, OutputStream out) {
        Thread sink = new Thread(InputStreamSink.newRunnableSink(in, out));
        sink.start();
        return sink;
    }

    private static class NullSink
    implements Runnable {
        private final InputStream in;

        public NullSink(InputStream in) {
            this.in = in;
        }

        @Override
        public void run() {
            try {
                try {
                    do {
                        this.in.skip(Integer.MAX_VALUE);
                    } while (this.in.read() != -1);
                }
                catch (IOException ioe) {
                    while (this.in.read(DISCARD) != -1) {
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class CopySink
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        public CopySink(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int bytesRead;
                byte[] buffer = new byte[2048];
                while ((bytesRead = this.in.read(buffer)) >= 0) {
                    this.out.write(buffer, 0, bytesRead);
                    this.out.flush();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

