/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.base;

public final class PerThreadByteCounter {
    private final ByteCounter sendByteCounter = new ByteCounter();
    private final ByteCounter receiveByteCounter = new ByteCounter();

    public long getBytesSent() {
        return ((LongWrapper)this.sendByteCounter.get()).value;
    }

    public long getBytesReceived() {
        return ((LongWrapper)this.receiveByteCounter.get()).value;
    }

    public void incBytesSent(long sent) {
        ((LongWrapper)this.sendByteCounter.get()).value += sent;
    }

    public void incBytesReceived(long received) {
        ((LongWrapper)this.receiveByteCounter.get()).value += received;
    }

    public void reset() {
        this.sendByteCounter.remove();
        this.receiveByteCounter.remove();
    }

    private static class ByteCounter
    extends ThreadLocal<LongWrapper> {
        private ByteCounter() {
        }

        @Override
        protected LongWrapper initialValue() {
            return new LongWrapper();
        }
    }

    private static class LongWrapper {
        long value;

        private LongWrapper() {
        }
    }
}

