/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.protocol;

import com.google.common.base.Ascii;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedLongs;
import com.google.errorprone.annotations.FormatMethod;
import com.google.io.protocol.CategoryInformation;
import com.google.io.protocol.GrowableProtocolSink;
import com.google.io.protocol.MessageSet;
import com.google.io.protocol.ProtocolMessage;
import com.google.io.protocol.ProtocolMessageEnum;
import com.google.io.protocol.ProtocolSupport;
import com.google.io.protocol.ProtocolType;
import com.google.io.protocol.RawMessage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProtocolTextParser {
    private static final Logger logger = Logger.getLogger(ProtocolTextParser.class.getName());
    private static final Pattern PATTERN_LBRACE = Pattern.compile("\\{");
    private static final Pattern PATTERN_LSQUARE = Pattern.compile("\\[");
    private static final Pattern PATTERN_LANGLE_OR_LBRACE = Pattern.compile("[\\<\\{]");
    private static final Pattern PATTERN_RBRACE = Pattern.compile("\\}");
    private static final Pattern PATTERN_RSQUARE = Pattern.compile("\\]");
    private static final Pattern PATTERN_RANGLE = Pattern.compile("\\>");
    private static final Pattern PATTERN_OPTIONAL_INDEX = Pattern.compile("\\([0-9]+\\)");
    private static final Pattern PATTERN_SEPARATOR = Pattern.compile("[:=]");
    private static final Pattern PATTERN_COMMA = Pattern.compile(",");
    private static final Pattern PATTERN_ID = Pattern.compile("([a-zA-Z_]\\w*(\\.\\w+)*)");
    private static final Pattern PATTERN_CLASS_NAME = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_.]*)");
    private static final Pattern PATTERN_INT = Pattern.compile("(-?([1-9][0-9]*|0([xX][0-9a-fA-Z]+|[0-7]*)?))");
    private static final Pattern PATTERN_FLOAT = Pattern.compile("(-?[0-9]+(\\.[0-9]*)?([eE](-|\\+)?[0-9]+)?)[fF]?");
    private static final Pattern PATTERN_INFINITY = Pattern.compile("[-+]?inf(inity)?f?", 2);
    private static final Pattern PATTERN_NAN = Pattern.compile("[-+]?nanf?", 2);
    private static final Pattern PATTERN_DQUOTE = Pattern.compile("\"");
    private static final Pattern PATTERN_SIMPLE_STRING = Pattern.compile("([^\"\\\\]+)");
    private static final Pattern PATTERN_NEWLINE_TERMINATED_SIMPLE_STRING = Pattern.compile("([^\"\r\n\\\\]+)");
    private static final Pattern PATTERN_SINGLE_CHAR_ESCAPE_SEQ = Pattern.compile("(\\\\[bfnrt\"'\\\\]|\\\\u[0-9a-fA-F]{4})");
    private static final Pattern PATTERN_SINGLE_BYTE_ESCAPE_SEQ = Pattern.compile("(\\\\[0-7]{1,3}|\\\\x[0-9a-fA-F]+)");
    private static final Pattern PATTERN_TERMINATOR = Pattern.compile("[;,]");
    private static final Pattern PATTERN_END = Pattern.compile("$");
    private static final Pattern PATTERN_COMMENTS = Pattern.compile("(\\s|#.*\n)+");
    private static final Pattern PATTERN_NEWLINE = Pattern.compile("[\r\n]");
    private static final Pattern PATTERN_DOT = Pattern.compile("\\.");
    private static final Pattern PATTERN_TAG = Pattern.compile("(tag)?([0-9]+)");
    private final Scanner in;
    private final boolean ignoreUndefinedTags;
    private final boolean interpretOctOrHexEscapeAsByte;

    public static <T extends ProtocolMessage<? super T>> T parse(CharSequence sequence, Class<T> clazz) {
        return ProtocolTextParser.parse(sequence, ProtocolSupport.newInstance(clazz));
    }

    public static <T extends ProtocolMessage<? super T>> T parseCppCompatible(CharSequence sequence, Class<T> clazz) {
        return ProtocolTextParser.parse(sequence, ProtocolSupport.newInstance(clazz), false, true);
    }

    public static <T extends ProtocolMessage<T>> T parse(CharSequence sequence, Class<T> clazz, boolean ignoreUndefinedTags) {
        return ProtocolTextParser.parse(sequence, ProtocolSupport.newInstance(clazz), ignoreUndefinedTags);
    }

    public static <T extends ProtocolMessage<? super T>> T parse(CharSequence sequence, T instance) {
        return ProtocolTextParser.parse(sequence, instance, false);
    }

    public static <T extends ProtocolMessage<? super T>> T parse(CharSequence sequence, T instance, boolean ignoreUndefinedTags) {
        return ProtocolTextParser.parse(sequence, instance, ignoreUndefinedTags, false);
    }

    public static <T extends ProtocolMessage<? super T>> T parse(CharSequence sequence, T instance, boolean ignoreUndefinedTags, boolean interpretOctOrHexEscapeAsByte) {
        CategoryInformation<T> categoryInformation = instance.messageCategoryInformation();
        if (categoryInformation == null) {
            GrowableProtocolSink sink = new GrowableProtocolSink();
            new ProtocolTextParser(sequence, ignoreUndefinedTags, interpretOctOrHexEscapeAsByte).parse(instance.getProtocolType(), sink);
            sink.putByte((byte)0);
            Verify.verify((!instance.parseFrom(sink.array(), 0, sink.position()) ? 1 : 0) != 0);
            return instance;
        }
        T result = categoryInformation.parse(sequence, instance);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ProtocolMessage<? super T>> List<T> loadFromFile(String filename, String separator, Class<T> protoClass) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(filename);){
            List<T> list = ProtocolTextParser.loadFromStream(inputStream, separator, protoClass);
            return list;
        }
    }

    private static <T extends ProtocolMessage<? super T>> List<T> loadFromStreamInternal(InputStream stream, String separator, Class<T> protoClass, boolean strictParse, boolean interpretOctOrHexEscapeAsByte) throws IOException {
        ArrayList<T> values = new ArrayList<T>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            StringBuilder currentProtoAsString = new StringBuilder();
            while (true) {
                String line;
                if ((line = reader.readLine()) != null && !line.trim().equals(separator)) {
                    if (line.startsWith("#")) continue;
                    currentProtoAsString.append(line).append('\n');
                    continue;
                }
                String s = currentProtoAsString.toString();
                if (!Strings.isNullOrEmpty((String)s)) {
                    try {
                        Object msg = interpretOctOrHexEscapeAsByte ? ProtocolTextParser.parseCppCompatible(s, protoClass) : ProtocolTextParser.parse((CharSequence)s, protoClass);
                        values.add(msg);
                    }
                    catch (RuntimeException exc) {
                        if (strictParse) {
                            throw exc;
                        }
                        logger.logp(Level.WARNING, "com.google.io.protocol.ProtocolTextParser", "loadFromStreamInternal", "Error parsing protocol buffer: " + exc.getMessage());
                    }
                }
                if (line == null) {
                    break;
                }
                currentProtoAsString = new StringBuilder();
            }
        }
        return values;
    }

    public static <T extends ProtocolMessage<T>> List<T> loadFromFileStrict(String filename, String separator, Class<T> protoClass) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(filename);){
            List<T> list = ProtocolTextParser.loadFromStreamStrict(inputStream, separator, protoClass);
            return list;
        }
    }

    public static <T extends ProtocolMessage<T>> List<T> loadFromFileStrictCppCompatible(String filename, String separator, Class<T> protoClass) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(filename);){
            List<T> list = ProtocolTextParser.loadFromStreamStrictCppCompatible(inputStream, separator, protoClass);
            return list;
        }
    }

    public static <T extends ProtocolMessage<? super T>> List<T> loadFromStream(InputStream stream, String separator, Class<T> protoClass) throws IOException {
        return ProtocolTextParser.loadFromStreamInternal(stream, separator, protoClass, false, false);
    }

    public static <T extends ProtocolMessage<T>> List<T> loadFromStreamStrict(InputStream stream, String separator, Class<T> protoClass) throws IOException {
        return ProtocolTextParser.loadFromStreamInternal(stream, separator, protoClass, true, false);
    }

    public static <T extends ProtocolMessage<T>> List<T> loadFromStreamStrictCppCompatible(InputStream stream, String separator, Class<T> protoClass) throws IOException {
        return ProtocolTextParser.loadFromStreamInternal(stream, separator, protoClass, true, true);
    }

    private ProtocolTextParser(CharSequence sequence, boolean ignoreUndefinedTags, boolean interpretOctOrHexEscapeAsByte) {
        this.in = new Scanner(sequence);
        this.in.consume(PATTERN_COMMENTS);
        this.ignoreUndefinedTags = ignoreUndefinedTags;
        this.interpretOctOrHexEscapeAsByte = interpretOctOrHexEscapeAsByte;
    }

    private void parse(ProtocolType protocolType, GrowableProtocolSink sink) {
        boolean isRawMessage;
        Class<? extends ProtocolMessage<?>> protocolMessageClass = protocolType.getProtocolMessageClass();
        boolean isMessageSet = protocolMessageClass == MessageSet.class;
        boolean bl = isRawMessage = protocolMessageClass == RawMessage.class;
        while (!(this.in.lookingAt(PATTERN_END) || this.in.lookingAt(PATTERN_RBRACE) || this.in.lookingAt(PATTERN_RANGLE))) {
            if (isRawMessage) {
                this.parseByteInRawMessage(sink);
                continue;
            }
            if (isMessageSet) {
                this.parseMessageInMessageSet(sink);
                continue;
            }
            this.parseSlot(protocolType, sink);
        }
        this.in.consume(PATTERN_END);
    }

    void parseSlot(ProtocolType protocolType, GrowableProtocolSink sink) {
        ProtocolType.FieldType tagInfo = null;
        String matchedTagId = null;
        if (this.in.consume(PATTERN_ID)) {
            matchedTagId = this.in.getMatch();
            tagInfo = protocolType.getTagInfo(matchedTagId);
            if (tagInfo == null) {
                if (this.ignoreUndefinedTags) {
                    this.in.consume(PATTERN_SEPARATOR);
                    if (this.skipValue()) {
                        return;
                    }
                    this.error("Unable to skip tag \"%s\"", matchedTagId);
                } else {
                    this.error("Unknown field \"%s\"", matchedTagId);
                }
            }
        } else if (this.in.consume(PATTERN_INT)) {
            matchedTagId = this.in.getMatch();
            int tag = Integer.parseInt(matchedTagId, 10);
            tagInfo = protocolType.getTagInfo(tag);
            if (tagInfo == null) {
                this.error("Unknown tag \"%d\"", tag);
            }
        } else {
            this.error("Missing field tag", new Object[0]);
        }
        if (tagInfo.getPresence() == ProtocolType.Presence.REPEATED) {
            this.in.consume(PATTERN_OPTIONAL_INDEX);
        }
        this.in.consume(PATTERN_SEPARATOR);
        try {
            this.parseValues(tagInfo, sink);
        }
        catch (RuntimeException e) {
            this.error(e, "While processing %s at %s", matchedTagId, this.in.toString());
        }
        this.in.consume(PATTERN_TERMINATOR);
    }

    private void parseMessageInMessageSet(GrowableProtocolSink sink) {
        Class<? extends ProtocolMessage> clazz;
        if (!this.in.consume(PATTERN_LSQUARE)) {
            this.error("Expected to see a left square bracket", new Object[0]);
        }
        if (!this.in.consume(PATTERN_CLASS_NAME)) {
            this.error("Expected to see a class name", new Object[0]);
        }
        String className = this.in.getMatch();
        if (!this.in.consume(PATTERN_RSQUARE)) {
            this.error("expected to see a right square bracket", new Object[0]);
        }
        if ((clazz = MessageSet.findClass(className)) == null) {
            this.error("Cannot find class \"%s\"", className);
        }
        int typeId = MessageSet.getTypeId(clazz);
        MessageSet.outputTo(sink, typeId, this.parseForeign(clazz));
    }

    private void parseByteInRawMessage(GrowableProtocolSink sink) {
        String match;
        if (!this.in.consume(PATTERN_INT)) {
            this.error("Expected byte value", new Object[0]);
        }
        byte value = (match = this.in.getMatch()).startsWith("0x") || match.startsWith("0X") ? (byte)Integer.parseInt(match.substring(2), 16) : (byte)Integer.parseInt(match, 10);
        sink.putByte(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseValues(ProtocolType.FieldType tagInfo, GrowableProtocolSink sink) {
        if (tagInfo.getPresence() == ProtocolType.Presence.REPEATED && this.in.consume(PATTERN_LSQUARE)) {
            do {
                this.parseValue(tagInfo, sink);
                if (this.in.consume(PATTERN_RSQUARE)) return;
            } while (this.in.consume(PATTERN_COMMA));
            throw new IllegalStateException("Mult-valued repeated field must be separated by ',' or terminated by ']'");
        }
        this.parseValue(tagInfo, sink);
    }

    private void parseValue(ProtocolType.FieldType tagInfo, GrowableProtocolSink sink) {
        sink.putVarInt(tagInfo.getWireTag());
        switch (tagInfo.getBaseType()) {
            case FIXED32: 
            case INT32: {
                int value;
                if (this.in.consume(PATTERN_INT)) {
                    String match = this.in.getMatch();
                    long longValue = match.startsWith("0x") || match.startsWith("0X") ? Long.parseLong(match.substring(2), 16) : Long.parseLong(match);
                    if (longValue > 0xFFFFFFFFL || longValue < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Input string \"" + match + "\" is bigger than 32 bit");
                    }
                    value = (int)longValue;
                } else if (this.in.consume(PATTERN_ID)) {
                    String enumValue = this.in.getMatch();
                    try {
                        Field valueField = tagInfo.getEnumType() != null ? tagInfo.getEnumType().getField(enumValue) : tagInfo.getParentClass().getField(enumValue);
                        Object valueObject = valueField.get(null);
                        if (valueObject instanceof ProtocolMessageEnum) {
                            value = ((ProtocolMessageEnum)valueObject).getValue();
                        }
                        value = (Integer)valueObject;
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (NoSuchFieldException e) {
                        throw new IllegalStateException(e);
                    }
                } else {
                    value = 0;
                    this.error("Expected integer or long", new Object[0]);
                }
                if (tagInfo.getBaseType().isFixed()) {
                    sink.putInt(value);
                    break;
                }
                sink.putVarInt(value);
                break;
            }
            case INT64: {
                String match;
                if (!this.in.consume(PATTERN_INT)) {
                    this.error("Expected integer or long", new Object[0]);
                }
                long value = (match = this.in.getMatch()).startsWith("0x") || match.startsWith("0X") ? UnsignedLongs.parseUnsignedLong((String)match.substring(2), (int)16) : Long.parseLong(match, 10);
                if (tagInfo.getBaseType().isFixed()) {
                    sink.putLong(value);
                    break;
                }
                sink.putVarLong(value);
                break;
            }
            case FIXED64: 
            case UINT64: {
                String match;
                if (!this.in.consume(PATTERN_INT)) {
                    this.error("Expected integer or long", new Object[0]);
                }
                long value = (match = this.in.getMatch()).startsWith("0x") || match.startsWith("0X") ? UnsignedLongs.parseUnsignedLong((String)match.substring(2), (int)16) : (match.startsWith("-") ? Long.parseLong(match, 10) : UnsignedLongs.parseUnsignedLong((String)match, (int)10));
                if (tagInfo.getBaseType().isFixed()) {
                    sink.putLong(value);
                    break;
                }
                sink.putVarLong(value);
                break;
            }
            case BOOL: {
                if (this.in.consume(PATTERN_ID)) {
                    boolean value;
                    String id = this.in.getMatch();
                    if (Ascii.equalsIgnoreCase((CharSequence)id, (CharSequence)"t") || Ascii.equalsIgnoreCase((CharSequence)id, (CharSequence)"true")) {
                        value = true;
                    } else if (Ascii.equalsIgnoreCase((CharSequence)id, (CharSequence)"f") || Ascii.equalsIgnoreCase((CharSequence)id, (CharSequence)"false")) {
                        value = false;
                    } else {
                        value = false;
                        this.error("Bad value for boolean", new Object[0]);
                    }
                    sink.putByte(value ? (byte)1 : 0);
                    break;
                }
                if (!this.in.consume(PATTERN_INT)) break;
                int value = Integer.parseInt(this.in.getMatch());
                if (value != 0 && value != 1) {
                    this.error("Bad value for boolean", new Object[0]);
                }
                sink.putByte((byte)value);
                break;
            }
            case GROUP: {
                char starter;
                if (!this.in.consume(PATTERN_LANGLE_OR_LBRACE)) {
                    this.error("Missing left brace or left angle bracket", new Object[0]);
                }
                Pattern ender = (starter = this.in.getMatch().charAt(0)) == '<' ? PATTERN_RANGLE : PATTERN_RBRACE;
                this.parse(ProtocolSupport.newInstance(tagInfo.getSubclass()).getProtocolType(), sink);
                if (!this.in.consume(ender)) {
                    this.error("Missing closing right brace or angle bracket", new Object[0]);
                }
                sink.putVarInt(tagInfo.getWireTag() + 1);
                break;
            }
            case FOREIGN: {
                GrowableProtocolSink newSink = this.parseForeign(tagInfo.getSubclass());
                sink.putVarInt(newSink.position());
                sink.putBytes(newSink.array(), 0, newSink.position());
                break;
            }
            case STRING: {
                byte[] bytes = this.parseStringValue();
                sink.putVarInt(bytes.length);
                sink.putBytes(bytes);
                break;
            }
            case DOUBLE: {
                if (this.in.consume(PATTERN_FLOAT)) {
                    String match = this.in.getMatch();
                    sink.putDouble(Double.parseDouble(match));
                    break;
                }
                if (this.in.consume(PATTERN_INFINITY)) {
                    String match = this.in.getMatch();
                    sink.putDouble(match.charAt(0) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                    break;
                }
                if (this.in.consume(PATTERN_NAN)) {
                    sink.putDouble(Double.NaN);
                    break;
                }
                this.error("Expected double", new Object[0]);
                break;
            }
            case FLOAT: {
                if (this.in.consume(PATTERN_FLOAT)) {
                    String match = this.in.getMatch();
                    sink.putFloat(Float.parseFloat(match));
                    break;
                }
                if (this.in.consume(PATTERN_INFINITY)) {
                    String match = this.in.getMatch();
                    sink.putFloat(match.charAt(0) == '-' ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                    break;
                }
                if (this.in.consume(PATTERN_NAN)) {
                    sink.putFloat(Float.NaN);
                    break;
                }
                this.error("Expected float", new Object[0]);
            }
        }
    }

    private GrowableProtocolSink parseForeign(Class<? extends ProtocolMessage> clazz) {
        GrowableProtocolSink sink = new GrowableProtocolSink();
        if (this.in.consume(PATTERN_LANGLE_OR_LBRACE)) {
            char starter = this.in.getMatch().charAt(0);
            Pattern ender = starter == '<' ? PATTERN_RANGLE : PATTERN_RBRACE;
            this.parse(ProtocolSupport.newInstance(clazz).getProtocolType(), sink);
            if (!this.in.consume(ender)) {
                this.error("Missing closing right brace or angle bracket", new Object[0]);
            }
        } else if (clazz == RawMessage.class) {
            byte[] bytes = this.parseStringValue();
            sink.putBytes(bytes);
        } else {
            this.error("Missing left brace or left angle bracket", new Object[0]);
        }
        return sink;
    }

    private byte[] parseStringValue() {
        ArrayList byteList = Lists.newArrayList();
        this.in.disableSkip();
        if (!this.in.consume(PATTERN_DQUOTE)) {
            this.addOneStringPieceToByteList(PATTERN_NEWLINE, PATTERN_NEWLINE_TERMINATED_SIMPLE_STRING, byteList);
        } else {
            do {
                this.addOneStringPieceToByteList(PATTERN_DQUOTE, PATTERN_SIMPLE_STRING, byteList);
                this.in.enableSkip();
                this.in.disableSkip();
            } while (this.in.consume(PATTERN_DQUOTE));
        }
        this.in.enableSkip();
        byte[] byteArray = new byte[byteList.size()];
        int i = 0;
        for (Byte b : byteList) {
            byteArray[i] = b;
            ++i;
        }
        return byteArray;
    }

    private void addOneStringPieceToByteList(Pattern endOfStringPattern, Pattern simpleStringPattern, List<Byte> byteList) {
        while (!this.in.consume(endOfStringPattern)) {
            if (this.in.consume(simpleStringPattern)) {
                this.addToByteList(this.in.getMatch(), byteList);
                continue;
            }
            if (this.in.consume(PATTERN_SINGLE_CHAR_ESCAPE_SEQ)) {
                this.addToByteList(this.parseEscapedChar(this.in.getMatch()), byteList);
                continue;
            }
            if (this.in.consume(PATTERN_SINGLE_BYTE_ESCAPE_SEQ)) {
                if (this.interpretOctOrHexEscapeAsByte) {
                    this.addToByteList(this.parseEscapedByte(this.in.getMatch()), byteList);
                    continue;
                }
                this.addToByteList(this.parseEscapedChar(this.in.getMatch()), byteList);
                continue;
            }
            this.error("error handling string", new Object[0]);
        }
    }

    private void addToByteList(String str, List<Byte> dest) {
        for (int i = 0; i < str.length(); ++i) {
            this.addToByteList(str.charAt(i), dest);
        }
    }

    private void addToByteList(char c, List<Byte> dest) {
        this.addToByteList(String.valueOf(c).getBytes(StandardCharsets.UTF_8), dest);
    }

    private void addToByteList(byte[] bytes, List<Byte> dest) {
        for (int i = 0; i < bytes.length; ++i) {
            this.addToByteList(bytes[i], dest);
        }
    }

    private void addToByteList(byte b, List<Byte> dest) {
        dest.add(b);
    }

    private char parseEscapedChar(String string) {
        assert (string.length() >= 2);
        assert (string.charAt(0) == '\\');
        switch (string.charAt(1)) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '\"': 
            case '\'': 
            case '\\': {
                return string.charAt(1);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return (char)Integer.parseInt(string.substring(1), 8);
            }
            case 'U': 
            case 'X': 
            case 'u': 
            case 'x': {
                return (char)Integer.parseInt(string.substring(2), 16);
            }
        }
        this.error("Should not reach here!", new Object[0]);
        return '\u0000';
    }

    private byte parseEscapedByte(String string) {
        assert (string.length() >= 2);
        assert (string.charAt(0) == '\\');
        int value = 0;
        switch (string.charAt(1)) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                value = Integer.parseInt(string.substring(1), 8);
                break;
            }
            case 'X': 
            case 'x': {
                value = Integer.parseInt(string.substring(2), 16);
                break;
            }
            default: {
                this.error("Should not reach here!", new Object[0]);
                return 0;
            }
        }
        if (value > 255) {
            logger.logp(Level.WARNING, "com.google.io.protocol.ProtocolTextParser", "parseEscapedByte", "The value of " + string + " exceeds 8 bits");
        }
        return (byte)value;
    }

    @FormatMethod
    private void error(Exception e, String format, Object ... args) {
        throw new RuntimeException(String.format("Line %d: ", this.in.getLineNumber()) + String.format(format, args), e);
    }

    @FormatMethod
    private void error(String format, Object ... args) {
        this.error(null, format, args);
    }

    private boolean skipValue() {
        if (this.in.consume(PATTERN_FLOAT) || this.in.consume(PATTERN_INT) || this.in.consume(PATTERN_ID)) {
            return true;
        }
        if (this.in.lookingAt(PATTERN_DQUOTE)) {
            this.parseStringValue();
            return true;
        }
        if (this.in.consume(PATTERN_LBRACE)) {
            while (!this.in.lookingAt(PATTERN_RBRACE)) {
                this.skipName();
                this.in.consume(PATTERN_SEPARATOR);
                this.skipValue();
                this.in.consume(PATTERN_TERMINATOR);
            }
            return true;
        }
        if (this.in.consume(PATTERN_LANGLE_OR_LBRACE)) {
            while (!this.in.lookingAt(PATTERN_RANGLE)) {
                this.skipName();
                this.in.consume(PATTERN_SEPARATOR);
                this.skipValue();
                this.in.consume(PATTERN_TERMINATOR);
            }
            this.in.consume(PATTERN_RANGLE);
            return true;
        }
        return false;
    }

    private void skipName() {
        if (this.in.consume(PATTERN_LSQUARE)) {
            if (!this.in.consume(PATTERN_CLASS_NAME)) {
                this.in.consume(PATTERN_OPTIONAL_INDEX);
            }
            this.in.consume(PATTERN_RSQUARE);
        } else {
            if (!this.in.consume(PATTERN_ID)) {
                this.in.consume(PATTERN_TAG);
            }
            while (this.in.lookingAt(PATTERN_DOT)) {
                this.in.consume(PATTERN_DOT);
                this.in.consume(PATTERN_ID);
            }
        }
    }

    static class Scanner {
        private final CharSequence sequence;
        private final int stringLength;
        private int currentPosition;
        private int lineNumber;
        private final Matcher normalMatcher;
        private final Matcher commentSkipper;
        private boolean skipComments;

        Scanner(CharSequence string) {
            this.sequence = string;
            this.stringLength = string.length();
            this.currentPosition = 0;
            this.lineNumber = 1;
            this.normalMatcher = PATTERN_COMMENTS.matcher(string);
            this.commentSkipper = PATTERN_COMMENTS.matcher(string);
            this.skipComments = true;
        }

        boolean lookingAt(Pattern pattern) {
            Matcher matcher = this.normalMatcher;
            matcher.usePattern(pattern);
            matcher.region(this.currentPosition, this.stringLength);
            return matcher.lookingAt();
        }

        boolean consume(Pattern pattern) {
            Matcher matcher = this.normalMatcher;
            matcher.usePattern(pattern);
            matcher.region(this.currentPosition, this.stringLength);
            int formerPosition = this.currentPosition;
            boolean result = matcher.lookingAt();
            if (result) {
                this.currentPosition = matcher.end();
                if (this.skipComments) {
                    this.commentSkipper.region(this.currentPosition, this.stringLength);
                    if (this.commentSkipper.lookingAt()) {
                        this.currentPosition = this.commentSkipper.end();
                    }
                }
            }
            for (int i = formerPosition; i < this.currentPosition; ++i) {
                if (this.sequence.charAt(i) != '\n') continue;
                ++this.lineNumber;
            }
            return result;
        }

        String getMatch() {
            return this.normalMatcher.group();
        }

        public String toString() {
            int context = 20;
            CharSequence prefix = this.currentPosition > context ? "..." + this.sequence.subSequence(this.currentPosition - context, this.currentPosition) : this.sequence.subSequence(0, this.currentPosition);
            CharSequence suffix = this.currentPosition < this.stringLength - context ? this.sequence.subSequence(this.currentPosition, this.currentPosition + context) + "..." : this.sequence.subSequence(this.currentPosition, this.stringLength);
            return prefix + " ### " + suffix;
        }

        private void disableSkip() {
            this.skipComments = false;
        }

        private void enableSkip() {
            this.skipComments = true;
            this.commentSkipper.region(this.currentPosition, this.stringLength);
            if (this.commentSkipper.lookingAt()) {
                this.currentPosition = this.commentSkipper.end();
            }
        }

        private int getLineNumber() {
            return this.lineNumber;
        }
    }
}

